/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener;

import java.util.Collection;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.minestom.server.MinecraftServer;
import net.minestom.server.command.CommandManager;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.player.PlayerChatEvent;
import net.minestom.server.message.ChatPosition;
import net.minestom.server.message.Messenger;
import net.minestom.server.network.ConnectionManager;
import net.minestom.server.network.packet.client.play.ClientChatMessagePacket;
import net.minestom.server.network.packet.client.play.ClientCommandChatPacket;
import org.jetbrains.annotations.NotNull;

public class ChatMessageListener {
    private static final CommandManager COMMAND_MANAGER = MinecraftServer.getCommandManager();
    private static final ConnectionManager CONNECTION_MANAGER = MinecraftServer.getConnectionManager();

    public static void commandChatListener(ClientCommandChatPacket packet, Player player) {
        String command = packet.message();
        if (Messenger.canReceiveCommand(player)) {
            COMMAND_MANAGER.execute(player, command);
        } else {
            Messenger.sendRejectionMessage(player);
        }
    }

    public static void chatMessageListener(ClientChatMessagePacket packet, Player player) {
        String message = packet.message();
        if (!Messenger.canReceiveMessage(player)) {
            Messenger.sendRejectionMessage(player);
            return;
        }
        Collection<Player> players = CONNECTION_MANAGER.getOnlinePlayers();
        PlayerChatEvent playerChatEvent = new PlayerChatEvent(player, players, () -> ChatMessageListener.buildDefaultChatMessage(player, message), message);
        EventDispatcher.callCancellable(playerChatEvent, () -> {
            Function<PlayerChatEvent, Component> formatFunction = playerChatEvent.getChatFormatFunction();
            Component textObject = formatFunction != null ? formatFunction.apply(playerChatEvent) : playerChatEvent.getDefaultChatFormat().get();
            Collection<Player> recipients = playerChatEvent.getRecipients();
            if (!recipients.isEmpty()) {
                Messenger.sendMessage(recipients, textObject, ChatPosition.CHAT, player.getUuid());
            }
        });
    }

    @NotNull
    private static Component buildDefaultChatMessage(@NotNull Player player, @NotNull String message) {
        String username = player.getUsername();
        return Component.translatable((String)"chat.type.text").args(new ComponentLike[]{((TextComponent)((TextComponent)Component.text((String)username).insertion(username)).clickEvent(ClickEvent.suggestCommand((String)("/msg " + username + " ")))).hoverEvent((HoverEventSource)player), Component.text((String)message)});
    }
}

