/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.metadata;

import java.util.List;
import net.minestom.server.color.Color;
import net.minestom.server.item.ItemMetaView;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.tag.TagSerializer;
import net.minestom.server.tag.TagWritable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public record MapMeta(TagReadable readable) implements ItemMetaView<Builder>
{
    private static final Tag<Integer> MAP_ID = Tag.Integer("map").defaultValue(0);
    private static final Tag<Integer> MAP_SCALE_DIRECTION = Tag.Integer("map_scale_direction").defaultValue(0);
    private static final Tag<List<Decoration>> DECORATIONS = Tag.Structure("Decorations", new TagSerializer<Decoration>(){

        @Override
        @Nullable
        public Decoration read(@NotNull TagReadable reader) {
            String id = reader.getTag(Tag.String("id"));
            Byte type = reader.getTag(Tag.Byte("type"));
            Byte x = reader.getTag(Tag.Byte("x"));
            Byte z = reader.getTag(Tag.Byte("z"));
            Double rot = reader.getTag(Tag.Double("rot"));
            if (id == null || type == null || x == null || z == null || rot == null) {
                return null;
            }
            return new Decoration(id, type, x, z, rot);
        }

        @Override
        public void write(@NotNull TagWritable writer, @NotNull Decoration value) {
            writer.setTag(Tag.String("id"), value.id);
            writer.setTag(Tag.Byte("type"), value.type);
            writer.setTag(Tag.Byte("x"), value.x);
            writer.setTag(Tag.Byte("z"), value.z);
            writer.setTag(Tag.Double("rot"), value.rotation);
        }
    }).list().defaultValue(List.of());
    private static final Tag<Color> MAP_COLOR = Tag.Integer("MapColor").path("display").map(Color::new, Color::asRGB);

    public int getMapId() {
        return this.getTag(MAP_ID);
    }

    public int getMapScaleDirection() {
        return this.getTag(MAP_SCALE_DIRECTION);
    }

    public List<Decoration> getDecorations() {
        return this.getTag(DECORATIONS);
    }

    @NotNull
    public Color getMapColor() {
        return this.getTag(MAP_COLOR);
    }

    @Override
    public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        return this.readable.getTag(tag);
    }

    public record Decoration(String id, byte type, byte x, byte z, double rotation) {
    }

    public record Builder(TagHandler tagHandler) implements ItemMetaView.Builder
    {
        public Builder() {
            this(TagHandler.newHandler());
        }

        public Builder mapId(int value) {
            this.setTag(MAP_ID, value);
            return this;
        }

        public Builder mapScaleDirection(int value) {
            this.setTag(MAP_SCALE_DIRECTION, value);
            return this;
        }

        public Builder decorations(List<Decoration> value) {
            this.setTag(DECORATIONS, value);
            return this;
        }

        public Builder mapColor(Color value) {
            this.setTag(MAP_COLOR, value);
            return this;
        }
    }
}

