/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.firework;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minestom.server.color.Color;
import net.minestom.server.item.firework.FireworkEffectType;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTIntArray;

public record FireworkEffect(boolean flicker, boolean trail, @NotNull FireworkEffectType type, @NotNull List<Color> colors, @NotNull List<Color> fadeColors) {
    public FireworkEffect(boolean flicker, boolean trail, @NotNull FireworkEffectType type, @NotNull List<Color> colors, @NotNull List<Color> fadeColors) {
        colors = List.copyOf(colors);
        fadeColors = List.copyOf(fadeColors);
    }

    @NotNull
    public static FireworkEffect fromCompound(@NotNull NBTCompound compound) {
        int rgb;
        ArrayList<Color> primaryColor = new ArrayList<Color>();
        ArrayList<Color> secondaryColor = new ArrayList<Color>();
        Object object = compound.get("Colors");
        if (object instanceof NBTIntArray) {
            NBTIntArray colors = (NBTIntArray)object;
            object = colors.iterator();
            while (object.hasNext()) {
                rgb = (Integer)object.next();
                primaryColor.add(new Color(rgb));
            }
        }
        if ((object = compound.get("FadeColors")) instanceof NBTIntArray) {
            NBTIntArray fadeColors = (NBTIntArray)object;
            object = fadeColors.iterator();
            while (object.hasNext()) {
                rgb = (Integer)object.next();
                secondaryColor.add(new Color(rgb));
            }
        }
        boolean flicker = compound.containsKey("Flicker") && compound.getBoolean("Flicker") != false;
        boolean trail = compound.containsKey("Trail") && compound.getBoolean("Trail") != false;
        FireworkEffectType type = compound.containsKey("Type") ? FireworkEffectType.byId(compound.getAsByte("Type")) : FireworkEffectType.SMALL_BALL;
        return new FireworkEffect(flicker, trail, type, primaryColor, secondaryColor);
    }

    @NotNull
    public NBTCompound asCompound() {
        return NBT.Compound(Map.of("Flicker", NBT.Boolean((boolean)this.flicker), "Trail", NBT.Boolean((boolean)this.trail), "Type", NBT.Byte((byte)this.type.getType()), "Colors", NBT.IntArray((int[])this.colors.stream().mapToInt(Color::asRGB).toArray()), "FadeColors", NBT.IntArray((int[])this.fadeColors.stream().mapToInt(Color::asRGB).toArray())));
    }
}

