/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.light;

import it.unimi.dsi.fastutil.shorts.ShortArrayFIFOQueue;
import java.util.HashSet;
import java.util.Set;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.light.Light;
import net.minestom.server.instance.light.LightCompute;
import net.minestom.server.instance.palette.Palette;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

final class BlockLight
implements Light {
    private final Palette blockPalette;
    private byte[] content;
    private byte[] contentPropagation;
    private byte[] contentPropagationSwap;
    private boolean isValidBorders = false;
    private boolean needsSend = true;
    private Set<Point> toUpdateSet = new HashSet<Point>();
    private final Section[] neighborSections = new Section[BlockFace.values().length];

    BlockLight(Palette blockPalette) {
        this.blockPalette = blockPalette;
    }

    @ApiStatus.Internal
    public void setInternalLighting(byte[] content) {
        this.content = content;
        this.isValidBorders = true;
    }

    @ApiStatus.Internal
    public void setExternalLighting(byte[] content) {
        this.contentPropagation = content;
    }

    @ApiStatus.Internal
    public byte[] getInternalLighting() {
        return this.content;
    }

    @ApiStatus.Internal
    public byte[] getExternalLighting() {
        return this.contentPropagation;
    }

    @Override
    public Set<Point> flip() {
        if (this.contentPropagationSwap != null) {
            this.contentPropagation = this.contentPropagationSwap;
        }
        this.contentPropagationSwap = null;
        if (this.toUpdateSet == null) {
            return Set.of();
        }
        return this.toUpdateSet;
    }

    static ShortArrayFIFOQueue buildInternalQueue(Palette blockPalette) {
        ShortArrayFIFOQueue lightSources = new ShortArrayFIFOQueue();
        blockPalette.getAllPresent((x, y, z, stateId) -> {
            Block block = Block.fromStateId((short)stateId);
            assert (block != null);
            byte lightEmission = (byte)block.registry().lightEmission();
            int index = x | z << 4 | y << 8;
            if (lightEmission > 0) {
                lightSources.enqueue((short)(index | lightEmission << 12));
            }
        });
        return lightSources;
    }

    private static Block getBlock(Palette palette, int x, int y, int z) {
        return Block.fromStateId((short)palette.get(x, y, z));
    }

    private ShortArrayFIFOQueue buildExternalQueue(Instance instance, Palette blockPalette, Point[] neighbors, byte[] content) {
        ShortArrayFIFOQueue lightSources = new ShortArrayFIFOQueue();
        for (int i = 0; i < neighbors.length; ++i) {
            BlockFace face = BlockFace.values()[i];
            Point neighborSection = neighbors[i];
            if (neighborSection == null) continue;
            Section otherSection = this.neighborSections[face.ordinal()];
            if (otherSection == null) {
                Chunk chunk = instance.getChunk(neighborSection.blockX(), neighborSection.blockZ());
                if (chunk == null) continue;
                this.neighborSections[face.ordinal()] = otherSection = chunk.getSection(neighborSection.blockY());
            }
            Light otherLight = otherSection.blockLight();
            for (int bx = 0; bx < 16; ++bx) {
                for (int by = 0; by < 16; ++by) {
                    Block blockFrom;
                    byte internalEmission;
                    int posTo;
                    int k = switch (face) {
                        default -> throw new IncompatibleClassChangeError();
                        case BlockFace.WEST, BlockFace.BOTTOM, BlockFace.NORTH -> 0;
                        case BlockFace.EAST, BlockFace.TOP, BlockFace.SOUTH -> 15;
                    };
                    byte lightEmission = (byte)Math.max((switch (face) {
                        case BlockFace.NORTH, BlockFace.SOUTH -> (byte)otherLight.getLevel(bx, by, 15 - k);
                        case BlockFace.WEST, BlockFace.EAST -> (byte)otherLight.getLevel(15 - k, bx, by);
                        default -> (byte)otherLight.getLevel(bx, 15 - k, by);
                    }) - 1, 0);
                    switch (face) {
                        case NORTH: 
                        case SOUTH: {
                            int n = bx | k << 4 | by << 8;
                            break;
                        }
                        case WEST: 
                        case EAST: {
                            int n = k | by << 4 | bx << 8;
                            break;
                        }
                        default: {
                            int n = posTo = bx | by << 4 | k << 8;
                        }
                    }
                    if (content != null && lightEmission <= (internalEmission = (byte)Math.max(LightCompute.getLight(content, posTo) - 1, 0))) continue;
                    Block blockTo = switch (face) {
                        case BlockFace.NORTH, BlockFace.SOUTH -> BlockLight.getBlock(blockPalette, bx, by, k);
                        case BlockFace.WEST, BlockFace.EAST -> BlockLight.getBlock(blockPalette, k, bx, by);
                        default -> BlockLight.getBlock(blockPalette, bx, k, by);
                    };
                    switch (face) {
                        case NORTH: 
                        case SOUTH: {
                            Block block = BlockLight.getBlock(otherSection.blockPalette(), bx, by, 15 - k);
                            break;
                        }
                        case WEST: 
                        case EAST: {
                            Block block = BlockLight.getBlock(otherSection.blockPalette(), 15 - k, bx, by);
                            break;
                        }
                        default: {
                            Block block = blockFrom = BlockLight.getBlock(otherSection.blockPalette(), bx, 15 - k, by);
                        }
                    }
                    if (blockTo == null && blockFrom != null) {
                        if (blockFrom.registry().collisionShape().isOccluded(Block.AIR.registry().collisionShape(), face.getOppositeFace())) {
                            continue;
                        }
                    } else if (blockTo == null || blockFrom != null ? blockTo != null && blockFrom != null && blockFrom.registry().collisionShape().isOccluded(blockTo.registry().collisionShape(), face.getOppositeFace()) : Block.AIR.registry().collisionShape().isOccluded(blockTo.registry().collisionShape(), face)) continue;
                    if (lightEmission <= 0) continue;
                    int index = posTo | lightEmission << 12;
                    lightSources.enqueue((short)index);
                }
            }
        }
        return lightSources;
    }

    @Override
    public void copyFrom(byte @NotNull [] array) {
        this.content = (byte[])(array.length == 0 ? null : (byte[])array.clone());
    }

    @Override
    public Light calculateInternal(Instance instance, int chunkX, int sectionY, int chunkZ) {
        Chunk chunk = instance.getChunk(chunkX, chunkZ);
        if (chunk == null) {
            this.toUpdateSet = Set.of();
            return this;
        }
        this.isValidBorders = true;
        HashSet<Point> toUpdate = new HashSet<Point>();
        ShortArrayFIFOQueue queue = BlockLight.buildInternalQueue(this.blockPalette);
        LightCompute.Result result = LightCompute.compute(this.blockPalette, queue);
        this.content = result.light();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                Chunk neighborChunk = instance.getChunk(chunkX + i, chunkZ + j);
                if (neighborChunk == null) continue;
                for (int k = -1; k <= 1; ++k) {
                    Vec neighborPos = new Vec(chunkX + i, sectionY + k, chunkZ + j);
                    if (neighborPos.blockY() < neighborChunk.getMinSection() || neighborPos.blockY() >= neighborChunk.getMaxSection()) continue;
                    toUpdate.add(new Vec(neighborChunk.getChunkX(), neighborPos.blockY(), neighborChunk.getChunkZ()));
                    neighborChunk.getSection(neighborPos.blockY()).blockLight().invalidatePropagation();
                }
            }
        }
        toUpdate.add(new Vec(chunk.getChunkX(), sectionY, chunk.getChunkZ()));
        this.toUpdateSet = toUpdate;
        return this;
    }

    @Override
    public void invalidate() {
        this.invalidatePropagation();
    }

    @Override
    public boolean requiresUpdate() {
        return !this.isValidBorders;
    }

    @Override
    public void set(byte[] copyArray) {
        this.content = (byte[])copyArray.clone();
    }

    @Override
    public boolean requiresSend() {
        boolean res = this.needsSend;
        this.needsSend = false;
        return res;
    }

    @Override
    public void setRequiresSend(boolean b) {
        this.needsSend = b;
    }

    private void clearCache() {
        this.contentPropagation = null;
        this.isValidBorders = true;
        this.needsSend = true;
    }

    @Override
    public byte[] array() {
        if (this.content == null) {
            return new byte[0];
        }
        if (this.contentPropagation == null) {
            return this.content;
        }
        byte[] res = this.bake(this.contentPropagation, this.content);
        if (res == LightCompute.emptyContent) {
            return new byte[0];
        }
        return res;
    }

    @Override
    public Light calculateExternal(Instance instance, Chunk chunk, int sectionY) {
        if (!this.isValidBorders) {
            this.clearCache();
        }
        Point[] neighbors = Light.getNeighbors(chunk, sectionY);
        ShortArrayFIFOQueue queue = this.buildExternalQueue(instance, this.blockPalette, neighbors, this.content);
        LightCompute.Result result = LightCompute.compute(this.blockPalette, queue);
        byte[] contentPropagationTemp = result.light();
        this.contentPropagationSwap = this.bake(this.contentPropagationSwap, contentPropagationTemp);
        HashSet<Point> toUpdate = new HashSet<Point>();
        for (int i = 0; i < neighbors.length; ++i) {
            BlockFace face;
            Point neighbor = neighbors[i];
            if (neighbor == null || Light.compareBorders(this.content, this.contentPropagation, contentPropagationTemp, face = BlockFace.values()[i])) continue;
            toUpdate.add(neighbor);
        }
        this.toUpdateSet = toUpdate;
        return this;
    }

    private byte[] bake(byte[] content1, byte[] content2) {
        if (content1 == null && content2 == null) {
            return LightCompute.emptyContent;
        }
        if (content1 == LightCompute.emptyContent && content2 == LightCompute.emptyContent) {
            return LightCompute.emptyContent;
        }
        if (content1 == null) {
            return content2;
        }
        if (content2 == null) {
            return content1;
        }
        byte[] lightMax = new byte[2048];
        for (int i = 0; i < content1.length; ++i) {
            byte l1 = (byte)(content1[i] & 0xF);
            byte l2 = (byte)(content2[i] & 0xF);
            byte u1 = (byte)(content1[i] >> 4 & 0xF);
            byte u2 = (byte)(content2[i] >> 4 & 0xF);
            byte lower = (byte)Math.max(l1, l2);
            byte upper = (byte)Math.max(u1, u2);
            lightMax[i] = (byte)(lower | upper << 4);
        }
        return lightMax;
    }

    @Override
    public void invalidatePropagation() {
        this.isValidBorders = false;
        this.needsSend = false;
        this.contentPropagation = null;
    }

    @Override
    public int getLevel(int x, int y, int z) {
        if (this.content == null) {
            return 0;
        }
        int index = x | z << 4 | y << 8;
        if (this.contentPropagation == null) {
            return LightCompute.getLight(this.content, index);
        }
        return Math.max(LightCompute.getLight(this.contentPropagation, index), LightCompute.getLight(this.content, index));
    }
}

