/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.pathfinding;

import com.extollit.gaming.ai.path.model.IBlockObject;
import com.extollit.gaming.ai.path.model.IColumnarSpace;
import com.extollit.gaming.ai.path.model.IInstanceSpace;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minestom.server.entity.pathfinding.PFBlock;
import net.minestom.server.entity.pathfinding.PFColumnarSpace;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.Block;

public final class PFInstanceSpace
implements IInstanceSpace {
    private final Instance instance;
    private final Map<Chunk, PFColumnarSpace> chunkSpaceMap = new ConcurrentHashMap<Chunk, PFColumnarSpace>();

    public PFInstanceSpace(Instance instance) {
        this.instance = instance;
    }

    public IBlockObject blockObjectAt(int x, int y, int z) {
        Block block = this.instance.getBlock(x, y, z);
        return PFBlock.get(block);
    }

    public IColumnarSpace columnarSpaceAt(int cx, int cz) {
        Chunk chunk = this.instance.getChunk(cx, cz);
        if (chunk == null) {
            return null;
        }
        return this.chunkSpaceMap.computeIfAbsent(chunk, c -> {
            PFColumnarSpace cs = new PFColumnarSpace(this, (Chunk)c);
            c.setColumnarSpace(cs);
            return cs;
        });
    }

    public Instance getInstance() {
        return this.instance;
    }
}

