/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.water;

import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.metadata.water.WaterAnimalMeta;
import org.jetbrains.annotations.NotNull;

public class DolphinMeta
extends WaterAnimalMeta {
    public static final byte OFFSET = 16;
    public static final byte MAX_OFFSET = 19;

    public DolphinMeta(@NotNull Entity entity, @NotNull Metadata metadata) {
        super(entity, metadata);
    }

    @NotNull
    public Point getTreasurePosition() {
        return this.metadata.getIndex(16, Vec.ZERO);
    }

    public void setTreasurePosition(@NotNull Point value) {
        this.metadata.setIndex(16, Metadata.Position(value));
    }

    public boolean isHasFish() {
        return this.metadata.getIndex(17, false);
    }

    public void setHasFish(boolean value) {
        this.metadata.setIndex(17, Metadata.Boolean(value));
    }

    public int getMoistureLevel() {
        return this.metadata.getIndex(18, 2400);
    }

    public void setMoistureLevel(int value) {
        this.metadata.setIndex(18, Metadata.VarInt(value));
    }
}

