/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.display;

import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.metadata.display.AbstractDisplayMeta;
import net.minestom.server.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemDisplayMeta
extends AbstractDisplayMeta {
    public static final byte OFFSET = 23;
    public static final byte MAX_OFFSET = 25;

    public ItemDisplayMeta(@NotNull Entity entity, @NotNull Metadata metadata) {
        super(entity, metadata);
    }

    @NotNull
    public ItemStack getItemStack() {
        return this.metadata.getIndex(23, ItemStack.AIR);
    }

    public void setItemStack(@NotNull ItemStack value) {
        this.metadata.setIndex(23, Metadata.Slot(value));
    }

    @NotNull
    public DisplayContext getDisplayContext() {
        return DisplayContext.VALUES[this.metadata.getIndex(24, (byte)0)];
    }

    public void setDisplayContext(@NotNull DisplayContext value) {
        this.metadata.setIndex(24, Metadata.Byte((byte)value.ordinal()));
    }

    public static enum DisplayContext {
        NONE,
        THIRD_PERSON_LEFT_HAND,
        THIRD_PERSON_RIGHT_HAND,
        FIRST_PERSON_LEFT_HAND,
        FIRST_PERSON_RIGHT_HAND,
        HEAD,
        GUI,
        GROUND,
        FIXED;

        private static final DisplayContext[] VALUES;

        static {
            VALUES = DisplayContext.values();
        }
    }
}

