/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal.tameable;

import net.minestom.server.color.DyeColor;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.metadata.animal.tameable.TameableAnimalMeta;
import org.jetbrains.annotations.NotNull;

public class CatMeta
extends TameableAnimalMeta {
    public static final byte OFFSET = 19;
    public static final byte MAX_OFFSET = 23;
    private static final DyeColor[] DYE_VALUES = DyeColor.values();

    public CatMeta(@NotNull Entity entity, @NotNull Metadata metadata) {
        super(entity, metadata);
    }

    @NotNull
    public Variant getVariant() {
        return this.metadata.getIndex(19, Variant.BLACK);
    }

    public void setVariant(@NotNull Variant value) {
        this.metadata.setIndex(19, Metadata.CatVariant(value));
    }

    public boolean isLying() {
        return this.metadata.getIndex(20, false);
    }

    public void setLying(boolean value) {
        this.metadata.setIndex(20, Metadata.Boolean(value));
    }

    public boolean isRelaxed() {
        return this.metadata.getIndex(21, false);
    }

    public void setRelaxed(boolean value) {
        this.metadata.setIndex(21, Metadata.Boolean(value));
    }

    @NotNull
    public DyeColor getCollarColor() {
        return DYE_VALUES[this.metadata.getIndex(22, DyeColor.RED.ordinal())];
    }

    public void setCollarColor(@NotNull DyeColor value) {
        this.metadata.setIndex(22, Metadata.VarInt(value.ordinal()));
    }

    public static enum Variant {
        TABBY,
        BLACK,
        RED,
        SIAMESE,
        BRITISH_SHORTHAIR,
        CALICO,
        PERSIAN,
        RAGDOLL,
        WHITE,
        JELLIE,
        ALL_BLACK;

        private static final Variant[] VALUES;

        static {
            VALUES = Variant.values();
        }
    }
}

