/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata;

import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityMeta {
    public static final byte OFFSET = 0;
    public static final byte MAX_OFFSET = 8;
    private static final byte ON_FIRE_BIT = 1;
    private static final byte CROUCHING_BIT = 2;
    private static final byte SPRINTING_BIT = 8;
    private static final byte SWIMMING_BIT = 16;
    private static final byte INVISIBLE_BIT = 32;
    private static final byte HAS_GLOWING_EFFECT_BIT = 64;
    private static final byte FLYING_WITH_ELYTRA_BIT = -128;
    private final WeakReference<Entity> entityRef;
    protected final Metadata metadata;

    public EntityMeta(@Nullable Entity entity, @NotNull Metadata metadata) {
        this.entityRef = new WeakReference<Entity>(entity);
        this.metadata = metadata;
    }

    public void setNotifyAboutChanges(boolean notifyAboutChanges) {
        this.metadata.setNotifyAboutChanges(notifyAboutChanges);
    }

    public boolean isOnFire() {
        return this.getMaskBit(0, (byte)1);
    }

    public void setOnFire(boolean value) {
        this.setMaskBit(0, (byte)1, value);
    }

    public boolean isSneaking() {
        return this.getMaskBit(0, (byte)2);
    }

    public void setSneaking(boolean value) {
        this.setMaskBit(0, (byte)2, value);
    }

    public boolean isSprinting() {
        return this.getMaskBit(0, (byte)8);
    }

    public void setSprinting(boolean value) {
        this.setMaskBit(0, (byte)8, value);
    }

    public boolean isSwimming() {
        return this.getMaskBit(0, (byte)16);
    }

    public void setSwimming(boolean value) {
        this.setMaskBit(0, (byte)16, value);
    }

    public boolean isInvisible() {
        return this.getMaskBit(0, (byte)32);
    }

    public void setInvisible(boolean value) {
        this.setMaskBit(0, (byte)32, value);
    }

    public boolean isHasGlowingEffect() {
        return this.getMaskBit(0, (byte)64);
    }

    public void setHasGlowingEffect(boolean value) {
        this.setMaskBit(0, (byte)64, value);
    }

    public boolean isFlyingWithElytra() {
        return this.getMaskBit(0, (byte)-128);
    }

    public void setFlyingWithElytra(boolean value) {
        this.setMaskBit(0, (byte)-128, value);
    }

    public int getAirTicks() {
        return this.metadata.getIndex(1, 300);
    }

    public void setAirTicks(int value) {
        this.metadata.setIndex(1, Metadata.VarInt(value));
    }

    public Component getCustomName() {
        return this.metadata.getIndex(2, null);
    }

    public void setCustomName(Component value) {
        this.metadata.setIndex(2, Metadata.OptChat(value));
    }

    public boolean isCustomNameVisible() {
        return this.metadata.getIndex(3, false);
    }

    public void setCustomNameVisible(boolean value) {
        this.metadata.setIndex(3, Metadata.Boolean(value));
    }

    public boolean isSilent() {
        return this.metadata.getIndex(4, false);
    }

    public void setSilent(boolean value) {
        this.metadata.setIndex(4, Metadata.Boolean(value));
    }

    public boolean isHasNoGravity() {
        return this.metadata.getIndex(5, false);
    }

    public void setHasNoGravity(boolean value) {
        this.metadata.setIndex(5, Metadata.Boolean(value));
    }

    public Entity.Pose getPose() {
        return this.metadata.getIndex(6, Entity.Pose.STANDING);
    }

    public void setPose(Entity.Pose value) {
        this.metadata.setIndex(6, Metadata.Pose(value));
    }

    public int getTickFrozen() {
        return this.metadata.getIndex(7, 0);
    }

    public void setTickFrozen(int tickFrozen) {
        this.metadata.setIndex(7, Metadata.VarInt(tickFrozen));
    }

    protected byte getMask(int index) {
        return this.metadata.getIndex(index, (byte)0);
    }

    protected void setMask(int index, byte mask) {
        this.metadata.setIndex(index, Metadata.Byte(mask));
    }

    protected boolean getMaskBit(int index, byte bit) {
        return (this.getMask(index) & bit) == bit;
    }

    protected void setMaskBit(int index, byte bit, boolean value) {
        boolean currentValue;
        byte mask = this.getMask(index);
        boolean bl = currentValue = (mask & bit) == bit;
        if (currentValue == value) {
            return;
        }
        mask = value ? (byte)(mask | bit) : (byte)(mask & ~bit);
        this.setMask(index, mask);
    }

    protected void consumeEntity(Consumer<Entity> consumer) {
        Entity entity = (Entity)this.entityRef.get();
        if (entity != null) {
            consumer.accept(entity);
        }
    }
}

