/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.damage;

import java.util.Collection;
import net.minestom.server.entity.damage.DamageTypeImpl;
import net.minestom.server.entity.damage.DamageTypes;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface DamageType
extends StaticProtocolObject,
DamageTypes {
    @Contract(pure=true)
    @NotNull
    public Registry.DamageTypeEntry registry();

    @Override
    @NotNull
    default public NamespaceID namespace() {
        return this.registry().namespace();
    }

    default public double exhaustion() {
        return this.registry().exhaustion();
    }

    default public String messageId() {
        return this.registry().messageId();
    }

    default public String scaling() {
        return this.registry().scaling();
    }

    public NBTCompound asNBT();

    @NotNull
    public static @NotNull Collection<@NotNull DamageType> values() {
        return DamageTypeImpl.values();
    }

    public static DamageType fromNamespaceId(@NotNull String namespaceID) {
        return DamageTypeImpl.getSafe(namespaceID);
    }

    public static DamageType fromNamespaceId(@NotNull NamespaceID namespaceID) {
        return DamageType.fromNamespaceId(namespaceID.asString());
    }

    @Nullable
    public static DamageType fromId(int id) {
        return DamageTypeImpl.getId(id);
    }

    public static NBTCompound getNBT() {
        return DamageTypeImpl.getNBT();
    }
}

