/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.damage;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.LivingEntity;
import net.minestom.server.entity.Player;
import net.minestom.server.entity.damage.DamageType;
import net.minestom.server.entity.damage.EntityDamage;
import net.minestom.server.entity.damage.EntityProjectileDamage;
import net.minestom.server.entity.damage.PositionalDamage;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.Taggable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Damage
implements Taggable {
    private final DamageType type;
    private final Entity source;
    private final Entity attacker;
    private final Point sourcePosition;
    private final TagHandler tagHandler = TagHandler.newHandler();
    private float amount;

    public Damage(@NotNull DamageType type, @Nullable Entity source, @Nullable Entity attacker, @Nullable Point sourcePosition, float amount) {
        this.type = type;
        this.source = source;
        this.attacker = attacker;
        this.sourcePosition = sourcePosition;
        this.amount = amount;
    }

    @NotNull
    public DamageType getType() {
        return this.type;
    }

    @Nullable
    public Entity getAttacker() {
        return this.attacker;
    }

    @Nullable
    public Entity getSource() {
        return this.source;
    }

    @Nullable
    public Point getSourcePosition() {
        return this.sourcePosition;
    }

    @Nullable
    public Component buildDeathMessage(@NotNull Player killed) {
        return Component.translatable((String)("death.attack." + this.type.messageId()), (ComponentLike[])new ComponentLike[]{Component.text((String)killed.getUsername())});
    }

    @NotNull
    public static Damage fromProjectile(@Nullable Entity shooter, @NotNull Entity projectile, float amount) {
        return new EntityProjectileDamage(shooter, projectile, amount);
    }

    @NotNull
    public static EntityDamage fromPlayer(@NotNull Player player, float amount) {
        return new EntityDamage(player, amount);
    }

    @NotNull
    public static EntityDamage fromEntity(@NotNull Entity entity, float amount) {
        return new EntityDamage(entity, amount);
    }

    @NotNull
    public static PositionalDamage fromPosition(@NotNull DamageType type, @NotNull Point sourcePosition, float amount) {
        return new PositionalDamage(type, sourcePosition, amount);
    }

    @Nullable
    public Component buildDeathScreenText(@NotNull Player killed) {
        return Component.translatable((String)("death.attack." + this.type.messageId()));
    }

    @Nullable
    public SoundEvent getSound(@NotNull LivingEntity entity) {
        if (entity instanceof Player) {
            return this.getPlayerSound((Player)entity);
        }
        return this.getGenericSound(entity);
    }

    protected SoundEvent getGenericSound(@NotNull LivingEntity entity) {
        return SoundEvent.ENTITY_GENERIC_HURT;
    }

    protected SoundEvent getPlayerSound(@NotNull Player player) {
        if (this.type == DamageType.ON_FIRE) {
            return SoundEvent.ENTITY_PLAYER_HURT_ON_FIRE;
        }
        return SoundEvent.ENTITY_PLAYER_HURT;
    }

    @Override
    @NotNull
    public TagHandler tagHandler() {
        return this.tagHandler;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setAmount(float amount) {
        this.amount = amount;
    }
}

