/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import org.jetbrains.annotations.NotNull;

public enum GameMode {
    SURVIVAL(0, true),
    CREATIVE(1, false),
    ADVENTURE(2, true),
    SPECTATOR(3, false);

    private final byte id;
    private final boolean canTakeDamage;

    private GameMode(byte id, boolean canTakeDamage) {
        this.id = id;
        this.canTakeDamage = canTakeDamage;
    }

    public byte id() {
        return this.id;
    }

    public boolean canTakeDamage() {
        return this.canTakeDamage;
    }

    @NotNull
    public static GameMode fromId(int id) {
        return switch (id) {
            case 0 -> SURVIVAL;
            case 1 -> CREATIVE;
            case 2 -> ADVENTURE;
            case 3 -> SPECTATOR;
            default -> throw new IllegalArgumentException("Unknown game mode id: " + id);
        };
    }
}

