/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.adventure.provider;

import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.util.Codec;
import net.minestom.server.adventure.MinestomAdventure;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTException;

final class NBTLegacyHoverEventSerializer
implements LegacyHoverEventSerializer {
    static final NBTLegacyHoverEventSerializer INSTANCE = new NBTLegacyHoverEventSerializer();
    private static final String ITEM_TYPE = "id";
    private static final String ITEM_COUNT = "Count";
    private static final String ITEM_TAG = "tag";
    private static final String ENTITY_TYPE = "type";
    private static final String ENTITY_NAME = "name";
    private static final String ENTITY_ID = "id";

    private NBTLegacyHoverEventSerializer() {
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HoverEvent.ShowItem deserializeShowItem(@NotNull Component input) throws IOException {
        String raw = PlainTextComponentSerializer.plainText().serialize(input);
        try {
            NBT nbt = (NBT)MinestomAdventure.NBT_CODEC.decode((Object)raw);
            if (!(nbt instanceof NBTCompound)) {
                throw new IOException("contents were not a compound");
            }
            NBTCompound contents = (NBTCompound)nbt;
            NBTCompound tag = contents.getCompound(ITEM_TAG);
            return HoverEvent.ShowItem.of((Key)Key.key((String)Objects.requireNonNullElse(contents.getString("id"), "")), (int)Objects.requireNonNullElse(contents.getByte(ITEM_COUNT), (byte)1).byteValue(), tag == null ? null : BinaryTagHolder.encode((Object)tag, MinestomAdventure.NBT_CODEC));
        }
        catch (NBTException e) {
            throw new IOException(e);
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HoverEvent.ShowEntity deserializeShowEntity(@NotNull Component input, Codec.Decoder<Component, String, ? extends RuntimeException> componentDecoder) throws IOException {
        String raw = PlainTextComponentSerializer.plainText().serialize(input);
        try {
            NBT nbt = (NBT)MinestomAdventure.NBT_CODEC.decode((Object)raw);
            if (!(nbt instanceof NBTCompound)) {
                throw new IOException("contents were not a compound");
            }
            NBTCompound contents = (NBTCompound)nbt;
            return HoverEvent.ShowEntity.of((Key)Key.key((String)Objects.requireNonNullElse(contents.getString(ENTITY_TYPE), "")), (UUID)UUID.fromString(Objects.requireNonNullElse(contents.getString("id"), "")), (Component)((Component)componentDecoder.decode((Object)Objects.requireNonNullElse(contents.getString(ENTITY_NAME), ""))));
        }
        catch (NBTException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    public Component serializeShowItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HoverEvent.ShowItem input) throws IOException {
        AtomicReference<Object> exception = new AtomicReference<Object>(null);
        NBTCompound tag = NBT.Compound(t -> {
            t.setString("id", input.item().asString());
            t.setByte(ITEM_COUNT, (byte)input.count());
            BinaryTagHolder nbt = input.nbt();
            if (nbt != null) {
                try {
                    t.set(ITEM_TAG, (NBT)nbt.get(MinestomAdventure.NBT_CODEC));
                }
                catch (NBTException e) {
                    exception.set(e);
                }
            }
        });
        if (exception.get() != null) {
            throw new IOException(exception.get());
        }
        return Component.text((String)((String)MinestomAdventure.NBT_CODEC.encode((Object)tag)));
    }

    @NotNull
    public Component serializeShowEntity(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HoverEvent.ShowEntity input, Codec.Encoder<Component, String, ? extends RuntimeException> componentEncoder) {
        NBTCompound tag = NBT.Compound(t -> {
            t.setString("id", input.id().toString());
            t.setString(ENTITY_TYPE, input.type().asString());
            Component name = input.name();
            if (name != null) {
                t.setString(ENTITY_NAME, (String)componentEncoder.encode((Object)name));
            }
        });
        return Component.text((String)((String)MinestomAdventure.NBT_CODEC.encode((Object)tag)));
    }
}

