/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.player;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.DataFormatException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import net.kyori.adventure.text.Component;
import net.minestom.server.MinecraftServer;
import net.minestom.server.adventure.MinestomAdventure;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.ListenerHandle;
import net.minestom.server.event.player.PlayerPacketOutEvent;
import net.minestom.server.extras.mojangAuth.MojangCrypt;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.PacketProcessor;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.FramedPacket;
import net.minestom.server.network.packet.server.LazyPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.login.SetCompressionPacket;
import net.minestom.server.network.player.GameProfile;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.socket.Worker;
import net.minestom.server.utils.ObjectPool;
import net.minestom.server.utils.PacketUtils;
import net.minestom.server.utils.binary.BinaryBuffer;
import net.minestom.server.utils.validate.Check;
import org.jctools.queues.MessagePassingQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public class PlayerSocketConnection
extends PlayerConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayerSocketConnection.class);
    private static final ObjectPool<BinaryBuffer> POOL = ObjectPool.BUFFER_POOL;
    private final Worker worker;
    private final MessagePassingQueue<Runnable> workerQueue;
    private final SocketChannel channel;
    private SocketAddress remoteAddress;
    private volatile boolean compressed = false;
    private volatile EncryptionContext encryptionContext;
    private byte[] nonce = new byte[4];
    private String loginUsername;
    private GameProfile gameProfile;
    private String serverAddress;
    private int serverPort;
    private int protocolVersion;
    private final Map<Integer, String> pluginRequestMap = new ConcurrentHashMap<Integer, String>();
    private final List<BinaryBuffer> waitingBuffers = new ArrayList<BinaryBuffer>();
    private final AtomicReference<BinaryBuffer> tickBuffer = new AtomicReference<BinaryBuffer>(POOL.get());
    private BinaryBuffer cacheBuffer;
    private final ListenerHandle<PlayerPacketOutEvent> outgoing = EventDispatcher.getHandle(PlayerPacketOutEvent.class);

    public PlayerSocketConnection(@NotNull Worker worker, @NotNull SocketChannel channel, SocketAddress remoteAddress) {
        this.worker = worker;
        this.workerQueue = worker.queue();
        this.channel = channel;
        this.remoteAddress = remoteAddress;
    }

    public void processPackets(BinaryBuffer readBuffer, PacketProcessor packetProcessor) {
        EncryptionContext encryptionContext = this.encryptionContext;
        if (encryptionContext != null) {
            ByteBuffer input = readBuffer.asByteBuffer(0, readBuffer.writerOffset());
            try {
                encryptionContext.decrypt().update(input, input.duplicate());
            }
            catch (ShortBufferException e) {
                MinecraftServer.getExceptionManager().handleException(e);
                return;
            }
        }
        try {
            this.cacheBuffer = PacketUtils.readPackets(readBuffer, this.compressed, (id, payload) -> {
                if (!this.isOnline()) {
                    return;
                }
                ClientPacket packet = null;
                try {
                    packet = packetProcessor.process(this, (int)id, (ByteBuffer)payload);
                }
                catch (Exception e) {
                    try {
                        MinecraftServer.getExceptionManager().handleException(e);
                    }
                    catch (Throwable throwable) {
                        if (payload.position() != payload.limit()) {
                            LOGGER.warn("WARNING: Packet ({}) 0x{} not fully read ({}) {}", new Object[]{this.getConnectionState(), Integer.toHexString(id), payload, packet});
                        }
                        throw throwable;
                    }
                    if (payload.position() != payload.limit()) {
                        LOGGER.warn("WARNING: Packet ({}) 0x{} not fully read ({}) {}", new Object[]{this.getConnectionState(), Integer.toHexString(id), payload, packet});
                    }
                }
                if (payload.position() != payload.limit()) {
                    LOGGER.warn("WARNING: Packet ({}) 0x{} not fully read ({}) {}", new Object[]{this.getConnectionState(), Integer.toHexString(id), payload, packet});
                }
            });
        }
        catch (DataFormatException e) {
            MinecraftServer.getExceptionManager().handleException(e);
            this.disconnect();
        }
    }

    public void consumeCache(BinaryBuffer buffer) {
        BinaryBuffer cache = this.cacheBuffer;
        if (cache != null) {
            buffer.write(cache);
            this.cacheBuffer = null;
        }
    }

    public void setEncryptionKey(@NotNull SecretKey secretKey) {
        Check.stateCondition(this.encryptionContext != null, "Encryption is already enabled!");
        this.encryptionContext = new EncryptionContext(MojangCrypt.getCipher(1, secretKey), MojangCrypt.getCipher(2, secretKey));
    }

    public void startCompression() {
        Check.stateCondition(this.compressed, "Compression is already enabled!");
        int threshold = MinecraftServer.getCompressionThreshold();
        Check.stateCondition(threshold == 0, "Compression cannot be enabled because the threshold is equal to 0");
        this.sendPacket(new SetCompressionPacket(threshold));
        this.compressed = true;
    }

    @Override
    public void sendPacket(@NotNull SendablePacket packet) {
        boolean compressed = this.compressed;
        this.workerQueue.relaxedOffer(() -> this.writePacketSync(packet, compressed));
    }

    @Override
    public void sendPackets(@NotNull Collection<SendablePacket> packets) {
        List<SendablePacket> packetsCopy = List.copyOf(packets);
        boolean compressed = this.compressed;
        this.workerQueue.relaxedOffer(() -> {
            for (SendablePacket packet : packetsCopy) {
                this.writePacketSync(packet, compressed);
            }
        });
    }

    @ApiStatus.Internal
    public void write(@NotNull ByteBuffer buffer, int index, int length) {
        this.workerQueue.relaxedOffer(() -> this.writeBufferSync(buffer, index, length));
    }

    @ApiStatus.Internal
    public void write(@NotNull ByteBuffer buffer) {
        this.write(buffer, buffer.position(), buffer.remaining());
    }

    @Override
    @NotNull
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @ApiStatus.Internal
    public void setRemoteAddress(@NotNull SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    public void disconnect() {
        super.disconnect();
        this.workerQueue.relaxedOffer(() -> {
            this.worker.disconnect(this, this.channel);
            BinaryBuffer tick = this.tickBuffer.getAndSet(null);
            if (tick != null) {
                POOL.add(tick);
            }
            for (BinaryBuffer buffer : this.waitingBuffers) {
                POOL.add(buffer);
            }
            this.waitingBuffers.clear();
        });
    }

    @NotNull
    public SocketChannel getChannel() {
        return this.channel;
    }

    @Nullable
    public GameProfile gameProfile() {
        return this.gameProfile;
    }

    public void UNSAFE_setProfile(@NotNull GameProfile gameProfile) {
        this.gameProfile = gameProfile;
    }

    @Nullable
    public String getLoginUsername() {
        return this.loginUsername;
    }

    public void UNSAFE_setLoginUsername(@NotNull String loginUsername) {
        this.loginUsername = loginUsername;
    }

    @Override
    @Nullable
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void refreshServerInformation(@Nullable String serverAddress, int serverPort, int protocolVersion) {
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
        this.protocolVersion = protocolVersion;
    }

    public void addPluginRequestEntry(int messageId, @NotNull String channel) {
        if (!this.getConnectionState().equals((Object)ConnectionState.LOGIN)) {
            return;
        }
        Check.stateCondition(this.pluginRequestMap.containsKey(messageId), "You cannot have two messageId with the same value");
        this.pluginRequestMap.put(messageId, channel);
    }

    @Nullable
    public String getPluginRequestChannel(int messageId) {
        return this.pluginRequestMap.get(messageId);
    }

    @Override
    public void setConnectionState(@NotNull ConnectionState connectionState) {
        super.setConnectionState(connectionState);
        if (connectionState.equals((Object)ConnectionState.PLAY)) {
            this.pluginRequestMap.clear();
        }
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    private void writePacketSync(SendablePacket packet, boolean compressed) {
        if (!this.channel.isConnected()) {
            return;
        }
        Player player = this.getPlayer();
        if (player != null && this.outgoing.hasListener()) {
            ServerPacket serverPacket = SendablePacket.extractServerPacket(this.getConnectionState(), packet);
            PlayerPacketOutEvent event = new PlayerPacketOutEvent(player, serverPacket);
            this.outgoing.call(event);
            if (event.isCancelled()) {
                return;
            }
        }
        if (packet instanceof ServerPacket) {
            ServerPacket serverPacket = (ServerPacket)packet;
            this.writeServerPacketSync(serverPacket, compressed);
        } else if (packet instanceof FramedPacket) {
            FramedPacket framedPacket = (FramedPacket)packet;
            ByteBuffer buffer = framedPacket.body();
            this.writeBufferSync(buffer, 0, buffer.limit());
        } else if (packet instanceof CachedPacket) {
            CachedPacket cachedPacket = (CachedPacket)packet;
            ByteBuffer buffer = cachedPacket.body(this.getConnectionState());
            if (buffer != null) {
                this.writeBufferSync(buffer, buffer.position(), buffer.remaining());
            } else {
                this.writeServerPacketSync(cachedPacket.packet(this.getConnectionState()), compressed);
            }
        } else if (packet instanceof LazyPacket) {
            LazyPacket lazyPacket = (LazyPacket)packet;
            this.writeServerPacketSync(lazyPacket.packet(), compressed);
        } else {
            throw new RuntimeException("Unknown packet type: " + packet.getClass().getName());
        }
    }

    private void writeServerPacketSync(ServerPacket serverPacket, boolean compressed) {
        Player player = this.getPlayer();
        if (player != null && MinestomAdventure.AUTOMATIC_COMPONENT_TRANSLATION && serverPacket instanceof ServerPacket.ComponentHolding) {
            serverPacket = (ServerPacket)((ServerPacket.ComponentHolding)((Object)serverPacket)).copyWithOperator(component -> MinestomAdventure.COMPONENT_TRANSLATOR.apply((Component)component, Objects.requireNonNullElseGet(player.getLocale(), MinestomAdventure::getDefaultLocale)));
        }
        try (ObjectPool.Holder hold = ObjectPool.PACKET_POOL.hold();){
            ByteBuffer buffer = PacketUtils.createFramedPacket(this.getConnectionState(), (ByteBuffer)hold.get(), serverPacket, compressed);
            this.writeBufferSync(buffer, 0, buffer.limit());
        }
    }

    private void writeBufferSync(@NotNull ByteBuffer buffer, int index, int length) {
        EncryptionContext encryptionContext = this.encryptionContext;
        if (encryptionContext != null) {
            try (ObjectPool.Holder hold = ObjectPool.PACKET_POOL.hold();){
                ByteBuffer output = (ByteBuffer)hold.get();
                try {
                    length = encryptionContext.encrypt().update(buffer.slice(index, length), output);
                    this.writeBufferSync0(output, 0, length);
                }
                catch (ShortBufferException e) {
                    MinecraftServer.getExceptionManager().handleException(e);
                }
                return;
            }
        }
        this.writeBufferSync0(buffer, index, length);
    }

    private void writeBufferSync0(@NotNull ByteBuffer buffer, int index, int length) {
        BinaryBuffer localBuffer = this.tickBuffer.getPlain();
        if (localBuffer == null) {
            return;
        }
        int capacity = localBuffer.capacity();
        if (length <= capacity) {
            if (!localBuffer.canWrite(length)) {
                localBuffer = this.updateLocalBuffer();
            }
            localBuffer.write(buffer, index, length);
        } else {
            int bufferCount = length / capacity + 1;
            for (int i = 0; i < bufferCount; ++i) {
                int sliceStart = i * capacity;
                int sliceLength = Math.min(length, sliceStart + capacity) - sliceStart;
                if (!localBuffer.canWrite(sliceLength)) {
                    localBuffer = this.updateLocalBuffer();
                }
                localBuffer.write(buffer, sliceStart, sliceLength);
            }
        }
    }

    public void flushSync() throws IOException {
        SocketChannel channel = this.channel;
        List<BinaryBuffer> waitingBuffers = this.waitingBuffers;
        if (!channel.isConnected()) {
            throw new ClosedChannelException();
        }
        if (waitingBuffers.isEmpty()) {
            BinaryBuffer localBuffer = this.tickBuffer.getPlain();
            if (localBuffer == null) {
                return;
            }
            localBuffer.writeChannel(channel);
        } else {
            BinaryBuffer waitingBuffer;
            Iterator<BinaryBuffer> iterator = waitingBuffers.iterator();
            while (iterator.hasNext() && (waitingBuffer = iterator.next()).writeChannel(channel)) {
                iterator.remove();
                POOL.add(waitingBuffer);
            }
        }
    }

    private BinaryBuffer updateLocalBuffer() {
        BinaryBuffer newBuffer = POOL.get();
        this.waitingBuffers.add(this.tickBuffer.getPlain());
        this.tickBuffer.setPlain(newBuffer);
        return newBuffer;
    }

    record EncryptionContext(Cipher encrypt, Cipher decrypt) {
    }
}

