/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client;

import java.util.function.Function;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.client.common.ClientKeepAlivePacket;
import net.minestom.server.network.packet.client.common.ClientPingRequestPacket;
import net.minestom.server.network.packet.client.common.ClientPluginMessagePacket;
import net.minestom.server.network.packet.client.common.ClientPongPacket;
import net.minestom.server.network.packet.client.common.ClientResourcePackStatusPacket;
import net.minestom.server.network.packet.client.common.ClientSettingsPacket;
import net.minestom.server.network.packet.client.configuration.ClientFinishConfigurationPacket;
import net.minestom.server.network.packet.client.login.ClientEncryptionResponsePacket;
import net.minestom.server.network.packet.client.login.ClientLoginAcknowledgedPacket;
import net.minestom.server.network.packet.client.login.ClientLoginPluginResponsePacket;
import net.minestom.server.network.packet.client.login.ClientLoginStartPacket;
import net.minestom.server.network.packet.client.play.ClientAdvancementTabPacket;
import net.minestom.server.network.packet.client.play.ClientAnimationPacket;
import net.minestom.server.network.packet.client.play.ClientChatAckPacket;
import net.minestom.server.network.packet.client.play.ClientChatMessagePacket;
import net.minestom.server.network.packet.client.play.ClientChatSessionUpdatePacket;
import net.minestom.server.network.packet.client.play.ClientChunkBatchReceivedPacket;
import net.minestom.server.network.packet.client.play.ClientClickWindowButtonPacket;
import net.minestom.server.network.packet.client.play.ClientClickWindowPacket;
import net.minestom.server.network.packet.client.play.ClientCloseWindowPacket;
import net.minestom.server.network.packet.client.play.ClientCommandChatPacket;
import net.minestom.server.network.packet.client.play.ClientConfigurationAckPacket;
import net.minestom.server.network.packet.client.play.ClientCraftRecipeRequest;
import net.minestom.server.network.packet.client.play.ClientCreativeInventoryActionPacket;
import net.minestom.server.network.packet.client.play.ClientEditBookPacket;
import net.minestom.server.network.packet.client.play.ClientEntityActionPacket;
import net.minestom.server.network.packet.client.play.ClientGenerateStructurePacket;
import net.minestom.server.network.packet.client.play.ClientHeldItemChangePacket;
import net.minestom.server.network.packet.client.play.ClientInteractEntityPacket;
import net.minestom.server.network.packet.client.play.ClientNameItemPacket;
import net.minestom.server.network.packet.client.play.ClientPickItemPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerAbilitiesPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerBlockPlacementPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerDiggingPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPositionAndRotationPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPositionPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerRotationPacket;
import net.minestom.server.network.packet.client.play.ClientQueryBlockNbtPacket;
import net.minestom.server.network.packet.client.play.ClientQueryEntityNbtPacket;
import net.minestom.server.network.packet.client.play.ClientSelectTradePacket;
import net.minestom.server.network.packet.client.play.ClientSetBeaconEffectPacket;
import net.minestom.server.network.packet.client.play.ClientSetDisplayedRecipePacket;
import net.minestom.server.network.packet.client.play.ClientSetRecipeBookStatePacket;
import net.minestom.server.network.packet.client.play.ClientSpectatePacket;
import net.minestom.server.network.packet.client.play.ClientStatusPacket;
import net.minestom.server.network.packet.client.play.ClientSteerBoatPacket;
import net.minestom.server.network.packet.client.play.ClientSteerVehiclePacket;
import net.minestom.server.network.packet.client.play.ClientTabCompletePacket;
import net.minestom.server.network.packet.client.play.ClientTeleportConfirmPacket;
import net.minestom.server.network.packet.client.play.ClientUpdateCommandBlockMinecartPacket;
import net.minestom.server.network.packet.client.play.ClientUpdateCommandBlockPacket;
import net.minestom.server.network.packet.client.play.ClientUpdateSignPacket;
import net.minestom.server.network.packet.client.play.ClientUpdateStructureBlockPacket;
import net.minestom.server.network.packet.client.play.ClientUseItemPacket;
import net.minestom.server.network.packet.client.play.ClientVehicleMovePacket;
import net.minestom.server.network.packet.client.play.ClientWindowSlotStatePacket;
import net.minestom.server.network.packet.client.status.StatusRequestPacket;
import net.minestom.server.utils.collection.ObjectArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public sealed class ClientPacketsHandler {
    private final ObjectArray<Function<NetworkBuffer, ClientPacket>> suppliers = ObjectArray.singleThread(16);

    private ClientPacketsHandler() {
    }

    public void register(int id, @NotNull @NotNull Function<@NotNull NetworkBuffer, @NotNull ClientPacket> packetSupplier) {
        this.suppliers.set(id, packetSupplier);
    }

    public @UnknownNullability ClientPacket create(int packetId, @NotNull NetworkBuffer reader) {
        Function<NetworkBuffer, ClientPacket> supplier = this.suppliers.get(packetId);
        if (supplier == null) {
            throw new IllegalStateException("Packet id 0x" + Integer.toHexString(packetId) + " isn't registered!");
        }
        return supplier.apply(reader);
    }

    public static final class Play
    extends ClientPacketsHandler {
        private static int nextId = 0;

        private static int nextId() {
            return nextId++;
        }

        public Play() {
            this.register(Play.nextId(), ClientTeleportConfirmPacket::new);
            this.register(Play.nextId(), ClientQueryBlockNbtPacket::new);
            Play.nextId();
            this.register(Play.nextId(), ClientChatAckPacket::new);
            this.register(Play.nextId(), ClientCommandChatPacket::new);
            this.register(Play.nextId(), ClientChatMessagePacket::new);
            this.register(Play.nextId(), ClientChatSessionUpdatePacket::new);
            this.register(Play.nextId(), ClientChunkBatchReceivedPacket::new);
            this.register(Play.nextId(), ClientStatusPacket::new);
            this.register(Play.nextId(), ClientSettingsPacket::new);
            this.register(Play.nextId(), ClientTabCompletePacket::new);
            this.register(Play.nextId(), ClientConfigurationAckPacket::new);
            this.register(Play.nextId(), ClientClickWindowButtonPacket::new);
            this.register(Play.nextId(), ClientClickWindowPacket::new);
            this.register(Play.nextId(), ClientCloseWindowPacket::new);
            this.register(Play.nextId(), ClientWindowSlotStatePacket::new);
            this.register(Play.nextId(), ClientPluginMessagePacket::new);
            this.register(Play.nextId(), ClientEditBookPacket::new);
            this.register(Play.nextId(), ClientQueryEntityNbtPacket::new);
            this.register(Play.nextId(), ClientInteractEntityPacket::new);
            this.register(Play.nextId(), ClientGenerateStructurePacket::new);
            this.register(Play.nextId(), ClientKeepAlivePacket::new);
            Play.nextId();
            this.register(Play.nextId(), ClientPlayerPositionPacket::new);
            this.register(Play.nextId(), ClientPlayerPositionAndRotationPacket::new);
            this.register(Play.nextId(), ClientPlayerRotationPacket::new);
            this.register(Play.nextId(), ClientPlayerPacket::new);
            this.register(Play.nextId(), ClientVehicleMovePacket::new);
            this.register(Play.nextId(), ClientSteerBoatPacket::new);
            this.register(Play.nextId(), ClientPickItemPacket::new);
            this.register(Play.nextId(), ClientPingRequestPacket::new);
            this.register(Play.nextId(), ClientCraftRecipeRequest::new);
            this.register(Play.nextId(), ClientPlayerAbilitiesPacket::new);
            this.register(Play.nextId(), ClientPlayerDiggingPacket::new);
            this.register(Play.nextId(), ClientEntityActionPacket::new);
            this.register(Play.nextId(), ClientSteerVehiclePacket::new);
            this.register(Play.nextId(), ClientPongPacket::new);
            this.register(Play.nextId(), ClientSetRecipeBookStatePacket::new);
            this.register(Play.nextId(), ClientSetDisplayedRecipePacket::new);
            this.register(Play.nextId(), ClientNameItemPacket::new);
            this.register(Play.nextId(), ClientResourcePackStatusPacket::new);
            this.register(Play.nextId(), ClientAdvancementTabPacket::new);
            this.register(Play.nextId(), ClientSelectTradePacket::new);
            this.register(Play.nextId(), ClientSetBeaconEffectPacket::new);
            this.register(Play.nextId(), ClientHeldItemChangePacket::new);
            this.register(Play.nextId(), ClientUpdateCommandBlockPacket::new);
            this.register(Play.nextId(), ClientUpdateCommandBlockMinecartPacket::new);
            this.register(Play.nextId(), ClientCreativeInventoryActionPacket::new);
            Play.nextId();
            this.register(Play.nextId(), ClientUpdateStructureBlockPacket::new);
            this.register(Play.nextId(), ClientUpdateSignPacket::new);
            this.register(Play.nextId(), ClientAnimationPacket::new);
            this.register(Play.nextId(), ClientSpectatePacket::new);
            this.register(Play.nextId(), ClientPlayerBlockPlacementPacket::new);
            this.register(Play.nextId(), ClientUseItemPacket::new);
        }
    }

    public static final class Configuration
    extends ClientPacketsHandler {
        private static int nextId = 0;

        private static int nextId() {
            return nextId++;
        }

        public Configuration() {
            this.register(Configuration.nextId(), ClientSettingsPacket::new);
            this.register(Configuration.nextId(), ClientPluginMessagePacket::new);
            this.register(Configuration.nextId(), ClientFinishConfigurationPacket::new);
            this.register(Configuration.nextId(), ClientKeepAlivePacket::new);
            this.register(Configuration.nextId(), ClientPongPacket::new);
            this.register(Configuration.nextId(), ClientResourcePackStatusPacket::new);
        }
    }

    public static final class Login
    extends ClientPacketsHandler {
        private static int nextId = 0;

        private static int nextId() {
            return nextId++;
        }

        public Login() {
            this.register(Login.nextId(), ClientLoginStartPacket::new);
            this.register(Login.nextId(), ClientEncryptionResponsePacket::new);
            this.register(Login.nextId(), ClientLoginPluginResponsePacket::new);
            this.register(Login.nextId(), ClientLoginAcknowledgedPacket::new);
        }
    }

    public static final class Status
    extends ClientPacketsHandler {
        private static int nextId = 0;

        private static int nextId() {
            return nextId++;
        }

        public Status() {
            this.register(Status.nextId(), StatusRequestPacket::new);
            this.register(Status.nextId(), ClientPingRequestPacket::new);
        }
    }
}

