/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.collision;

import it.unimi.dsi.fastutil.doubles.DoubleUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record Aerodynamics(double gravity, double horizontalAirResistance, double verticalAirResistance) {
    @Contract(pure=true)
    @NotNull
    public Aerodynamics withGravity(double gravity) {
        return new Aerodynamics(gravity, this.horizontalAirResistance, this.verticalAirResistance);
    }

    @Contract(pure=true)
    @NotNull
    public Aerodynamics withHorizontalAirResistance(double horizontalAirResistance) {
        return new Aerodynamics(this.gravity, horizontalAirResistance, this.verticalAirResistance);
    }

    @Contract(pure=true)
    @NotNull
    public Aerodynamics withHorizontalAirResistance(@NotNull DoubleUnaryOperator operator) {
        return this.withHorizontalAirResistance(operator.apply(this.horizontalAirResistance));
    }

    @Contract(pure=true)
    @NotNull
    public Aerodynamics withVerticalAirResistance(double verticalAirResistance) {
        return new Aerodynamics(this.gravity, this.horizontalAirResistance, verticalAirResistance);
    }

    @Contract(pure=true)
    @NotNull
    public Aerodynamics withVerticalAirResistance(@NotNull DoubleUnaryOperator operator) {
        return this.withVerticalAirResistance(operator.apply(this.verticalAirResistance));
    }

    @Contract(pure=true)
    @NotNull
    public Aerodynamics withAirResistance(double horizontal, double vertical) {
        return new Aerodynamics(this.gravity, this.horizontalAirResistance, this.verticalAirResistance);
    }
}

