/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.world.DimensionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTType;

public final class DimensionTypeManager {
    private final List<DimensionType> dimensionTypes = new CopyOnWriteArrayList<DimensionType>();

    public DimensionTypeManager() {
        this.addDimension(DimensionType.OVERWORLD);
    }

    public void addDimension(@NotNull DimensionType dimensionType) {
        dimensionType.registered = true;
        this.dimensionTypes.add(dimensionType);
    }

    public boolean removeDimension(@NotNull DimensionType dimensionType) {
        dimensionType.registered = false;
        return this.dimensionTypes.remove(dimensionType);
    }

    public boolean isRegistered(@NotNull NamespaceID namespaceID) {
        return this.isRegistered(this.getDimension(namespaceID));
    }

    public boolean isRegistered(@Nullable DimensionType dimensionType) {
        return dimensionType != null && this.dimensionTypes.contains(dimensionType) && dimensionType.isRegistered();
    }

    @Nullable
    public DimensionType getDimension(@NotNull NamespaceID namespaceID) {
        return this.unmodifiableList().stream().filter(dimensionType -> dimensionType.getName().equals(namespaceID)).filter(DimensionType::isRegistered).findFirst().orElse(null);
    }

    @NotNull
    public List<DimensionType> unmodifiableList() {
        return Collections.unmodifiableList(this.dimensionTypes);
    }

    @NotNull
    public NBTCompound toNBT() {
        return NBT.Compound(dimensions -> {
            dimensions.setString("type", "minecraft:dimension_type");
            dimensions.set("value", (NBT)NBT.List((NBTType)NBTType.TAG_Compound, this.dimensionTypes.stream().map(DimensionType::toIndexedNBT).toList()));
        });
    }
}

