/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record UpdateHealthPacket(float health, int food, float foodSaturation) implements ServerPacket
{
    public UpdateHealthPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.FLOAT).floatValue());
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.health));
        writer.write(NetworkBuffer.VAR_INT, this.food);
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.foodSaturation));
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.UPDATE_HEALTH;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }
}

