/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.Component;
import net.minestom.server.Viewable;
import net.minestom.server.entity.Player;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.inventory.InventoryProperty;
import net.minestom.server.inventory.InventoryType;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.inventory.click.ClickType;
import net.minestom.server.inventory.click.InventoryClickResult;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.server.play.OpenWindowPacket;
import net.minestom.server.network.packet.server.play.SetSlotPacket;
import net.minestom.server.network.packet.server.play.WindowItemsPacket;
import net.minestom.server.network.packet.server.play.WindowPropertyPacket;
import net.minestom.server.utils.inventory.PlayerInventoryUtils;
import org.jetbrains.annotations.NotNull;

public class Inventory
extends AbstractInventory
implements Viewable {
    private static final AtomicInteger ID_COUNTER = new AtomicInteger();
    private final byte id;
    private final InventoryType inventoryType;
    private Component title;
    private final int offset;
    private final Set<Player> viewers = new CopyOnWriteArraySet<Player>();
    private final Set<Player> unmodifiableViewers = Collections.unmodifiableSet(this.viewers);
    private final ConcurrentHashMap<Player, ItemStack> cursorPlayersItem = new ConcurrentHashMap();

    public Inventory(@NotNull InventoryType inventoryType, @NotNull Component title) {
        super(inventoryType.getSize());
        this.id = Inventory.generateId();
        this.inventoryType = inventoryType;
        this.title = title;
        this.offset = this.getSize();
    }

    public Inventory(@NotNull InventoryType inventoryType, @NotNull String title) {
        this(inventoryType, (Component)Component.text((String)title));
    }

    private static byte generateId() {
        return (byte)ID_COUNTER.updateAndGet(i -> i + 1 >= 128 ? 1 : i + 1);
    }

    @NotNull
    public InventoryType getInventoryType() {
        return this.inventoryType;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    public void setTitle(@NotNull Component title) {
        this.title = title;
        this.sendPacketToViewers(new OpenWindowPacket(this.getWindowId(), this.getInventoryType().getWindowType(), title));
        this.update();
    }

    public byte getWindowId() {
        return this.id;
    }

    @Override
    public synchronized void clear() {
        this.cursorPlayersItem.clear();
        super.clear();
    }

    @Override
    public void update() {
        this.viewers.forEach(p -> p.sendPacket(this.createNewWindowItemsPacket((Player)p)));
    }

    public void update(@NotNull Player player) {
        if (!this.isViewer(player)) {
            return;
        }
        player.sendPacket(this.createNewWindowItemsPacket(player));
    }

    @Override
    @NotNull
    public Set<Player> getViewers() {
        return this.unmodifiableViewers;
    }

    @Override
    public boolean addViewer(@NotNull Player player) {
        boolean result = this.viewers.add(player);
        this.update(player);
        return result;
    }

    @Override
    public boolean removeViewer(@NotNull Player player) {
        boolean result = this.viewers.remove(player);
        this.setCursorItem(player, ItemStack.AIR);
        this.clickProcessor.clearCache(player);
        return result;
    }

    @NotNull
    public ItemStack getCursorItem(@NotNull Player player) {
        return this.cursorPlayersItem.getOrDefault(player, ItemStack.AIR);
    }

    public void setCursorItem(@NotNull Player player, @NotNull ItemStack cursorItem) {
        ItemStack currentCursorItem = this.cursorPlayersItem.getOrDefault(player, ItemStack.AIR);
        if (!currentCursorItem.equals(cursorItem)) {
            player.sendPacket(SetSlotPacket.createCursorPacket(cursorItem));
        }
        if (!cursorItem.isAir()) {
            this.cursorPlayersItem.put(player, cursorItem);
        } else {
            this.cursorPlayersItem.remove(player);
        }
    }

    @Override
    protected void UNSAFE_itemInsert(int slot, @NotNull ItemStack itemStack, boolean sendPacket) {
        this.itemStacks[slot] = itemStack;
        if (sendPacket) {
            this.sendPacketToViewers(new SetSlotPacket(this.getWindowId(), 0, (short)slot, itemStack));
        }
    }

    @NotNull
    private WindowItemsPacket createNewWindowItemsPacket(Player player) {
        return new WindowItemsPacket(this.getWindowId(), 0, List.of(this.getItemStacks()), this.cursorPlayersItem.getOrDefault(player, ItemStack.AIR));
    }

    protected void sendProperty(@NotNull InventoryProperty property, short value) {
        this.sendPacketToViewers(new WindowPropertyPacket(this.getWindowId(), property.getProperty(), value));
    }

    @Override
    public boolean leftClick(@NotNull Player player, int slot) {
        ItemStack clicked;
        int clickSlot;
        boolean isInWindow;
        PlayerInventory playerInventory = player.getInventory();
        ItemStack cursor = this.getCursorItem(player);
        InventoryClickResult clickResult = this.clickProcessor.leftClick(player, isInWindow ? this : playerInventory, clickSlot = (isInWindow = this.isClickInWindow(slot)) ? slot : PlayerInventoryUtils.convertSlot(slot, this.offset), clicked = isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot), cursor);
        if (clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        if (isInWindow) {
            this.setItemStack(slot, clickResult.getClicked());
        } else {
            playerInventory.setItemStack(clickSlot, clickResult.getClicked());
        }
        this.cursorPlayersItem.put(player, clickResult.getCursor());
        this.callClickEvent(player, isInWindow ? this : null, slot, ClickType.LEFT_CLICK, clicked, cursor);
        return true;
    }

    @Override
    public boolean rightClick(@NotNull Player player, int slot) {
        ItemStack clicked;
        int clickSlot;
        boolean isInWindow;
        PlayerInventory playerInventory = player.getInventory();
        ItemStack cursor = this.getCursorItem(player);
        InventoryClickResult clickResult = this.clickProcessor.rightClick(player, isInWindow ? this : playerInventory, clickSlot = (isInWindow = this.isClickInWindow(slot)) ? slot : PlayerInventoryUtils.convertSlot(slot, this.offset), clicked = isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot), cursor);
        if (clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        if (isInWindow) {
            this.setItemStack(slot, clickResult.getClicked());
        } else {
            playerInventory.setItemStack(clickSlot, clickResult.getClicked());
        }
        this.cursorPlayersItem.put(player, clickResult.getCursor());
        this.callClickEvent(player, isInWindow ? this : null, slot, ClickType.RIGHT_CLICK, clicked, cursor);
        return true;
    }

    @Override
    public boolean shiftClick(@NotNull Player player, int slot) {
        ItemStack cursor;
        ItemStack clicked;
        int clickSlot;
        boolean isInWindow;
        PlayerInventory playerInventory = player.getInventory();
        InventoryClickResult clickResult = this.clickProcessor.shiftClick(isInWindow ? this : playerInventory, isInWindow ? playerInventory : this, 0, isInWindow ? playerInventory.getInnerSize() : this.getInnerSize(), 1, player, clickSlot = (isInWindow = this.isClickInWindow(slot)) ? slot : PlayerInventoryUtils.convertSlot(slot, this.offset), clicked = isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot), cursor = this.getCursorItem(player));
        if (clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        if (isInWindow) {
            this.setItemStack(slot, clickResult.getClicked());
        } else {
            playerInventory.setItemStack(clickSlot, clickResult.getClicked());
        }
        this.updateAll(player);
        this.cursorPlayersItem.put(player, clickResult.getCursor());
        return true;
    }

    @Override
    public boolean changeHeld(@NotNull Player player, int slot, int key) {
        ItemStack heldItem;
        ItemStack clicked;
        int clickSlot;
        int convertedKey = key == 40 ? 45 : key;
        PlayerInventory playerInventory = player.getInventory();
        boolean isInWindow = this.isClickInWindow(slot);
        InventoryClickResult clickResult = this.clickProcessor.changeHeld(player, isInWindow ? this : playerInventory, clickSlot = isInWindow ? slot : PlayerInventoryUtils.convertSlot(slot, this.offset), convertedKey, clicked = isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot), heldItem = playerInventory.getItemStack(convertedKey));
        if (clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        if (isInWindow) {
            this.setItemStack(slot, clickResult.getClicked());
        } else {
            playerInventory.setItemStack(clickSlot, clickResult.getClicked());
        }
        playerInventory.setItemStack(convertedKey, clickResult.getCursor());
        this.callClickEvent(player, isInWindow ? this : null, slot, ClickType.CHANGE_HELD, clicked, this.getCursorItem(player));
        return true;
    }

    @Override
    public boolean middleClick(@NotNull Player player, int slot) {
        this.update(player);
        return false;
    }

    @Override
    public boolean drop(@NotNull Player player, boolean all, int slot, int button) {
        ItemStack cursor;
        ItemStack clicked;
        int clickSlot;
        PlayerInventory playerInventory = player.getInventory();
        boolean isInWindow = this.isClickInWindow(slot);
        boolean outsideDrop = slot == -999;
        int n = clickSlot = isInWindow ? slot : PlayerInventoryUtils.convertSlot(slot, this.offset);
        InventoryClickResult clickResult = this.clickProcessor.drop(player, isInWindow ? this : playerInventory, all, clickSlot, button, clicked = outsideDrop ? ItemStack.AIR : (isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot)), cursor = this.getCursorItem(player));
        if (clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        ItemStack resultClicked = clickResult.getClicked();
        if (!outsideDrop && resultClicked != null) {
            if (isInWindow) {
                this.setItemStack(slot, resultClicked);
            } else {
                playerInventory.setItemStack(clickSlot, resultClicked);
            }
        }
        this.cursorPlayersItem.put(player, clickResult.getCursor());
        return true;
    }

    @Override
    public boolean dragging(@NotNull Player player, int slot, int button) {
        int clickSlot;
        PlayerInventory playerInventory = player.getInventory();
        boolean isInWindow = this.isClickInWindow(slot);
        int n = clickSlot = isInWindow ? slot : PlayerInventoryUtils.convertSlot(slot, this.offset);
        ItemStack clicked = slot != -999 ? (isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot)) : ItemStack.AIR;
        ItemStack cursor = this.getCursorItem(player);
        InventoryClickResult clickResult = this.clickProcessor.dragging(player, slot != -999 ? (isInWindow ? this : playerInventory) : null, clickSlot, button, clicked, cursor);
        if (clickResult == null || clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        this.cursorPlayersItem.put(player, clickResult.getCursor());
        this.updateAll(player);
        return true;
    }

    @Override
    public boolean doubleClick(@NotNull Player player, int slot) {
        int clickSlot;
        PlayerInventory playerInventory = player.getInventory();
        boolean isInWindow = this.isClickInWindow(slot);
        int n = clickSlot = isInWindow ? slot : PlayerInventoryUtils.convertSlot(slot, this.offset);
        ItemStack clicked = slot != -999 ? (isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot)) : ItemStack.AIR;
        ItemStack cursor = this.getCursorItem(player);
        InventoryClickResult clickResult = this.clickProcessor.doubleClick(isInWindow ? this : playerInventory, this, player, clickSlot, clicked, cursor);
        if (clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        this.cursorPlayersItem.put(player, clickResult.getCursor());
        this.updateAll(player);
        return true;
    }

    private boolean isClickInWindow(int slot) {
        return slot < this.getSize();
    }

    private void updateAll(Player player) {
        player.getInventory().update();
        this.update(player);
    }
}

