/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.collision;

import java.util.function.Function;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.PhysicsResult;
import net.minestom.server.collision.Shape;
import net.minestom.server.collision.SweepResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.instance.Instance;

final class EntityCollision {
    EntityCollision() {
    }

    public static PhysicsResult checkCollision(Instance instance, BoundingBox boundingBox, Point point, Vec entityVelocity, double extendRadius, Function<Entity, Boolean> entityFilter, PhysicsResult res) {
        double minimumRes;
        double d = minimumRes = res != null ? res.res().res : Double.MAX_VALUE;
        if (instance == null) {
            return null;
        }
        SweepResult sweepResult = new SweepResult(minimumRes, 0.0, 0.0, 0.0, null, null);
        double closestDistance = minimumRes;
        Entity closestEntity = null;
        double maxDistance = Math.pow(boundingBox.height() * boundingBox.height() + boundingBox.depth() / 2.0 * boundingBox.depth() / 2.0 + boundingBox.width() / 2.0 * boundingBox.width() / 2.0, 0.3333333333333333);
        double projectileDistance = entityVelocity.length();
        for (Entity e : instance.getNearbyEntities(point, extendRadius + maxDistance + projectileDistance)) {
            if (!entityFilter.apply(e).booleanValue() || !e.hasCollision()) continue;
            if (e.getBoundingBox().intersectBox(e.getPosition().sub(point), boundingBox)) {
                Pos p = Pos.fromPoint(point);
                return new PhysicsResult(p, Vec.ZERO, false, true, true, true, entityVelocity, new Pos[]{p, p, p}, new Shape[]{e, e, e}, true, sweepResult);
            }
            e.getBoundingBox().intersectBoxSwept(point, entityVelocity, e.getPosition(), boundingBox, sweepResult);
            if (!(sweepResult.res < closestDistance) || !(sweepResult.res < 1.0)) continue;
            closestDistance = sweepResult.res;
            closestEntity = e;
        }
        Point[] collisionPoints = new Pos[3];
        return new PhysicsResult(Pos.fromPoint(point).add(entityVelocity.mul(closestDistance)), Vec.ZERO, sweepResult.normalY == -1.0, sweepResult.normalX != 0.0, sweepResult.normalY != 0.0, sweepResult.normalZ != 0.0, entityVelocity, collisionPoints, new Shape[]{closestEntity, closestEntity, closestEntity}, sweepResult.normalX != 0.0 || sweepResult.normalZ != 0.0 || sweepResult.normalY != 0.0, sweepResult);
    }
}

