/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

public record EntityEquipmentPacket(int entityId, @NotNull Map<EquipmentSlot, ItemStack> equipments) implements ServerPacket.Play,
ServerPacket.ComponentHolding
{
    public EntityEquipmentPacket(int entityId, @NotNull Map<EquipmentSlot, ItemStack> equipments) {
        equipments = Map.copyOf(equipments);
        if (equipments.isEmpty()) {
            throw new IllegalArgumentException("Equipments cannot be empty");
        }
    }

    public EntityEquipmentPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), EntityEquipmentPacket.readEquipments(reader));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.entityId);
        int index = 0;
        for (Map.Entry<EquipmentSlot, ItemStack> entry : this.equipments.entrySet()) {
            boolean last = index++ == this.equipments.size() - 1;
            byte slotEnum = (byte)entry.getKey().ordinal();
            if (!last) {
                slotEnum = (byte)(slotEnum | 0x80);
            }
            writer.write(NetworkBuffer.BYTE, slotEnum);
            writer.write(NetworkBuffer.ITEM, entry.getValue());
        }
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.ENTITY_EQUIPMENT;
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        return this.equipments.values().stream().map(ItemStack::getDisplayName).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        EnumMap<EquipmentSlot, ItemStack> map = new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class);
        this.equipments.forEach((key, value) -> map.put((EquipmentSlot)((Object)key), value.withDisplayName(operator)));
        return new EntityEquipmentPacket(this.entityId, map);
    }

    private static Map<EquipmentSlot, ItemStack> readEquipments(@NotNull NetworkBuffer reader) {
        byte slot;
        EnumMap<EquipmentSlot, ItemStack> equipments = new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class);
        do {
            slot = reader.read(NetworkBuffer.BYTE);
            equipments.put(EquipmentSlot.values()[slot & 0x7F], reader.read(NetworkBuffer.ITEM));
        } while ((slot & 0x80) == 128);
        return equipments;
    }
}

