/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal;

import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.metadata.animal.AnimalMeta;
import org.jetbrains.annotations.NotNull;

public class SheepMeta
extends AnimalMeta {
    public static final byte OFFSET = 17;
    public static final byte MAX_OFFSET = 18;
    private static final byte COLOR_BITS = 15;
    private static final byte SHEARED_BIT = 16;

    public SheepMeta(@NotNull Entity entity, @NotNull Metadata metadata) {
        super(entity, metadata);
    }

    public int getColor() {
        return this.getMask(17) & 0xF;
    }

    public void setColor(byte color) {
        byte before;
        byte mask = before = this.getMask(17);
        mask = (byte)(mask & 0xFFFFFFF0);
        if ((mask = (byte)(mask | color & 0xF)) != before) {
            this.setMask(17, mask);
        }
    }

    public boolean isSheared() {
        return this.getMaskBit(17, (byte)16);
    }

    public void setSheared(boolean value) {
        this.setMaskBit(17, (byte)16, value);
    }
}

