/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments.minecraft;

import java.io.Reader;
import java.io.StringReader;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTException;
import org.jglrxavpok.hephaistos.parser.SNBTParser;

public class ArgumentNbtCompoundTag
extends Argument<NBTCompound> {
    public static final int INVALID_NBT = 1;

    public ArgumentNbtCompoundTag(String id) {
        super(id, true);
    }

    @Override
    @NotNull
    public NBTCompound parse(@NotNull CommandSender sender, @NotNull String input) throws ArgumentSyntaxException {
        try {
            NBT nbt = new SNBTParser((Reader)new StringReader(input)).parse();
            if (!(nbt instanceof NBTCompound)) {
                throw new ArgumentSyntaxException("NBTCompound is invalid", input, 1);
            }
            return (NBTCompound)nbt;
        }
        catch (NBTException e) {
            throw new ArgumentSyntaxException("NBTCompound is invalid", input, 1);
        }
    }

    @Override
    public String parser() {
        return "minecraft:nbt_compound_tag";
    }

    public String toString() {
        return String.format("NbtCompound<%s>", this.getId());
    }
}

