/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.binary;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.NBTReader;
import org.jglrxavpok.hephaistos.nbt.NBTWriter;

@ApiStatus.Internal
public final class BinaryBuffer {
    private ByteBuffer nioBuffer;
    private NBTReader nbtReader;
    private NBTWriter nbtWriter;
    private final int capacity;
    private int readerOffset;
    private int writerOffset;

    private BinaryBuffer(ByteBuffer buffer) {
        this.nioBuffer = buffer;
        this.capacity = buffer.capacity();
    }

    @ApiStatus.Internal
    public static BinaryBuffer ofSize(int size) {
        return new BinaryBuffer(ByteBuffer.allocateDirect(size));
    }

    @ApiStatus.Internal
    public static BinaryBuffer wrap(ByteBuffer buffer) {
        assert (buffer.isDirect());
        return new BinaryBuffer(buffer);
    }

    public static BinaryBuffer copy(BinaryBuffer buffer) {
        int size = buffer.readableBytes();
        ByteBuffer temp = ByteBuffer.allocateDirect(size).put(buffer.asByteBuffer(0, size));
        BinaryBuffer newBuffer = new BinaryBuffer(temp);
        newBuffer.writerOffset = size;
        return newBuffer;
    }

    public void write(ByteBuffer buffer, int index, int length) {
        this.nioBuffer.put(this.writerOffset, buffer, index, length);
        this.writerOffset += length;
    }

    public void write(ByteBuffer buffer) {
        this.write(buffer, buffer.position(), buffer.remaining());
    }

    public void write(BinaryBuffer buffer) {
        this.write(buffer.asByteBuffer(buffer.readerOffset, buffer.writerOffset - buffer.readerOffset));
    }

    public int readVarInt() {
        int value = 0;
        for (int i = 0; i < 5; ++i) {
            int offset = this.readerOffset + i;
            byte k = this.nioBuffer.get(offset);
            value |= (k & 0x7F) << i * 7;
            if ((k & 0x80) == 128) continue;
            this.readerOffset = offset + 1;
            return value;
        }
        throw new RuntimeException("VarInt is too big");
    }

    @NotNull
    public Marker mark() {
        return new Marker(this.readerOffset, this.writerOffset);
    }

    public void reset(int readerOffset, int writerOffset) {
        this.readerOffset = readerOffset;
        this.writerOffset = writerOffset;
    }

    public void reset(@NotNull Marker marker) {
        this.reset(marker.readerOffset(), marker.writerOffset());
    }

    public boolean canRead(int size) {
        return this.readerOffset + size <= this.writerOffset;
    }

    public boolean canWrite(int size) {
        return this.writerOffset + size < this.capacity;
    }

    public int capacity() {
        return this.capacity;
    }

    public int readerOffset() {
        return this.readerOffset;
    }

    public void readerOffset(int offset) {
        this.readerOffset = offset;
    }

    public int writerOffset() {
        return this.writerOffset;
    }

    public void writerOffset(int offset) {
        this.writerOffset = offset;
    }

    public int readableBytes() {
        return this.writerOffset - this.readerOffset;
    }

    public void writeBytes(byte[] bytes) {
        this.nioBuffer.put(this.writerOffset, bytes);
        this.writerOffset += bytes.length;
    }

    public byte[] readBytes(int length) {
        byte[] bytes = new byte[length];
        this.nioBuffer.get(this.readerOffset, bytes);
        this.readerOffset += length;
        return bytes;
    }

    public byte[] readRemainingBytes() {
        return this.readBytes(this.readableBytes());
    }

    public BinaryBuffer clear() {
        this.readerOffset = 0;
        this.writerOffset = 0;
        this.nioBuffer.limit(this.capacity);
        return this;
    }

    public ByteBuffer asByteBuffer(int reader, int length) {
        return this.nioBuffer.slice(reader, length);
    }

    @ApiStatus.Internal
    public ByteBuffer asByteBuffer() {
        return this.nioBuffer;
    }

    public boolean writeChannel(WritableByteChannel channel) throws IOException {
        if (this.readerOffset == this.writerOffset) {
            return true;
        }
        ByteBuffer writeBuffer = this.nioBuffer.slice(this.readerOffset, this.writerOffset - this.readerOffset);
        int count = channel.write(writeBuffer);
        if (count == -1) {
            throw new IOException("Disconnected");
        }
        this.readerOffset += count;
        return writeBuffer.limit() == writeBuffer.position();
    }

    public void readChannel(ReadableByteChannel channel) throws IOException {
        int count = channel.read(this.nioBuffer.slice(this.writerOffset, this.capacity - this.writerOffset));
        if (count == -1) {
            throw new IOException("Disconnected");
        }
        this.writerOffset += count;
    }

    public String toString() {
        return "BinaryBuffer{readerOffset=" + this.readerOffset + ", writerOffset=" + this.writerOffset + ", capacity=" + this.capacity + "}";
    }

    public record Marker(int readerOffset, int writerOffset) {
    }
}

