/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.timer;

import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minestom.server.timer.ExecutionType;
import net.minestom.server.timer.SchedulerImpl;
import net.minestom.server.timer.SchedulerManager;
import net.minestom.server.timer.Task;
import net.minestom.server.timer.TaskSchedule;
import org.jetbrains.annotations.NotNull;

public sealed interface Scheduler
extends Executor
permits SchedulerImpl, SchedulerManager {
    @NotNull
    public static Scheduler newScheduler() {
        return new SchedulerImpl();
    }

    public void process();

    public void processTick();

    @NotNull
    public Task submitTask(@NotNull Supplier<TaskSchedule> var1, @NotNull ExecutionType var2);

    @NotNull
    default public Task submitTask(@NotNull Supplier<TaskSchedule> task) {
        return this.submitTask(task, ExecutionType.SYNC);
    }

    @NotNull
    default public Task.Builder buildTask(@NotNull Runnable task) {
        return new Task.Builder(this, task);
    }

    @NotNull
    default public Task scheduleTask(@NotNull Runnable task, @NotNull TaskSchedule delay, @NotNull TaskSchedule repeat, @NotNull ExecutionType executionType) {
        return this.buildTask(task).delay(delay).repeat(repeat).executionType(executionType).schedule();
    }

    @NotNull
    default public Task scheduleTask(@NotNull Runnable task, @NotNull TaskSchedule delay, @NotNull TaskSchedule repeat) {
        return this.scheduleTask(task, delay, repeat, ExecutionType.SYNC);
    }

    @NotNull
    default public Task scheduleNextTick(@NotNull Runnable task, @NotNull ExecutionType executionType) {
        return this.buildTask(task).delay(TaskSchedule.nextTick()).executionType(executionType).schedule();
    }

    @NotNull
    default public Task scheduleNextTick(@NotNull Runnable task) {
        return this.scheduleNextTick(task, ExecutionType.SYNC);
    }

    @NotNull
    default public Task scheduleNextProcess(@NotNull Runnable task, @NotNull ExecutionType executionType) {
        return this.buildTask(task).delay(TaskSchedule.immediate()).executionType(executionType).schedule();
    }

    @NotNull
    default public Task scheduleNextProcess(@NotNull Runnable task) {
        return this.scheduleNextProcess(task, ExecutionType.SYNC);
    }

    @Override
    default public void execute(@NotNull Runnable command) {
        this.scheduleNextTick(command);
    }
}

