/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.minestom.server.adventure.MinestomAdventure;
import net.minestom.server.item.ItemMeta;
import net.minestom.server.item.ItemMetaView;
import net.minestom.server.item.ItemStackImpl;
import net.minestom.server.item.Material;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.tag.TagWritable;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;

public sealed interface ItemStack
extends TagReadable,
HoverEventSource<HoverEvent.ShowItem>
permits ItemStackImpl {
    @NotNull
    public static final ItemStack AIR = ItemStack.of(Material.AIR);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static Builder builder(@NotNull Material material) {
        return new ItemStackImpl.Builder(material, 1);
    }

    @Contract(value="_ ,_ -> new", pure=true)
    @NotNull
    public static ItemStack of(@NotNull Material material, int amount) {
        return ItemStackImpl.create(material, amount);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ItemStack of(@NotNull Material material) {
        return ItemStack.of(material, 1);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static ItemStack fromNBT(@NotNull Material material, @Nullable NBTCompound nbtCompound, int amount) {
        if (nbtCompound == null) {
            return ItemStack.of(material, amount);
        }
        return ItemStack.builder(material).amount(amount).meta(nbtCompound).build();
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static ItemStack fromNBT(@NotNull Material material, @Nullable NBTCompound nbtCompound) {
        return ItemStack.fromNBT(material, nbtCompound, 1);
    }

    @ApiStatus.Experimental
    @NotNull
    public static ItemStack fromItemNBT(@NotNull NBTCompound nbtCompound) {
        NBTCompound tag;
        String id = nbtCompound.getString("id");
        Check.notNull(id, "Item NBT must contain an id field.");
        Material material = Material.fromNamespaceId(id);
        Check.notNull(material, "Unknown material: {0}", id);
        Byte amount = nbtCompound.getByte("Count");
        if (amount == null) {
            amount = 1;
        }
        return (tag = nbtCompound.getCompound("tag")) != null ? ItemStack.fromNBT(material, tag, amount.byteValue()) : ItemStack.of(material, amount.byteValue());
    }

    @Contract(pure=true)
    @NotNull
    public Material material();

    @Contract(pure=true)
    public int amount();

    @Contract(pure=true)
    @NotNull
    public ItemMeta meta();

    @Contract(pure=true)
    @ApiStatus.Experimental
    @NotNull
    public <T extends ItemMetaView<?>> T meta(@NotNull Class<T> var1);

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public ItemStack with(@NotNull @NotNull Consumer<@NotNull Builder> var1);

    @Contract(value="_, _ -> new", pure=true)
    @ApiStatus.Experimental
    @NotNull
    public <V extends ItemMetaView.Builder, T extends ItemMetaView<V>> ItemStack withMeta(@NotNull Class<T> var1, @NotNull Consumer<V> var2);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public ItemStack withMeta(@NotNull @NotNull Consumer<@NotNull ItemMeta.Builder> var1);

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public ItemStack withMaterial(@NotNull Material var1);

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public ItemStack withAmount(int var1);

    @Contract(value="_, -> new", pure=true)
    @NotNull
    default public ItemStack withAmount(@NotNull IntUnaryOperator intUnaryOperator) {
        return this.withAmount(intUnaryOperator.applyAsInt(this.amount()));
    }

    @ApiStatus.Experimental
    @Contract(value="_, -> new", pure=true)
    @NotNull
    public ItemStack consume(int var1);

    @Contract(pure=true)
    @Nullable
    default public Component getDisplayName() {
        return this.meta().getDisplayName();
    }

    @Contract(pure=true)
    @NotNull
    default public @NotNull List<@NotNull Component> getLore() {
        return this.meta().getLore();
    }

    @ApiStatus.Experimental
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public ItemStack withMeta(@NotNull ItemMeta var1);

    @Contract(value="_, -> new", pure=true)
    @NotNull
    default public ItemStack withDisplayName(@Nullable Component displayName) {
        return this.withMeta((ItemMeta.Builder builder) -> builder.displayName(displayName));
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    default public ItemStack withDisplayName(@NotNull UnaryOperator<@Nullable Component> componentUnaryOperator) {
        return this.withDisplayName((Component)componentUnaryOperator.apply(this.getDisplayName()));
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    default public ItemStack withLore(@NotNull List<? extends Component> lore) {
        return this.withMeta((ItemMeta.Builder builder) -> builder.lore(lore));
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    default public ItemStack withLore(@NotNull @NotNull UnaryOperator<@NotNull List<@NotNull Component>> loreUnaryOperator) {
        return this.withLore((List)loreUnaryOperator.apply(this.getLore()));
    }

    @Contract(pure=true)
    default public boolean isAir() {
        return this.material() == Material.AIR;
    }

    @Contract(pure=true)
    public boolean isSimilar(@NotNull ItemStack var1);

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    default public <T> ItemStack withTag(@NotNull Tag<T> tag, @Nullable T value) {
        return this.withMeta((ItemMeta.Builder builder) -> builder.set(tag, value));
    }

    @Override
    default public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        return this.meta().getTag(tag);
    }

    @NotNull
    default public HoverEvent<HoverEvent.ShowItem> asHoverEvent(@NotNull UnaryOperator<HoverEvent.ShowItem> op) {
        BinaryTagHolder tagHolder = BinaryTagHolder.encode((Object)this.meta().toNBT(), MinestomAdventure.NBT_CODEC);
        return HoverEvent.showItem((HoverEvent.ShowItem)((HoverEvent.ShowItem)op.apply(HoverEvent.ShowItem.of((Keyed)this.material(), (int)this.amount(), (BinaryTagHolder)tagHolder))));
    }

    @ApiStatus.Experimental
    @NotNull
    public NBTCompound toItemNBT();

    @Deprecated
    @Contract(pure=true)
    @NotNull
    default public Material getMaterial() {
        return this.material();
    }

    @Deprecated
    @Contract(pure=true)
    default public int getAmount() {
        return this.amount();
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    default public ItemMeta getMeta() {
        return this.meta();
    }

    public static sealed interface Builder
    extends TagWritable
    permits ItemStackImpl.Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder amount(int var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder meta(@NotNull TagHandler var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder meta(@NotNull NBTCompound var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder meta(@NotNull ItemMeta var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder meta(@NotNull @NotNull Consumer<@NotNull ItemMeta.Builder> var1);

        @Contract(value="_, _ -> this")
        @NotNull
        public <V extends ItemMetaView.Builder, T extends ItemMetaView<V>> Builder meta(@NotNull Class<T> var1, @NotNull @NotNull Consumer<@NotNull V> var2);

        @Contract(value="-> new", pure=true)
        @NotNull
        public ItemStack build();

        @Contract(value="_, _ -> this")
        @NotNull
        default public <T> Builder set(@NotNull Tag<T> tag, @Nullable T value) {
            this.setTag(tag, value);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder displayName(@Nullable Component displayName) {
            return this.meta((ItemMeta.Builder builder) -> builder.displayName(displayName));
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder lore(@NotNull List<? extends Component> lore) {
            return this.meta((ItemMeta.Builder builder) -> builder.lore(lore));
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder lore(Component ... lore) {
            return this.meta((ItemMeta.Builder builder) -> builder.lore(lore));
        }
    }
}

