/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extras;

import java.security.KeyPair;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerFlag;
import net.minestom.server.extras.mojangAuth.MojangCrypt;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.Nullable;

public final class MojangAuth {
    public static final String AUTH_URL = ServerFlag.AUTH_URL.concat("?username=%s&serverId=%s");
    private static volatile boolean enabled = false;
    private static volatile KeyPair keyPair;

    public static void init() {
        Check.stateCondition(enabled, "Mojang auth is already enabled!");
        Check.stateCondition(MinecraftServer.process().isAlive(), "The server has already been started!");
        enabled = true;
        keyPair = MojangCrypt.generateKeyPair();
    }

    public static boolean isEnabled() {
        return enabled;
    }

    @Nullable
    public static KeyPair getKeyPair() {
        return keyPair;
    }
}

