/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import it.unimi.dsi.fastutil.longs.LongArrayPriorityQueue;
import it.unimi.dsi.fastutil.longs.LongPriorityQueue;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.resource.ResourcePackInfo;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.kyori.adventure.resource.ResourcePackStatus;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.title.TitlePart;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerFlag;
import net.minestom.server.advancements.AdvancementTab;
import net.minestom.server.adventure.AdventurePacketConvertor;
import net.minestom.server.adventure.Localizable;
import net.minestom.server.adventure.audience.Audiences;
import net.minestom.server.attribute.Attribute;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.command.CommandSender;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.effects.Effects;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.entity.ExperienceOrb;
import net.minestom.server.entity.GameMode;
import net.minestom.server.entity.LivingEntity;
import net.minestom.server.entity.PlayerSkin;
import net.minestom.server.entity.damage.DamageType;
import net.minestom.server.entity.metadata.EntityMeta;
import net.minestom.server.entity.metadata.LivingEntityMeta;
import net.minestom.server.entity.metadata.PlayerMeta;
import net.minestom.server.entity.vehicle.PlayerVehicleInformation;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.inventory.InventoryOpenEvent;
import net.minestom.server.event.item.ItemDropEvent;
import net.minestom.server.event.item.ItemUpdateStateEvent;
import net.minestom.server.event.item.PickupExperienceEvent;
import net.minestom.server.event.player.PlayerChunkLoadEvent;
import net.minestom.server.event.player.PlayerChunkUnloadEvent;
import net.minestom.server.event.player.PlayerDeathEvent;
import net.minestom.server.event.player.PlayerDisconnectEvent;
import net.minestom.server.event.player.PlayerEatEvent;
import net.minestom.server.event.player.PlayerGameModeChangeEvent;
import net.minestom.server.event.player.PlayerRespawnEvent;
import net.minestom.server.event.player.PlayerSkinInitEvent;
import net.minestom.server.event.player.PlayerSpawnEvent;
import net.minestom.server.event.player.PlayerStopFlyingWithElytraEvent;
import net.minestom.server.event.player.PlayerTickEvent;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.EntityTracker;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.Block;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.item.metadata.WrittenBookMeta;
import net.minestom.server.listener.manager.PacketListenerManager;
import net.minestom.server.message.ChatMessageType;
import net.minestom.server.message.ChatPosition;
import net.minestom.server.message.Messenger;
import net.minestom.server.network.ConnectionManager;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.common.DisconnectPacket;
import net.minestom.server.network.packet.server.common.PluginMessagePacket;
import net.minestom.server.network.packet.server.common.ResourcePackPopPacket;
import net.minestom.server.network.packet.server.common.ResourcePackPushPacket;
import net.minestom.server.network.packet.server.login.LoginDisconnectPacket;
import net.minestom.server.network.packet.server.play.ActionBarPacket;
import net.minestom.server.network.packet.server.play.CameraPacket;
import net.minestom.server.network.packet.server.play.ChangeGameStatePacket;
import net.minestom.server.network.packet.server.play.ChunkBatchFinishedPacket;
import net.minestom.server.network.packet.server.play.ChunkBatchStartPacket;
import net.minestom.server.network.packet.server.play.ClearTitlesPacket;
import net.minestom.server.network.packet.server.play.CloseWindowPacket;
import net.minestom.server.network.packet.server.play.DeathCombatEventPacket;
import net.minestom.server.network.packet.server.play.DestroyEntitiesPacket;
import net.minestom.server.network.packet.server.play.EffectPacket;
import net.minestom.server.network.packet.server.play.EntityHeadLookPacket;
import net.minestom.server.network.packet.server.play.FacePlayerPacket;
import net.minestom.server.network.packet.server.play.HeldItemChangePacket;
import net.minestom.server.network.packet.server.play.JoinGamePacket;
import net.minestom.server.network.packet.server.play.OpenBookPacket;
import net.minestom.server.network.packet.server.play.OpenWindowPacket;
import net.minestom.server.network.packet.server.play.PlayerAbilitiesPacket;
import net.minestom.server.network.packet.server.play.PlayerInfoRemovePacket;
import net.minestom.server.network.packet.server.play.PlayerInfoUpdatePacket;
import net.minestom.server.network.packet.server.play.PlayerListHeaderAndFooterPacket;
import net.minestom.server.network.packet.server.play.PlayerPositionAndLookPacket;
import net.minestom.server.network.packet.server.play.RespawnPacket;
import net.minestom.server.network.packet.server.play.ServerDifficultyPacket;
import net.minestom.server.network.packet.server.play.SetExperiencePacket;
import net.minestom.server.network.packet.server.play.SetSlotPacket;
import net.minestom.server.network.packet.server.play.SpawnPositionPacket;
import net.minestom.server.network.packet.server.play.TimeUpdatePacket;
import net.minestom.server.network.packet.server.play.UnloadChunkPacket;
import net.minestom.server.network.packet.server.play.UnlockRecipesPacket;
import net.minestom.server.network.packet.server.play.UpdateHealthPacket;
import net.minestom.server.network.packet.server.play.UpdateViewPositionPacket;
import net.minestom.server.network.packet.server.play.data.DeathLocation;
import net.minestom.server.network.player.GameProfile;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.player.PlayerSocketConnection;
import net.minestom.server.recipe.Recipe;
import net.minestom.server.recipe.RecipeManager;
import net.minestom.server.scoreboard.BelowNameTag;
import net.minestom.server.scoreboard.Team;
import net.minestom.server.snapshot.EntitySnapshot;
import net.minestom.server.snapshot.PlayerSnapshot;
import net.minestom.server.snapshot.SnapshotImpl;
import net.minestom.server.snapshot.SnapshotUpdater;
import net.minestom.server.statistic.PlayerStatistic;
import net.minestom.server.timer.SchedulerManager;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.PacketUtils;
import net.minestom.server.utils.PropertyUtils;
import net.minestom.server.utils.async.AsyncUtils;
import net.minestom.server.utils.chunk.ChunkUpdateLimitChecker;
import net.minestom.server.utils.chunk.ChunkUtils;
import net.minestom.server.utils.function.IntegerBiConsumer;
import net.minestom.server.utils.identity.NamedAndIdentified;
import net.minestom.server.utils.instance.InstanceUtils;
import net.minestom.server.utils.time.Cooldown;
import net.minestom.server.utils.time.TimeUnit;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.DimensionType;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpscUnboundedXaddArrayQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Player
extends LivingEntity
implements CommandSender,
Localizable,
HoverEventSource<HoverEvent.ShowEntity>,
Identified,
NamedAndIdentified {
    private static final Logger logger = LoggerFactory.getLogger(Player.class);
    private static final Component REMOVE_MESSAGE = Component.text((String)"You have been removed from the server without reason.", (TextColor)NamedTextColor.RED);
    private static final float MIN_CHUNKS_PER_TICK = PropertyUtils.getFloat("minestom.chunk-queue.min-per-tick", Float.valueOf(0.01f)).floatValue();
    private static final float MAX_CHUNKS_PER_TICK = PropertyUtils.getFloat("minestom.chunk-queue.max-per-tick", Float.valueOf(64.0f)).floatValue();
    private static final float CHUNKS_PER_TICK_MULTIPLIER = PropertyUtils.getFloat("minestom.chunk-queue.multiplier", Float.valueOf(1.0f)).floatValue();
    public static final boolean EXPERIMENT_PERFORM_POSE_UPDATES = Boolean.getBoolean("minestom.experiment.pose-updates");
    private static final int STATUS_ENABLE_REDUCED_DEBUG_INFO = 22;
    private static final int STATUS_DISABLE_REDUCED_DEBUG_INFO = 23;
    private static final int STATUS_PERMISSION_LEVEL_OFFSET = 24;
    private long lastKeepAlive;
    private boolean answerKeepAlive;
    private String username;
    private Component usernameComponent;
    protected final PlayerConnection playerConnection;
    private int latency;
    private Component displayName;
    private PlayerSkin skin;
    private Instance pendingInstance = null;
    private DimensionType dimensionType;
    private GameMode gameMode;
    private DeathLocation deathLocation;
    private Vec chunksLoadedByClient = Vec.ZERO;
    private final ReentrantLock chunkQueueLock = new ReentrantLock();
    private final LongPriorityQueue chunkQueue = new LongArrayPriorityQueue(this::compareChunkDistance);
    private float targetChunksPerTick = 9.0f;
    private float pendingChunkCount = 0.0f;
    private int maxChunkBatchLead = 1;
    private int chunkBatchLead = 0;
    final IntegerBiConsumer chunkAdder = (chunkX, chunkZ) -> this.instance.loadOptionalChunk(chunkX, chunkZ).thenAccept(this::sendChunk);
    final IntegerBiConsumer chunkRemover = (chunkX, chunkZ) -> {
        this.sendPacket(new UnloadChunkPacket(chunkX, chunkZ));
        EventDispatcher.call(new PlayerChunkUnloadEvent(this, chunkX, chunkZ));
    };
    private final AtomicInteger teleportId = new AtomicInteger();
    private int receivedTeleportId;
    private final MessagePassingQueue<ClientPacket> packets = new MpscUnboundedXaddArrayQueue(32);
    private final boolean levelFlat;
    private final PlayerSettings settings;
    private float exp;
    private int level;
    private int portalCooldown = 0;
    protected PlayerInventory inventory;
    private Inventory openInventory;
    private boolean didCloseInventory;
    private byte heldSlot;
    private Pos respawnPoint;
    private int food;
    private float foodSaturation;
    private long startEatingTime;
    private long defaultEatingTime = 1000L;
    private long eatingTime;
    private Hand eatingHand;
    private boolean enableRespawnScreen;
    private final ChunkUpdateLimitChecker chunkUpdateLimitChecker = new ChunkUpdateLimitChecker(6);
    protected Cooldown experiencePickupCooldown = new Cooldown(Duration.of(10L, TimeUnit.SERVER_TICK));
    private BelowNameTag belowNameTag;
    private int permissionLevel;
    private boolean reducedDebugScreenInformation;
    private boolean hardcore;
    private boolean flying;
    private boolean allowFlying;
    private boolean instantBreak;
    private float flyingSpeed = 0.05f;
    private float fieldViewModifier = 0.1f;
    private final Map<PlayerStatistic, Integer> statisticValueMap = new Hashtable<PlayerStatistic, Integer>();
    private final PlayerVehicleInformation vehicleInformation = new PlayerVehicleInformation();
    private Identity identity;
    private final Pointers pointers;
    private final Map<UUID, ResourcePackCallback> resourcePackCallbacks = new HashMap<UUID, ResourcePackCallback>();
    private CompletableFuture<Void> resourcePackFuture = null;

    public Player(@NotNull UUID uuid, @NotNull String username, @NotNull PlayerConnection playerConnection) {
        super(EntityType.PLAYER, uuid);
        this.username = username;
        this.usernameComponent = Component.text((String)username);
        this.playerConnection = playerConnection;
        this.setRespawnPoint(Pos.ZERO);
        this.settings = new PlayerSettings();
        this.inventory = new PlayerInventory(this);
        this.setCanPickupItem(true);
        this.refreshAnswerKeepAlive(true);
        this.gameMode = GameMode.SURVIVAL;
        this.dimensionType = DimensionType.OVERWORLD;
        this.levelFlat = true;
        this.getAttribute(Attribute.MOVEMENT_SPEED).setBaseValue(0.1f);
        this.playerConnectionInit();
        this.identity = Identity.identity((UUID)uuid);
        this.pointers = (Pointers)Pointers.builder().withDynamic(Identity.UUID, this::getUuid).withDynamic(Identity.NAME, this::getUsername).withDynamic(Identity.DISPLAY_NAME, this::getDisplayName).build();
        this.metadata.setNotifyAboutChanges(false);
    }

    @ApiStatus.Internal
    public void setPendingOptions(@NotNull Instance pendingInstance, boolean hardcore) {
        this.pendingInstance = pendingInstance;
        this.hardcore = hardcore;
    }

    @ApiStatus.Internal
    public CompletableFuture<Void> UNSAFE_init() {
        PlayerSocketConnection socketConnection;
        GameProfile gameProfile;
        Instance spawnInstance = this.pendingInstance;
        this.pendingInstance = null;
        this.removed = false;
        this.dimensionType = spawnInstance.getDimensionType();
        JoinGamePacket joinGamePacket = new JoinGamePacket(this.getEntityId(), this.hardcore, List.of(), 0, ServerFlag.CHUNK_VIEW_DISTANCE, ServerFlag.CHUNK_VIEW_DISTANCE, false, true, false, this.dimensionType.toString(), spawnInstance.getDimensionName(), 0L, this.gameMode, null, false, this.levelFlat, this.deathLocation, this.portalCooldown);
        this.sendPacket(joinGamePacket);
        this.sendPacket(new ServerDifficultyPacket(MinecraftServer.getDifficulty(), true));
        this.sendPacket(new SpawnPositionPacket(this.respawnPoint, 0.0f));
        this.metadata.setNotifyAboutChanges(true);
        this.sendPacket(this.getMetadataPacket());
        PlayerSkin profileSkin = null;
        PlayerConnection playerConnection = this.playerConnection;
        if (playerConnection instanceof PlayerSocketConnection && (gameProfile = (socketConnection = (PlayerSocketConnection)playerConnection).gameProfile()) != null) {
            for (GameProfile.Property property : gameProfile.properties()) {
                if (!property.name().equals("textures")) continue;
                profileSkin = new PlayerSkin(property.value(), property.signature());
                break;
            }
        }
        PlayerSkinInitEvent skinInitEvent = new PlayerSkinInitEvent(this, profileSkin);
        EventDispatcher.call(skinInitEvent);
        this.skin = skinInitEvent.getSkin();
        PacketUtils.broadcastPlayPacket(this.getAddPlayerToList());
        ConnectionManager connectionManager = MinecraftServer.getConnectionManager();
        for (Player player : connectionManager.getOnlinePlayers()) {
            if (player == this) continue;
            this.sendPacket(player.getAddPlayerToList());
            if (player.displayName == null) continue;
            this.sendPacket(new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME, player.infoEntry()));
        }
        for (Team team : MinecraftServer.getTeamManager().getTeams()) {
            this.sendPacket(team.createTeamsCreationPacket());
        }
        this.refreshCommands();
        RecipeManager recipeManager = MinecraftServer.getRecipeManager();
        this.sendPacket(recipeManager.getDeclareRecipesPacket());
        ArrayList<String> recipesIdentifier = new ArrayList<String>();
        for (Recipe recipe : recipeManager.getRecipes()) {
            if (!recipe.shouldShow(this)) continue;
            recipesIdentifier.add(recipe.getRecipeId());
        }
        if (!recipesIdentifier.isEmpty()) {
            UnlockRecipesPacket unlockRecipesPacket = new UnlockRecipesPacket(0, false, false, false, false, false, false, false, false, recipesIdentifier, recipesIdentifier);
            this.sendPacket(unlockRecipesPacket);
        }
        this.sendPacket(this.getPropertiesPacket());
        this.triggerStatus((byte)(24 + this.permissionLevel));
        this.refreshHealth();
        this.refreshAbilities();
        return this.setInstance(spawnInstance);
    }

    public void startConfigurationPhase() {
        Check.stateCondition(this.playerConnection.getConnectionState() != ConnectionState.PLAY, "Player must be in the play state for reconfiguration.");
        this.remove(false);
        ConnectionManager connectionManager = MinecraftServer.getConnectionManager();
        connectionManager.transitionPlayToConfig(this);
    }

    protected void playerConnectionInit() {
        PlayerConnection connection = this.playerConnection;
        if (connection != null) {
            connection.setPlayer(this);
        }
    }

    @Override
    public void update(long time) {
        this.interpretPacketQueue();
        if (this.isRemoved()) {
            return;
        }
        this.sendPendingChunks();
        super.update(time);
        if (this.experiencePickupCooldown.isReady(time)) {
            this.experiencePickupCooldown.refreshLastUpdate(time);
            Pos loweredPosition = this.position.sub(0.0, 0.5, 0.0);
            this.instance.getEntityTracker().nearbyEntities(this.position, this.expandedBoundingBox.width(), EntityTracker.Target.EXPERIENCE_ORBS, experienceOrb -> {
                if (this.expandedBoundingBox.intersectEntity(loweredPosition, (Entity)experienceOrb)) {
                    PickupExperienceEvent pickupExperienceEvent = new PickupExperienceEvent(this, (ExperienceOrb)experienceOrb);
                    EventDispatcher.callCancellable(pickupExperienceEvent, () -> {
                        short experienceCount = pickupExperienceEvent.getExperienceCount();
                        experienceOrb.remove();
                    });
                }
            });
        }
        if (this.isEating() && time - this.startEatingTime >= this.eatingTime) {
            this.triggerStatus((byte)9);
            ItemUpdateStateEvent itemUpdateStateEvent = this.callItemUpdateStateEvent(this.eatingHand);
            Check.notNull(itemUpdateStateEvent, "#callItemUpdateStateEvent returned null.");
            boolean isOffHand = itemUpdateStateEvent.getHand() == Hand.OFF;
            this.refreshActiveHand(false, isOffHand, false);
            ItemStack foodItem = itemUpdateStateEvent.getItemStack();
            boolean isFood = foodItem.material().isFood();
            if (isFood) {
                PlayerEatEvent playerEatEvent = new PlayerEatEvent(this, foodItem, this.eatingHand);
                EventDispatcher.call(playerEatEvent);
            }
            this.refreshEating(null);
        }
        if (EXPERIMENT_PERFORM_POSE_UPDATES) {
            this.updatePose();
        }
        EventDispatcher.call(new PlayerTickEvent(this));
    }

    @Override
    public void kill() {
        if (!this.isDead()) {
            Object deathText = this.lastDamage != null ? this.lastDamage.buildDeathScreenText(this) : Component.text((String)"Killed by poor programming.");
            Object chatMessage = this.lastDamage != null ? this.lastDamage.buildDeathMessage(this) : Component.text((String)(this.getUsername() + " was killed by poor programming."));
            PlayerDeathEvent playerDeathEvent = new PlayerDeathEvent(this, (Component)deathText, (Component)chatMessage);
            EventDispatcher.call(playerDeathEvent);
            deathText = playerDeathEvent.getDeathText();
            chatMessage = playerDeathEvent.getChatMessage();
            if (deathText != null) {
                this.sendPacket(new DeathCombatEventPacket(this.getEntityId(), (Component)deathText));
            }
            if (chatMessage != null) {
                Audiences.players().sendMessage(chatMessage);
            }
            if (this.getInstance() != null) {
                this.setDeathLocation(this.getInstance().getDimensionType(), this.getPosition());
            }
        }
        super.kill();
    }

    public void respawn() {
        if (!this.isDead()) {
            return;
        }
        this.setFireForDuration(0);
        this.setOnFire(false);
        this.refreshHealth();
        this.sendPacket(new RespawnPacket(this.getDimensionType().toString(), this.instance.getDimensionName(), 0L, this.gameMode, this.gameMode, false, this.levelFlat, this.deathLocation, this.portalCooldown, 3));
        this.refreshClientStateAfterRespawn();
        PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent(this);
        EventDispatcher.call(respawnEvent);
        this.refreshIsDead(false);
        this.updatePose();
        Pos respawnPosition = respawnEvent.getRespawnPosition();
        ChunkUtils.forChunksInRange(respawnPosition, this.settings.getEffectiveViewDistance(), this.chunkAdder);
        this.chunksLoadedByClient = new Vec(respawnPosition.chunkX(), respawnPosition.chunkZ());
        this.instance.getEntityTracker().nearbyEntitiesByChunkRange(respawnPosition, this.settings.getEffectiveViewDistance(), EntityTracker.Target.ENTITIES, entity -> {
            if (!entity.getUuid().equals(this.uuid) && entity.isViewer(this)) {
                entity.updateNewViewer(this);
            }
        });
        this.teleport(respawnPosition).thenRun(this::refreshAfterTeleport);
    }

    private void refreshClientStateAfterRespawn() {
        this.sendPacket(new ChangeGameStatePacket(ChangeGameStatePacket.Reason.LEVEL_CHUNKS_LOAD_START, 0.0f));
        this.sendPacket(new ServerDifficultyPacket(MinecraftServer.getDifficulty(), false));
        this.sendPacket(new UpdateHealthPacket(this.getHealth(), this.food, this.foodSaturation));
        this.sendPacket(new SetExperiencePacket(this.exp, this.level, 0));
        this.triggerStatus((byte)(24 + this.permissionLevel));
        this.refreshAbilities();
    }

    public void refreshCommands() {
        this.sendPacket(MinecraftServer.getCommandManager().createDeclareCommandsPacket(this));
    }

    @Override
    public boolean isOnGround() {
        return this.onGround;
    }

    @Override
    public void remove(boolean permanent) {
        if (this.isRemoved()) {
            return;
        }
        if (permanent) {
            this.packets.clear();
            EventDispatcher.call(new PlayerDisconnectEvent(this));
        }
        super.remove(permanent);
        Inventory currentInventory = this.getOpenInventory();
        if (currentInventory != null) {
            currentInventory.removeViewer(this);
        }
        MinecraftServer.getBossBarManager().removeAllBossBars(this);
        Set<AdvancementTab> advancementTabs = AdvancementTab.getTabs(this);
        if (advancementTabs != null) {
            for (AdvancementTab advancementTab : advancementTabs) {
                advancementTab.removeViewer(this);
            }
        }
        Pos position = this.position;
        int chunkX = position.chunkX();
        int chunkZ = position.chunkZ();
        ChunkUtils.forChunksInRange(chunkX, chunkZ, this.settings.getEffectiveViewDistance(), this.chunkRemover);
        PacketUtils.broadcastPlayPacket(this.getRemovePlayerToList());
        if (permanent && this.playerConnection.isOnline()) {
            this.kick(REMOVE_MESSAGE);
        }
    }

    @Override
    public void updateOldViewer(@NotNull Player player) {
        super.updateOldViewer(player);
        if (this.getTeam() != null && this.getTeam().getMembers().size() == 1) {
            player.sendPacket(this.getTeam().createTeamDestructionPacket());
        }
    }

    @Override
    public void sendPacketToViewersAndSelf(@NotNull SendablePacket packet) {
        this.sendPacket(packet);
        super.sendPacketToViewersAndSelf(packet);
    }

    @Override
    public CompletableFuture<Void> setInstance(@NotNull Instance instance, @NotNull Pos spawnPosition) {
        Instance currentInstance = this.instance;
        Check.argCondition(currentInstance == instance, "Instance should be different than the current one");
        if (InstanceUtils.areLinked(currentInstance, instance) && spawnPosition.sameChunk(this.position)) {
            this.spawnPlayer(instance, spawnPosition, false, false, false);
            return AsyncUtils.VOID_FUTURE;
        }
        this.chunkUpdateLimitChecker.clearHistory();
        boolean dimensionChange = currentInstance != null && !Objects.equals(currentInstance.getDimensionName(), instance.getDimensionName());
        Consumer<Instance> runnable = i -> this.spawnPlayer((Instance)i, spawnPosition, currentInstance == null, dimensionChange, true);
        ArrayList futures = new ArrayList();
        ChunkUtils.forChunksInRange(spawnPosition, this.settings.getEffectiveViewDistance(), (chunkX, chunkZ) -> {
            CompletableFuture<Chunk> future = instance.loadOptionalChunk(chunkX, chunkZ);
            if (!future.isDone()) {
                futures.add(future);
            }
        });
        if (futures.isEmpty()) {
            runnable.accept(instance);
            return AsyncUtils.VOID_FUTURE;
        }
        final Thread runThread = Thread.currentThread();
        final CountDownLatch latch = new CountDownLatch(1);
        final SchedulerManager scheduler = MinecraftServer.getSchedulerManager();
        CompletableFuture<Void> future = new CompletableFuture<Void>(this){

            @Override
            public Void join() {
                if (runThread == Thread.currentThread()) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    scheduler.process();
                    assert (this.isDone());
                }
                return (Void)super.join();
            }
        };
        CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenRun(() -> {
            scheduler.scheduleNextProcess(() -> {
                runnable.accept(instance);
                future.complete(null);
            });
            latch.countDown();
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> setInstance(@NotNull Instance instance) {
        return this.setInstance(instance, this.instance != null ? this.getPosition() : this.getRespawnPoint());
    }

    private void spawnPlayer(@NotNull Instance instance, @NotNull Pos spawnPosition, boolean firstSpawn, boolean dimensionChange, boolean updateChunks) {
        if (!firstSpawn && !dimensionChange && updateChunks) {
            ChunkUtils.forChunksInRange(spawnPosition, this.settings.getEffectiveViewDistance(), this.chunkRemover);
        }
        if (dimensionChange) {
            this.sendDimension(instance.getDimensionType(), instance.getDimensionName());
        }
        super.setInstance(instance, spawnPosition);
        if (updateChunks) {
            int chunkX = spawnPosition.chunkX();
            int chunkZ = spawnPosition.chunkZ();
            this.chunksLoadedByClient = new Vec(chunkX, chunkZ);
            this.chunkUpdateLimitChecker.addToHistory(this.getChunk());
            this.sendPacket(new UpdateViewPositionPacket(chunkX, chunkZ));
            ChunkUtils.forChunksInRange(spawnPosition, this.settings.getEffectiveViewDistance(), this.chunkAdder);
        }
        this.synchronizePositionAfterTeleport(spawnPosition, 0);
        if (dimensionChange) {
            this.sendPacket(new SpawnPositionPacket(spawnPosition, 0.0f));
            instance.getWorldBorder().init(this);
            this.sendPacket(new TimeUpdatePacket(instance.getWorldAge(), instance.getTime()));
        }
        if (dimensionChange || firstSpawn) {
            this.inventory.update();
            this.sendPacket(new HeldItemChangePacket(this.heldSlot));
            this.sendPacket(new ChangeGameStatePacket(ChangeGameStatePacket.Reason.LEVEL_CHUNKS_LOAD_START, 0.0f));
        }
        EventDispatcher.call(new PlayerSpawnEvent(this, instance, firstSpawn));
    }

    @ApiStatus.Internal
    public void onChunkBatchReceived(float newTargetChunksPerTick) {
        --this.chunkBatchLead;
        float f = this.targetChunksPerTick = Float.isNaN(newTargetChunksPerTick) ? MIN_CHUNKS_PER_TICK : MathUtils.clamp(newTargetChunksPerTick * CHUNKS_PER_TICK_MULTIPLIER, MIN_CHUNKS_PER_TICK, MAX_CHUNKS_PER_TICK);
        if (this.maxChunkBatchLead == 1) {
            this.maxChunkBatchLead = 10;
        }
    }

    public void sendChunk(@NotNull Chunk chunk) {
        if (!chunk.isLoaded()) {
            return;
        }
        this.chunkQueueLock.lock();
        try {
            this.chunkQueue.enqueue(ChunkUtils.getChunkIndex(chunk.getChunkX(), chunk.getChunkZ()));
        }
        finally {
            this.chunkQueueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPendingChunks() {
        if (this.chunkQueue.isEmpty() || this.chunkBatchLead >= this.maxChunkBatchLead) {
            return;
        }
        this.pendingChunkCount = Math.min(this.pendingChunkCount + this.targetChunksPerTick, MAX_CHUNKS_PER_TICK);
        if (this.pendingChunkCount < 1.0f) {
            return;
        }
        this.chunkQueueLock.lock();
        try {
            int batchSize = 0;
            this.sendPacket(new ChunkBatchStartPacket());
            while (!this.chunkQueue.isEmpty() && this.pendingChunkCount >= 1.0f) {
                int chunkZ;
                long chunkIndex = this.chunkQueue.dequeueLong();
                int chunkX = ChunkUtils.getChunkCoordX(chunkIndex);
                Chunk chunk = this.instance.getChunk(chunkX, chunkZ = ChunkUtils.getChunkCoordZ(chunkIndex));
                if (chunk == null || !chunk.isLoaded()) continue;
                this.sendPacket(chunk.getFullDataPacket());
                EventDispatcher.call(new PlayerChunkLoadEvent(this, chunkX, chunkZ));
                this.pendingChunkCount -= 1.0f;
                ++batchSize;
            }
            this.sendPacket(new ChunkBatchFinishedPacket(batchSize));
            ++this.chunkBatchLead;
        }
        finally {
            this.chunkQueueLock.unlock();
        }
    }

    @Override
    protected void updatePose() {
        LivingEntityMeta livingMeta;
        Entity.Pose oldPose = this.getPose();
        EntityMeta meta = this.getEntityMeta();
        Entity.Pose newPose = meta.isFlyingWithElytra() ? Entity.Pose.FALL_FLYING : (meta.isSwimming() ? Entity.Pose.SWIMMING : (meta instanceof LivingEntityMeta && (livingMeta = (LivingEntityMeta)meta).isInRiptideSpinAttack() ? Entity.Pose.SPIN_ATTACK : (this.isSneaking() && !this.isFlying() ? Entity.Pose.SNEAKING : Entity.Pose.STANDING)));
        if (!this.canFitWithBoundingBox(newPose)) {
            newPose = this.canFitWithBoundingBox(Entity.Pose.SNEAKING) ? Entity.Pose.SNEAKING : (this.canFitWithBoundingBox(Entity.Pose.SWIMMING) ? Entity.Pose.SWIMMING : Entity.Pose.STANDING);
        }
        if (newPose != oldPose) {
            this.setPose(newPose);
        }
    }

    private boolean canFitWithBoundingBox(@NotNull Entity.Pose pose) {
        BoundingBox bb;
        BoundingBox boundingBox = bb = pose == Entity.Pose.STANDING ? this.boundingBox : BoundingBox.fromPose(pose);
        if (bb == null) {
            return false;
        }
        Pos position = this.getPosition();
        Iterator<Point> iter = bb.getBlocks(this.getPosition());
        while (iter.hasNext()) {
            boolean hit;
            Point pos = iter.next();
            Block block = this.instance.getBlock(pos, Block.Getter.Condition.TYPE);
            if (block.id() == Block.SCAFFOLDING.id() || !(hit = block.registry().collisionShape().intersectBox(position.sub(pos.blockX(), pos.blockY(), pos.blockZ()), bb))) continue;
            return false;
        }
        return true;
    }

    public void sendPluginMessage(@NotNull String channel, byte @NotNull [] data) {
        this.sendPacket(new PluginMessagePacket(channel, data));
    }

    public void sendPluginMessage(@NotNull String channel, @NotNull String message) {
        this.sendPluginMessage(channel, message.getBytes(StandardCharsets.UTF_8));
    }

    @Deprecated
    public void sendMessage(@NotNull Identity source, @NotNull Component message, @NotNull MessageType type) {
        Messenger.sendMessage(this, message, ChatPosition.fromMessageType(type), source.uuid());
    }

    public void playSound(@NotNull Sound sound) {
        this.playSound(sound, this.position.x(), this.position.y(), this.position.z());
    }

    public void playSound(@NotNull Sound sound, @NotNull Point point) {
        this.sendPacket(AdventurePacketConvertor.createSoundPacket(sound, point.x(), point.y(), point.z()));
    }

    public void playSound(@NotNull Sound sound, double x, double y, double z) {
        this.sendPacket(AdventurePacketConvertor.createSoundPacket(sound, x, y, z));
    }

    public void playSound(@NotNull Sound sound, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Sound.Emitter emitter) {
        ServerPacket packet = emitter == Sound.Emitter.self() ? AdventurePacketConvertor.createSoundPacket(sound, this) : AdventurePacketConvertor.createSoundPacket(sound, emitter);
        this.sendPacket(packet);
    }

    public void stopSound(@NotNull SoundStop stop) {
        this.sendPacket(AdventurePacketConvertor.createSoundStopPacket(stop));
    }

    public void playEffect(@NotNull Effects effect, int x, int y, int z, int data, boolean disableRelativeVolume) {
        this.sendPacket(new EffectPacket(effect.getId(), new Vec(x, y, z), data, disableRelativeVolume));
    }

    public void sendPlayerListHeaderAndFooter(@NotNull Component header, @NotNull Component footer) {
        this.sendPacket(new PlayerListHeaderAndFooterPacket(header, footer));
    }

    public <T> void sendTitlePart(@NotNull TitlePart<T> part, @NotNull T value) {
        this.sendPacket(AdventurePacketConvertor.createTitlePartPacket(part, value));
    }

    public void sendActionBar(@NotNull Component message) {
        this.sendPacket(new ActionBarPacket(message));
    }

    public void resetTitle() {
        this.sendPacket(new ClearTitlesPacket(true));
    }

    public void clearTitle() {
        this.sendPacket(new ClearTitlesPacket(false));
    }

    public void showBossBar(@NotNull BossBar bar) {
        MinecraftServer.getBossBarManager().addBossBar(this, bar);
    }

    public void hideBossBar(@NotNull BossBar bar) {
        MinecraftServer.getBossBarManager().removeBossBar(this, bar);
    }

    public void openBook(@NotNull Book book) {
        ItemStack writtenBook = ItemStack.builder(Material.WRITTEN_BOOK).meta(WrittenBookMeta.class, builder -> builder.resolved(false).generation(WrittenBookMeta.WrittenBookGeneration.ORIGINAL).author(book.author()).title(book.title()).pages(book.pages())).build();
        this.sendPacket(new SetSlotPacket(0, 0, 45, writtenBook));
        this.sendPacket(new OpenBookPacket(Hand.OFF));
        this.sendPacket(new SetSlotPacket(0, 0, 45, this.getItemInOffHand()));
    }

    @Override
    public boolean isImmune(@NotNull DamageType type) {
        if (!this.getGameMode().canTakeDamage()) {
            return type != DamageType.OUT_OF_WORLD;
        }
        return super.isImmune(type);
    }

    @Override
    public void setHealth(float health) {
        super.setHealth(health);
        this.sendPacket(new UpdateHealthPacket(health, this.food, this.foodSaturation));
    }

    @NotNull
    public PlayerMeta getPlayerMeta() {
        return (PlayerMeta)super.getEntityMeta();
    }

    public float getAdditionalHearts() {
        return this.getPlayerMeta().getAdditionalHearts();
    }

    public void setAdditionalHearts(float additionalHearts) {
        this.getPlayerMeta().setAdditionalHearts(additionalHearts);
    }

    public int getFood() {
        return this.food;
    }

    public void setFood(int food) {
        Check.argCondition(!MathUtils.isBetween(food, 0, 20), "Food has to be between 0 and 20");
        this.food = food;
        this.sendPacket(new UpdateHealthPacket(this.getHealth(), food, this.foodSaturation));
    }

    public float getFoodSaturation() {
        return this.foodSaturation;
    }

    public void setFoodSaturation(float foodSaturation) {
        Check.argCondition(!MathUtils.isBetween(foodSaturation, 0.0f, 20.0f), "Food saturation has to be between 0 and 20");
        this.foodSaturation = foodSaturation;
        this.sendPacket(new UpdateHealthPacket(this.getHealth(), this.food, foodSaturation));
    }

    public boolean isEating() {
        return this.eatingHand != null;
    }

    @Nullable
    public Hand getEatingHand() {
        return this.eatingHand;
    }

    public long getDefaultEatingTime() {
        return this.defaultEatingTime;
    }

    public void setDefaultEatingTime(long defaultEatingTime) {
        this.defaultEatingTime = defaultEatingTime;
    }

    @Override
    public double getEyeHeight() {
        return switch (this.getPose()) {
            case Entity.Pose.SLEEPING -> 0.2;
            case Entity.Pose.FALL_FLYING, Entity.Pose.SWIMMING, Entity.Pose.SPIN_ATTACK -> 0.4;
            case Entity.Pose.SNEAKING -> 1.27;
            default -> 1.62;
        };
    }

    @Nullable
    public Component getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(@Nullable Component displayName) {
        this.displayName = displayName;
        PacketUtils.broadcastPlayPacket(new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME, this.infoEntry()));
    }

    @Nullable
    public PlayerSkin getSkin() {
        return this.skin;
    }

    public synchronized void setSkin(@Nullable PlayerSkin skin) {
        this.skin = skin;
        if (this.instance == null) {
            return;
        }
        DestroyEntitiesPacket destroyEntitiesPacket = new DestroyEntitiesPacket(this.getEntityId());
        PlayerInfoRemovePacket removePlayerPacket = this.getRemovePlayerToList();
        PlayerInfoUpdatePacket addPlayerPacket = this.getAddPlayerToList();
        RespawnPacket respawnPacket = new RespawnPacket(this.getDimensionType().toString(), this.instance.getDimensionName(), 0L, this.gameMode, this.gameMode, false, this.levelFlat, this.deathLocation, this.portalCooldown, 3);
        this.sendPacket(removePlayerPacket);
        this.sendPacket(destroyEntitiesPacket);
        this.sendPacket(addPlayerPacket);
        this.sendPacket(respawnPacket);
        this.refreshClientStateAfterRespawn();
        PacketUtils.broadcastPlayPacket(removePlayerPacket);
        this.sendPacketToViewers(destroyEntitiesPacket);
        PacketUtils.broadcastPlayPacket(addPlayerPacket);
        this.getViewers().forEach(player -> this.showPlayer(player.getPlayerConnection()));
        this.getInventory().update();
        this.teleport(this.getPosition());
    }

    public void setDeathLocation(@NotNull DimensionType type, @NotNull Pos position) {
        this.deathLocation = new DeathLocation(type.getName().asString(), position);
    }

    @Nullable
    public DeathLocation getDeathLocation() {
        return this.deathLocation;
    }

    public boolean isEnableRespawnScreen() {
        return this.enableRespawnScreen;
    }

    public void setEnableRespawnScreen(boolean enableRespawnScreen) {
        this.enableRespawnScreen = enableRespawnScreen;
        this.sendPacket(new ChangeGameStatePacket(ChangeGameStatePacket.Reason.ENABLE_RESPAWN_SCREEN, enableRespawnScreen ? 0.0f : 1.0f));
    }

    @Override
    @NotNull
    public Component getName() {
        return Objects.requireNonNullElse(this.displayName, this.usernameComponent);
    }

    @NotNull
    public String getUsername() {
        return this.username;
    }

    public void setUsernameField(@NotNull String username) {
        this.username = username;
        this.usernameComponent = Component.text((String)username);
    }

    public boolean dropItem(@NotNull ItemStack item) {
        if (item.isAir()) {
            return false;
        }
        ItemDropEvent itemDropEvent = new ItemDropEvent(this, item);
        EventDispatcher.call(itemDropEvent);
        return !itemDropEvent.isCancelled();
    }

    public void sendResourcePacks(@NotNull ResourcePackRequest request) {
        if (request.replace()) {
            this.clearResourcePacks();
        }
        for (ResourcePackInfo pack : request.packs()) {
            this.sendPacket(new ResourcePackPushPacket(pack, request.required(), request.prompt()));
            this.resourcePackCallbacks.put(pack.id(), request.callback());
            if (this.resourcePackFuture != null) continue;
            this.resourcePackFuture = new CompletableFuture();
        }
    }

    public void removeResourcePacks(@NotNull UUID id, UUID ... others) {
        this.sendPacket(new ResourcePackPopPacket(id));
        for (UUID other : others) {
            this.sendPacket(new ResourcePackPopPacket(other));
        }
    }

    public void clearResourcePacks() {
        this.sendPacket(new ResourcePackPopPacket((UUID)null));
    }

    @ApiStatus.Internal
    @Nullable
    public CompletableFuture<Void> getResourcePackFuture() {
        return this.resourcePackFuture;
    }

    @ApiStatus.Internal
    public void onResourcePackStatus(@NotNull UUID id, @NotNull ResourcePackStatus status) {
        ResourcePackCallback callback = this.resourcePackCallbacks.get(id);
        if (callback == null) {
            return;
        }
        callback.packEventReceived(id, status, (Audience)this);
        if (!status.intermediate()) {
            this.resourcePackCallbacks.remove(id);
            if (this.resourcePackCallbacks.isEmpty() && this.resourcePackFuture != null) {
                this.resourcePackFuture.complete(null);
                this.resourcePackFuture = null;
            }
        }
    }

    public void facePosition(@NotNull FacePoint facePoint, @NotNull Point targetPosition) {
        this.facePosition(facePoint, targetPosition, null, null);
    }

    public void facePosition(@NotNull FacePoint facePoint, Entity entity, FacePoint targetPoint) {
        this.facePosition(facePoint, entity.getPosition(), entity, targetPoint);
    }

    private void facePosition(@NotNull FacePoint facePoint, @NotNull Point targetPosition, @Nullable Entity entity, @Nullable FacePoint targetPoint) {
        int entityId = entity != null ? entity.getEntityId() : 0;
        this.sendPacket(new FacePlayerPacket(facePoint == FacePoint.EYE ? FacePlayerPacket.FacePosition.EYES : FacePlayerPacket.FacePosition.FEET, targetPosition, entityId, targetPoint == FacePoint.EYE ? FacePlayerPacket.FacePosition.EYES : FacePlayerPacket.FacePosition.FEET));
    }

    public void spectate(@NotNull Entity entity) {
        this.sendPacket(new CameraPacket(entity));
    }

    public void stopSpectating() {
        this.spectate(this);
    }

    @NotNull
    public Pos getRespawnPoint() {
        return this.respawnPoint;
    }

    public void setRespawnPoint(@NotNull Pos respawnPoint) {
        this.respawnPoint = respawnPoint;
    }

    protected void refreshAfterTeleport() {
        this.sendPacketsToViewers(this.getEntityType().registry().spawnType().getSpawnPacket(this));
        this.sendPacketToViewersAndSelf(this.getVelocityPacket());
        this.sendPacketToViewersAndSelf(this.getMetadataPacket());
        this.sendPacketToViewersAndSelf(this.getPropertiesPacket());
        this.sendPacketToViewersAndSelf(this.getEquipmentsPacket());
        this.getInventory().update();
    }

    protected void refreshHealth() {
        this.food = 20;
        this.foodSaturation = 5.0f;
        this.heal();
    }

    public float getExp() {
        return this.exp;
    }

    public void setExp(float exp) {
        Check.argCondition(!MathUtils.isBetween(exp, 0.0f, 1.0f), "Exp should be between 0 and 1");
        this.exp = exp;
        this.sendPacket(new SetExperiencePacket(exp, this.level, 0));
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
        this.sendPacket(new SetExperiencePacket(this.exp, level, 0));
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public void setPortalCooldown(int portalCooldown) {
        this.portalCooldown = portalCooldown;
    }

    @NotNull
    public PlayerConnection getPlayerConnection() {
        return this.playerConnection;
    }

    @ApiStatus.Experimental
    public void sendPacket(@NotNull SendablePacket packet) {
        this.playerConnection.sendPacket(packet);
    }

    @ApiStatus.Experimental
    public void sendPackets(SendablePacket ... packets) {
        this.playerConnection.sendPackets(packets);
    }

    @ApiStatus.Experimental
    public void sendPackets(@NotNull Collection<SendablePacket> packets) {
        this.playerConnection.sendPackets(packets);
    }

    public boolean isOnline() {
        return this.playerConnection.isOnline();
    }

    @NotNull
    public PlayerSettings getSettings() {
        return this.settings;
    }

    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    @NotNull
    public PlayerInventory getInventory() {
        return this.inventory;
    }

    public int getLatency() {
        return this.latency;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public boolean setGameMode(@NotNull GameMode gameMode) {
        PlayerGameModeChangeEvent playerGameModeChangeEvent = new PlayerGameModeChangeEvent(this, gameMode);
        EventDispatcher.call(playerGameModeChangeEvent);
        if (playerGameModeChangeEvent.isCancelled()) {
            return false;
        }
        this.gameMode = gameMode = playerGameModeChangeEvent.getNewGameMode();
        if (this.isActive()) {
            this.sendPacket(new ChangeGameStatePacket(ChangeGameStatePacket.Reason.CHANGE_GAMEMODE, gameMode.id()));
            PacketUtils.broadcastPlayPacket(new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.UPDATE_GAME_MODE, this.infoEntry()));
        }
        switch (gameMode) {
            case CREATIVE: {
                this.allowFlying = true;
                this.instantBreak = true;
                this.invulnerable = true;
                break;
            }
            case SPECTATOR: {
                this.allowFlying = true;
                this.instantBreak = false;
                this.invulnerable = true;
                if (this.isActive()) {
                    this.refreshFlying(true);
                    break;
                }
                this.flying = true;
                break;
            }
            default: {
                this.allowFlying = false;
                this.instantBreak = false;
                this.invulnerable = false;
                if (this.isActive()) {
                    this.refreshFlying(false);
                    break;
                }
                this.flying = false;
            }
        }
        if (this.isActive()) {
            this.refreshAbilities();
        }
        return true;
    }

    public boolean isCreative() {
        return this.gameMode == GameMode.CREATIVE;
    }

    protected void sendDimension(@NotNull DimensionType dimensionType, @NotNull String dimensionName) {
        Check.argCondition(this.instance.getDimensionName().equals(dimensionName), "The dimension needs to be different than the current one!");
        this.dimensionType = dimensionType;
        this.sendPacket(new RespawnPacket(dimensionType.toString(), dimensionName, 0L, this.gameMode, this.gameMode, false, this.levelFlat, this.deathLocation, this.portalCooldown, 3));
        this.refreshClientStateAfterRespawn();
    }

    public void kick(@NotNull Component component) {
        Record disconnectPacket = this.playerConnection.getConnectionState() == ConnectionState.LOGIN ? new LoginDisconnectPacket(component) : new DisconnectPacket(component);
        this.sendPacket((SendablePacket)((Object)disconnectPacket));
        this.playerConnection.disconnect();
    }

    public void kick(@NotNull String message) {
        this.kick((Component)Component.text((String)message));
    }

    public void setHeldItemSlot(byte slot) {
        Check.argCondition(!MathUtils.isBetween((int)slot, 0, 8), "Slot has to be between 0 and 8");
        this.refreshHeldSlot(slot);
        this.sendPacket(new HeldItemChangePacket(slot));
    }

    public byte getHeldSlot() {
        return this.heldSlot;
    }

    public void setBelowNameTag(BelowNameTag belowNameTag) {
        if (this.belowNameTag == belowNameTag) {
            return;
        }
        if (this.belowNameTag != null) {
            this.belowNameTag.removeViewer(this);
        }
        this.belowNameTag = belowNameTag;
    }

    @Nullable
    public Inventory getOpenInventory() {
        return this.openInventory;
    }

    public boolean openInventory(@NotNull Inventory inventory) {
        InventoryOpenEvent inventoryOpenEvent = new InventoryOpenEvent(inventory, this);
        EventDispatcher.callCancellable(inventoryOpenEvent, () -> {
            Inventory newInventory;
            Inventory openInventory = this.getOpenInventory();
            if (openInventory != null) {
                openInventory.removeViewer(this);
            }
            if ((newInventory = inventoryOpenEvent.getInventory()) == null) {
                return;
            }
            this.sendPacket(new OpenWindowPacket(newInventory.getWindowId(), newInventory.getInventoryType().getWindowType(), newInventory.getTitle()));
            newInventory.addViewer(this);
            this.openInventory = newInventory;
        });
        return !inventoryOpenEvent.isCancelled();
    }

    public void closeInventory() {
        this.closeInventory(false);
    }

    @ApiStatus.Internal
    public void closeInventory(boolean fromClient) {
        ItemStack cursorItem;
        Inventory openInventory = this.getOpenInventory();
        if (openInventory == null) {
            cursorItem = this.getInventory().getCursorItem();
            this.getInventory().setCursorItem(ItemStack.AIR);
        } else {
            cursorItem = openInventory.getCursorItem(this);
            openInventory.setCursorItem(this, ItemStack.AIR);
        }
        if (!cursorItem.isAir() && !this.dropItem(cursorItem)) {
            this.getInventory().addItemStack(cursorItem);
        }
        if (openInventory == this.getOpenInventory()) {
            CloseWindowPacket closeWindowPacket;
            if (openInventory == null) {
                closeWindowPacket = new CloseWindowPacket(0);
            } else {
                closeWindowPacket = new CloseWindowPacket(openInventory.getWindowId());
                openInventory.removeViewer(this);
                this.openInventory = null;
            }
            if (!fromClient) {
                this.sendPacket(closeWindowPacket);
            }
            this.inventory.update();
            this.didCloseInventory = true;
        }
    }

    public boolean didCloseInventory() {
        return this.didCloseInventory;
    }

    @ApiStatus.Internal
    public void UNSAFE_changeDidCloseInventory(boolean didCloseInventory) {
        this.didCloseInventory = didCloseInventory;
    }

    public int getNextTeleportId() {
        return this.teleportId.incrementAndGet();
    }

    public int getLastSentTeleportId() {
        return this.teleportId.get();
    }

    public int getLastReceivedTeleportId() {
        return this.receivedTeleportId;
    }

    public void refreshReceivedTeleportId(int receivedTeleportId) {
        this.receivedTeleportId = receivedTeleportId;
    }

    @ApiStatus.Internal
    void synchronizePositionAfterTeleport(@NotNull Pos position, int relativeFlags) {
        this.sendPacket(new PlayerPositionAndLookPacket(position, (byte)relativeFlags, this.getNextTeleportId()));
        super.synchronizePosition();
    }

    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    public void setPermissionLevel(int permissionLevel) {
        Check.argCondition(!MathUtils.isBetween(permissionLevel, 0, 4), "permissionLevel has to be between 0 and 4");
        this.permissionLevel = permissionLevel;
        if (this.isActive()) {
            byte permissionLevelStatus = (byte)(24 + permissionLevel);
            this.triggerStatus(permissionLevelStatus);
        }
    }

    public void setReducedDebugScreenInformation(boolean reduced) {
        this.reducedDebugScreenInformation = reduced;
        byte debugScreenStatus = (byte)(reduced ? 22 : 23);
        this.triggerStatus(debugScreenStatus);
    }

    public boolean hasReducedDebugScreenInformation() {
        return this.reducedDebugScreenInformation;
    }

    @Override
    public boolean isInvulnerable() {
        return super.isInvulnerable();
    }

    @Override
    public void setInvulnerable(boolean invulnerable) {
        super.setInvulnerable(invulnerable);
        this.refreshAbilities();
    }

    @Override
    public void setSneaking(boolean sneaking) {
        if (this.isFlying()) {
            this.entityMeta.setSneaking(sneaking);
        } else {
            super.setSneaking(sneaking);
        }
    }

    public boolean isFlying() {
        return this.flying;
    }

    public void setFlying(boolean flying) {
        this.refreshFlying(flying);
        this.refreshAbilities();
    }

    public void refreshFlying(boolean flying) {
        if (this.flying != flying) {
            Entity.Pose pose = this.getPose();
            if (this.isSneaking() && pose == Entity.Pose.STANDING) {
                this.setPose(Entity.Pose.SNEAKING);
            } else if (pose == Entity.Pose.SNEAKING) {
                this.setPose(Entity.Pose.STANDING);
            }
        }
        this.flying = flying;
    }

    public boolean isAllowFlying() {
        return this.allowFlying;
    }

    public void setAllowFlying(boolean allowFlying) {
        this.allowFlying = allowFlying;
        this.refreshAbilities();
    }

    public boolean isInstantBreak() {
        return this.instantBreak;
    }

    public void setInstantBreak(boolean instantBreak) {
        this.instantBreak = instantBreak;
        this.refreshAbilities();
    }

    public float getFlyingSpeed() {
        return this.flyingSpeed;
    }

    public void setFlyingSpeed(float flyingSpeed) {
        this.flyingSpeed = flyingSpeed;
        this.refreshAbilities();
    }

    public float getFieldViewModifier() {
        return this.fieldViewModifier;
    }

    public void setFieldViewModifier(float fieldViewModifier) {
        this.fieldViewModifier = fieldViewModifier;
        this.refreshAbilities();
    }

    @NotNull
    public Map<PlayerStatistic, Integer> getStatisticValueMap() {
        return this.statisticValueMap;
    }

    @NotNull
    public PlayerVehicleInformation getVehicleInformation() {
        return this.vehicleInformation;
    }

    protected void refreshAbilities() {
        byte flags = 0;
        if (this.invulnerable) {
            flags = (byte)(flags | 1);
        }
        if (this.flying) {
            flags = (byte)(flags | 2);
        }
        if (this.allowFlying) {
            flags = (byte)(flags | 4);
        }
        if (this.instantBreak) {
            flags = (byte)(flags | 8);
        }
        this.sendPacket(new PlayerAbilitiesPacket(flags, this.flyingSpeed, this.fieldViewModifier));
    }

    public void addPacketToQueue(@NotNull ClientPacket packet) {
        this.packets.offer((Object)packet);
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public void interpretPacketQueue() {
        if (this.packets.size() >= ServerFlag.PLAYER_PACKET_QUEUE_SIZE) {
            this.kick((Component)Component.text((String)"Too Many Packets", (TextColor)NamedTextColor.RED));
            return;
        }
        PacketListenerManager manager = MinecraftServer.getPacketListenerManager();
        this.packets.drain(packet -> manager.processClientPacket(packet, this.playerConnection), ServerFlag.PLAYER_PACKET_PER_TICK);
    }

    public void refreshLatency(int latency) {
        this.latency = latency;
        if (this.getPlayerConnection().getConnectionState() == ConnectionState.PLAY) {
            PacketUtils.broadcastPlayPacket(new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.UPDATE_LATENCY, this.infoEntry()));
        }
    }

    public void refreshOnGround(boolean onGround) {
        this.onGround = onGround;
        if (this.onGround && this.isFlyingWithElytra()) {
            this.setFlyingWithElytra(false);
            EventDispatcher.call(new PlayerStopFlyingWithElytraEvent(this));
        }
    }

    public void refreshKeepAlive(long lastKeepAlive) {
        this.lastKeepAlive = lastKeepAlive;
        this.answerKeepAlive = false;
    }

    public boolean didAnswerKeepAlive() {
        return this.answerKeepAlive;
    }

    public void refreshAnswerKeepAlive(boolean answerKeepAlive) {
        this.answerKeepAlive = answerKeepAlive;
    }

    public void refreshHeldSlot(byte slot) {
        this.heldSlot = slot;
        this.syncEquipment(EquipmentSlot.MAIN_HAND);
        this.refreshEating(null);
    }

    public void refreshEating(@Nullable Hand eatingHand, long eatingTime) {
        this.eatingHand = eatingHand;
        if (eatingHand != null) {
            this.startEatingTime = System.currentTimeMillis();
            this.eatingTime = eatingTime;
        } else {
            this.startEatingTime = 0L;
        }
    }

    public void refreshEating(@Nullable Hand eatingHand) {
        this.refreshEating(eatingHand, this.defaultEatingTime);
    }

    @Deprecated
    @Nullable
    public ItemUpdateStateEvent callItemUpdateStateEvent(boolean allowFood, @Nullable Hand hand) {
        if (hand == null) {
            return null;
        }
        ItemStack updatedItem = this.getItemInHand(hand);
        boolean isFood = updatedItem.material().isFood();
        if (isFood && !allowFood) {
            return null;
        }
        ItemUpdateStateEvent itemUpdateStateEvent = new ItemUpdateStateEvent(this, hand, updatedItem);
        EventDispatcher.call(itemUpdateStateEvent);
        return itemUpdateStateEvent;
    }

    @Nullable
    public ItemUpdateStateEvent callItemUpdateStateEvent(@Nullable Hand hand) {
        return this.callItemUpdateStateEvent(true, hand);
    }

    public void refreshVehicleSteer(float sideways, float forward, boolean jump, boolean unmount) {
        this.vehicleInformation.refresh(sideways, forward, jump, unmount);
    }

    public long getLastKeepAlive() {
        return this.lastKeepAlive;
    }

    @Override
    @NotNull
    public HoverEvent<HoverEvent.ShowEntity> asHoverEvent(@NotNull UnaryOperator<HoverEvent.ShowEntity> op) {
        return HoverEvent.showEntity((HoverEvent.ShowEntity)HoverEvent.ShowEntity.showEntity((Keyed)EntityType.PLAYER, (UUID)this.uuid, (Component)this.displayName));
    }

    @NotNull
    protected PlayerInfoUpdatePacket getAddPlayerToList() {
        return new PlayerInfoUpdatePacket(EnumSet.of(PlayerInfoUpdatePacket.Action.ADD_PLAYER, PlayerInfoUpdatePacket.Action.UPDATE_LISTED), List.of(this.infoEntry()));
    }

    @NotNull
    protected PlayerInfoRemovePacket getRemovePlayerToList() {
        return new PlayerInfoRemovePacket(this.getUuid());
    }

    private PlayerInfoUpdatePacket.Entry infoEntry() {
        PlayerSkin skin = this.skin;
        List<PlayerInfoUpdatePacket.Property> prop = skin != null ? List.of(new PlayerInfoUpdatePacket.Property("textures", skin.textures(), skin.signature())) : List.of();
        return new PlayerInfoUpdatePacket.Entry(this.getUuid(), this.getUsername(), prop, true, this.getLatency(), this.getGameMode(), this.displayName, null);
    }

    protected void showPlayer(@NotNull PlayerConnection connection) {
        connection.sendPacket(this.getEntityType().registry().spawnType().getSpawnPacket(this));
        connection.sendPacket(this.getVelocityPacket());
        connection.sendPacket(this.getMetadataPacket());
        connection.sendPacket(this.getEquipmentsPacket());
        if (this.hasPassenger()) {
            connection.sendPacket(this.getPassengersPacket());
        }
        connection.sendPacket(new EntityHeadLookPacket(this.getEntityId(), this.position.yaw()));
    }

    @Override
    @NotNull
    public ItemStack getItemInMainHand() {
        return this.inventory.getItemInMainHand();
    }

    @Override
    public void setItemInMainHand(@NotNull ItemStack itemStack) {
        this.inventory.setItemInMainHand(itemStack);
    }

    @Override
    @NotNull
    public ItemStack getItemInOffHand() {
        return this.inventory.getItemInOffHand();
    }

    @Override
    public void setItemInOffHand(@NotNull ItemStack itemStack) {
        this.inventory.setItemInOffHand(itemStack);
    }

    @Override
    @NotNull
    public ItemStack getHelmet() {
        return this.inventory.getHelmet();
    }

    @Override
    public void setHelmet(@NotNull ItemStack itemStack) {
        this.inventory.setHelmet(itemStack);
    }

    @Override
    @NotNull
    public ItemStack getChestplate() {
        return this.inventory.getChestplate();
    }

    @Override
    public void setChestplate(@NotNull ItemStack itemStack) {
        this.inventory.setChestplate(itemStack);
    }

    @Override
    @NotNull
    public ItemStack getLeggings() {
        return this.inventory.getLeggings();
    }

    @Override
    public void setLeggings(@NotNull ItemStack itemStack) {
        this.inventory.setLeggings(itemStack);
    }

    @Override
    @NotNull
    public ItemStack getBoots() {
        return this.inventory.getBoots();
    }

    @Override
    public void setBoots(@NotNull ItemStack itemStack) {
        this.inventory.setBoots(itemStack);
    }

    @Override
    public Locale getLocale() {
        String locale = this.settings.locale;
        if (locale == null) {
            return null;
        }
        return Locale.forLanguageTag(locale.replace("_", "-"));
    }

    @Override
    @NotNull
    public PlayerSnapshot updateSnapshot(@NotNull SnapshotUpdater updater) {
        EntitySnapshot snapshot = super.updateSnapshot(updater);
        return new SnapshotImpl.Player(snapshot, this.username, this.gameMode);
    }

    @Override
    public void setLocale(@Nullable Locale locale) {
        this.settings.locale = locale == null ? null : locale.toLanguageTag();
    }

    @NotNull
    public Identity identity() {
        return this.identity;
    }

    @NotNull
    public Pointers pointers() {
        return this.pointers;
    }

    @Override
    public void setUuid(@NotNull UUID uuid) {
        super.setUuid(uuid);
        this.identity = Identity.identity((UUID)uuid);
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    @Override
    public Player asPlayer() {
        return this;
    }

    protected void sendChunkUpdates(Chunk newChunk) {
        if (this.chunkUpdateLimitChecker.addToHistory(newChunk)) {
            int newX = newChunk.getChunkX();
            int newZ = newChunk.getChunkZ();
            Vec old = this.chunksLoadedByClient;
            this.sendPacket(new UpdateViewPositionPacket(newX, newZ));
            ChunkUtils.forDifferingChunksInRange(newX, newZ, (int)old.x(), (int)old.z(), this.settings.getEffectiveViewDistance(), this.chunkAdder, this.chunkRemover);
            this.chunksLoadedByClient = new Vec(newX, newZ);
        }
    }

    @Override
    @NotNull
    public CompletableFuture<Void> teleport(@NotNull Pos position, long @Nullable [] chunks, int flags) {
        this.chunkUpdateLimitChecker.clearHistory();
        return super.teleport(position, chunks, flags);
    }

    private int compareChunkDistance(long chunkIndexA, long chunkIndexB) {
        int chunkAX = ChunkUtils.getChunkCoordX(chunkIndexA);
        int chunkAZ = ChunkUtils.getChunkCoordZ(chunkIndexA);
        int chunkBX = ChunkUtils.getChunkCoordX(chunkIndexB);
        int chunkBZ = ChunkUtils.getChunkCoordZ(chunkIndexB);
        int chunkDistanceA = Math.abs(chunkAX - this.chunksLoadedByClient.blockX()) + Math.abs(chunkAZ - this.chunksLoadedByClient.blockZ());
        int chunkDistanceB = Math.abs(chunkBX - this.chunksLoadedByClient.blockX()) + Math.abs(chunkBZ - this.chunksLoadedByClient.blockZ());
        return Integer.compare(chunkDistanceA, chunkDistanceB);
    }

    public class PlayerSettings {
        private String locale;
        private byte viewDistance = (byte)ServerFlag.CHUNK_VIEW_DISTANCE;
        private ChatMessageType chatMessageType;
        private boolean chatColors;
        private byte displayedSkinParts;
        private MainHand mainHand;
        private boolean enableTextFiltering;
        private boolean allowServerListings;

        public String getLocale() {
            return this.locale;
        }

        public byte getViewDistance() {
            return this.viewDistance;
        }

        public int getEffectiveViewDistance() {
            return Math.min(this.getViewDistance(), ServerFlag.CHUNK_VIEW_DISTANCE);
        }

        @Nullable
        public ChatMessageType getChatMessageType() {
            return this.chatMessageType;
        }

        public boolean hasChatColors() {
            return this.chatColors;
        }

        public byte getDisplayedSkinParts() {
            return this.displayedSkinParts;
        }

        public MainHand getMainHand() {
            return this.mainHand;
        }

        public boolean enableTextFiltering() {
            return this.enableTextFiltering;
        }

        public boolean allowServerListings() {
            return this.allowServerListings;
        }

        public void refresh(String locale, byte viewDistance, ChatMessageType chatMessageType, boolean chatColors, byte displayedSkinParts, MainHand mainHand, boolean enableTextFiltering, boolean allowServerListings) {
            this.locale = locale;
            this.viewDistance = (byte)MathUtils.clamp(viewDistance, 2, 32);
            this.chatMessageType = chatMessageType;
            this.chatColors = chatColors;
            this.displayedSkinParts = displayedSkinParts;
            this.mainHand = mainHand;
            this.enableTextFiltering = enableTextFiltering;
            this.allowServerListings = allowServerListings;
            boolean isInPlayState = Player.this.getPlayerConnection().getConnectionState() == ConnectionState.PLAY;
            PlayerMeta playerMeta = Player.this.getPlayerMeta();
            if (isInPlayState) {
                playerMeta.setNotifyAboutChanges(false);
            }
            playerMeta.setDisplayedSkinParts(displayedSkinParts);
            playerMeta.setRightMainHand(this.mainHand == MainHand.RIGHT);
            if (isInPlayState) {
                playerMeta.setNotifyAboutChanges(true);
            }
        }
    }

    public static enum Hand {
        MAIN,
        OFF;

    }

    public static enum FacePoint {
        FEET,
        EYE;

    }

    public static enum MainHand {
        LEFT,
        RIGHT;

    }
}

