/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.kyori.adventure.sound.Sound;
import net.minestom.server.adventure.AdventurePacketConvertor;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record StopSoundPacket(byte flags, @Nullable Sound.Source source, @Nullable String sound) implements ServerPacket.Play
{
    public StopSoundPacket(@NotNull NetworkBuffer reader) {
        this(StopSoundPacket.read(reader));
    }

    private StopSoundPacket(StopSoundPacket packet) {
        this(packet.flags, packet.source, packet.sound);
    }

    private static StopSoundPacket read(@NotNull NetworkBuffer reader) {
        byte flags = reader.read(NetworkBuffer.BYTE);
        Sound.Source source = flags == 3 || flags == 1 ? reader.readEnum(Sound.Source.class) : null;
        String sound = flags == 2 || flags == 3 ? reader.read(NetworkBuffer.STRING) : null;
        return new StopSoundPacket(flags, source, sound);
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.BYTE, this.flags);
        if (this.flags == 3 || this.flags == 1) {
            assert (this.source != null);
            writer.write(NetworkBuffer.VAR_INT, AdventurePacketConvertor.getSoundSourceValue(this.source));
        }
        if (this.flags == 2 || this.flags == 3) {
            assert (this.sound != null);
            writer.write(NetworkBuffer.STRING, this.sound);
        }
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.STOP_SOUND;
    }
}

