/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.attribute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minestom.server.entity.attribute.Attribute;
import net.minestom.server.entity.attribute.AttributeModifier;
import net.minestom.server.entity.attribute.AttributeOperation;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AttributeInstance {
    public static final NetworkBuffer.Type<AttributeInstance> NETWORK_TYPE = new NetworkBuffer.Type<AttributeInstance>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, AttributeInstance value) {
            buffer.write(Attribute.NETWORK_TYPE, value.attribute());
            buffer.write(NetworkBuffer.DOUBLE, value.getBaseValue());
            buffer.writeCollection(AttributeModifier.NETWORK_TYPE, value.modifiers());
        }

        @Override
        public AttributeInstance read(@NotNull NetworkBuffer buffer) {
            return new AttributeInstance(buffer.read(Attribute.NETWORK_TYPE), buffer.read(NetworkBuffer.DOUBLE), buffer.readCollection(AttributeModifier.NETWORK_TYPE, Short.MAX_VALUE), null);
        }
    };
    private final Attribute attribute;
    private final Map<NamespaceID, AttributeModifier> modifiers;
    private final Collection<AttributeModifier> unmodifiableModifiers;
    private double baseValue;
    private final Consumer<AttributeInstance> propertyChangeListener;
    private double cachedValue = 0.0;

    public AttributeInstance(@NotNull Attribute attribute, @Nullable Consumer<AttributeInstance> listener) {
        this(attribute, attribute.defaultValue(), new ArrayList<AttributeModifier>(), listener);
    }

    public AttributeInstance(@NotNull Attribute attribute, double baseValue, @NotNull Collection<AttributeModifier> modifiers, @Nullable Consumer<AttributeInstance> listener) {
        this.attribute = attribute;
        this.modifiers = new HashMap<NamespaceID, AttributeModifier>();
        for (AttributeModifier modifier : modifiers) {
            this.modifiers.put(modifier.id(), modifier);
        }
        this.unmodifiableModifiers = Collections.unmodifiableCollection(this.modifiers.values());
        this.baseValue = baseValue;
        this.propertyChangeListener = listener;
        this.refreshCachedValue();
    }

    @NotNull
    public Attribute attribute() {
        return this.attribute;
    }

    public double getBaseValue() {
        return this.baseValue;
    }

    public void setBaseValue(double baseValue) {
        if (this.baseValue != baseValue) {
            this.baseValue = baseValue;
            this.refreshCachedValue();
        }
    }

    @NotNull
    public Collection<AttributeModifier> modifiers() {
        return this.unmodifiableModifiers;
    }

    public void addModifier(@NotNull AttributeModifier modifier) {
        if (this.modifiers.putIfAbsent(modifier.id(), modifier) == null) {
            this.refreshCachedValue();
        }
    }

    public void removeModifier(@NotNull AttributeModifier modifier) {
        this.removeModifier(modifier.id());
    }

    public void removeModifier(@NotNull NamespaceID id) {
        if (this.modifiers.remove(id) != null) {
            this.refreshCachedValue();
        }
    }

    public double getValue() {
        return this.cachedValue;
    }

    private void refreshCachedValue() {
        Collection<AttributeModifier> modifiers = this.getModifiers();
        double base = this.getBaseValue();
        for (AttributeModifier modifier : (AttributeModifier[])modifiers.stream().filter(mod -> mod.operation() == AttributeOperation.ADD_VALUE).toArray(AttributeModifier[]::new)) {
            base += modifier.amount();
        }
        double result = base;
        for (AttributeModifier modifier : (AttributeModifier[])modifiers.stream().filter(mod -> mod.operation() == AttributeOperation.MULTIPLY_BASE).toArray(AttributeModifier[]::new)) {
            result += base * modifier.amount();
        }
        for (AttributeModifier modifier : (AttributeModifier[])modifiers.stream().filter(mod -> mod.operation() == AttributeOperation.MULTIPLY_TOTAL).toArray(AttributeModifier[]::new)) {
            result *= 1.0 + modifier.amount();
        }
        this.cachedValue = Math.clamp(result, this.getAttribute().minValue(), this.getAttribute().maxValue());
        if (this.propertyChangeListener != null) {
            this.propertyChangeListener.accept(this);
        }
    }

    @Deprecated
    @NotNull
    public Collection<AttributeModifier> getModifiers() {
        return this.modifiers();
    }

    @Deprecated
    @NotNull
    public Attribute getAttribute() {
        return this.attribute;
    }
}

