/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.adventure.provider;

import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.serializer.json.LegacyHoverEventSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.util.Codec;
import net.minestom.server.adventure.MinestomAdventure;
import org.jetbrains.annotations.NotNull;

final class NBTLegacyHoverEventSerializer
implements LegacyHoverEventSerializer {
    static final NBTLegacyHoverEventSerializer INSTANCE = new NBTLegacyHoverEventSerializer();
    private static final String ITEM_TYPE = "id";
    private static final String ITEM_COUNT = "Count";
    private static final String ITEM_TAG = "tag";
    private static final String ENTITY_TYPE = "type";
    private static final String ENTITY_NAME = "name";
    private static final String ENTITY_ID = "id";

    private NBTLegacyHoverEventSerializer() {
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HoverEvent.ShowItem deserializeShowItem(@NotNull Component input) throws IOException {
        String raw = PlainTextComponentSerializer.plainText().serialize(input);
        CompoundBinaryTag contents = (CompoundBinaryTag)MinestomAdventure.NBT_CODEC.decode((Object)raw);
        CompoundBinaryTag tag = contents.getCompound(ITEM_TAG);
        return HoverEvent.ShowItem.showItem((Key)Key.key((String)contents.getString("id", "")), (int)contents.getByte(ITEM_COUNT, (byte)1), tag.size() == 0 ? null : BinaryTagHolder.encode((Object)tag, MinestomAdventure.NBT_CODEC));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HoverEvent.ShowEntity deserializeShowEntity(@NotNull Component input, Codec.Decoder<Component, String, ? extends RuntimeException> componentDecoder) throws IOException {
        String raw = PlainTextComponentSerializer.plainText().serialize(input);
        CompoundBinaryTag contents = (CompoundBinaryTag)MinestomAdventure.NBT_CODEC.decode((Object)raw);
        return HoverEvent.ShowEntity.showEntity((Key)Key.key((String)contents.getString(ENTITY_TYPE, "")), (UUID)UUID.fromString(Objects.requireNonNullElse(contents.getString("id"), "")), (Component)((Component)componentDecoder.decode((Object)Objects.requireNonNullElse(contents.getString(ENTITY_NAME), ""))));
    }

    @NotNull
    public Component serializeShowItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HoverEvent.ShowItem input) throws IOException {
        CompoundBinaryTag.Builder tag = CompoundBinaryTag.builder();
        tag.putString("id", input.item().asString());
        tag.putByte(ITEM_COUNT, (byte)input.count());
        BinaryTagHolder nbt = input.nbt();
        if (nbt != null) {
            tag.put(ITEM_TAG, (BinaryTag)nbt.get(MinestomAdventure.NBT_CODEC));
        }
        return Component.text((String)((String)MinestomAdventure.NBT_CODEC.encode((Object)tag.build())));
    }

    @NotNull
    public Component serializeShowEntity(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HoverEvent.ShowEntity input, Codec.Encoder<Component, String, ? extends RuntimeException> componentEncoder) throws IOException {
        CompoundBinaryTag.Builder tag = CompoundBinaryTag.builder();
        tag.putString("id", input.id().toString());
        tag.putString(ENTITY_TYPE, input.type().asString());
        Component name = input.name();
        if (name != null) {
            tag.putString(ENTITY_NAME, (String)componentEncoder.encode((Object)name));
        }
        return Component.text((String)((String)MinestomAdventure.NBT_CODEC.encode((Object)tag.build())));
    }
}

