/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.ai.goal;

import java.time.Duration;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityCreature;
import net.minestom.server.entity.ai.GoalSelector;
import net.minestom.server.entity.pathfinding.Navigator;
import org.jetbrains.annotations.NotNull;

public class FollowTargetGoal
extends GoalSelector {
    private final Duration pathDuration;
    private long lastUpdateTime = 0L;
    private boolean forceEnd = false;
    private Point lastTargetPos;
    private Entity target;

    public FollowTargetGoal(@NotNull EntityCreature entityCreature, @NotNull Duration pathDuration) {
        super(entityCreature);
        this.pathDuration = pathDuration;
    }

    @Override
    public boolean shouldStart() {
        boolean result;
        Entity target = this.entityCreature.getTarget();
        if (target == null) {
            target = this.findTarget();
        }
        if (target == null) {
            return false;
        }
        boolean bl = result = target.getPosition().distanceSquared(this.entityCreature.getPosition()) >= 4.0;
        if (result) {
            this.target = target;
        }
        return result;
    }

    @Override
    public void start() {
        this.lastUpdateTime = 0L;
        this.forceEnd = false;
        this.lastTargetPos = null;
        if (this.target == null) {
            this.forceEnd = true;
            return;
        }
        this.entityCreature.setTarget(this.target);
        Navigator navigator = this.entityCreature.getNavigator();
        this.lastTargetPos = this.target.getPosition();
        if (this.lastTargetPos.distanceSquared(this.entityCreature.getPosition()) < 4.0) {
            this.forceEnd = true;
            navigator.setPathTo(null);
            return;
        }
        if (navigator.getPathPosition() == null || !navigator.getPathPosition().samePoint(this.lastTargetPos)) {
            navigator.setPathTo(this.lastTargetPos);
        } else {
            this.forceEnd = true;
        }
    }

    @Override
    public void tick(long time) {
        Pos targetPos;
        if (this.forceEnd || this.pathDuration.isZero() || this.pathDuration.toMillis() + this.lastUpdateTime > time) {
            return;
        }
        Pos pos = targetPos = this.entityCreature.getTarget() != null ? this.entityCreature.getTarget().getPosition() : null;
        if (targetPos != null && !targetPos.sameBlock(this.lastTargetPos)) {
            this.lastUpdateTime = time;
            this.lastTargetPos = targetPos;
            this.entityCreature.getNavigator().setPathTo(targetPos);
        }
    }

    @Override
    public boolean shouldEnd() {
        Entity target = this.entityCreature.getTarget();
        return this.forceEnd || target == null || target.isRemoved() || target.getPosition().distanceSquared(this.entityCreature.getPosition()) < 4.0;
    }

    @Override
    public void end() {
        this.entityCreature.getNavigator().setPathTo(null);
    }
}

