/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server;

import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.FramedPacket;
import net.minestom.server.network.packet.server.LazyPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public sealed interface SendablePacket
permits CachedPacket, FramedPacket, LazyPacket, ServerPacket {
    @ApiStatus.Experimental
    @NotNull
    public static ServerPacket extractServerPacket(@NotNull ConnectionState state, @NotNull SendablePacket packet) {
        if (packet instanceof ServerPacket) {
            ServerPacket serverPacket = (ServerPacket)packet;
            return serverPacket;
        }
        if (packet instanceof CachedPacket) {
            CachedPacket cachedPacket = (CachedPacket)packet;
            return cachedPacket.packet(state);
        }
        if (packet instanceof FramedPacket) {
            FramedPacket framedPacket = (FramedPacket)packet;
            return framedPacket.packet();
        }
        if (packet instanceof LazyPacket) {
            LazyPacket lazyPacket = (LazyPacket)packet;
            return lazyPacket.packet();
        }
        throw new RuntimeException("Unknown packet type: " + packet.getClass().getName());
    }
}

