/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerFlag;
import net.minestom.server.ServerProcess;
import net.minestom.server.Tickable;
import net.minestom.server.Viewable;
import net.minestom.server.collision.Aerodynamics;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.CollisionUtils;
import net.minestom.server.collision.PhysicsResult;
import net.minestom.server.collision.PhysicsUtils;
import net.minestom.server.collision.Shape;
import net.minestom.server.collision.SweepResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.EntitySpawnType;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.EntityTypeImpl;
import net.minestom.server.entity.EntityView;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.Player;
import net.minestom.server.entity.metadata.EntityMeta;
import net.minestom.server.entity.metadata.LivingEntityMeta;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.EventFilter;
import net.minestom.server.event.EventHandler;
import net.minestom.server.event.EventNode;
import net.minestom.server.event.entity.EntityDespawnEvent;
import net.minestom.server.event.entity.EntityPotionAddEvent;
import net.minestom.server.event.entity.EntityPotionRemoveEvent;
import net.minestom.server.event.entity.EntitySpawnEvent;
import net.minestom.server.event.entity.EntityTickEvent;
import net.minestom.server.event.entity.EntityVelocityEvent;
import net.minestom.server.event.instance.AddEntityToInstanceEvent;
import net.minestom.server.event.instance.RemoveEntityFromInstanceEvent;
import net.minestom.server.event.trait.EntityEvent;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.EntityTracker;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.play.AttachEntityPacket;
import net.minestom.server.network.packet.server.play.DestroyEntitiesPacket;
import net.minestom.server.network.packet.server.play.EntityHeadLookPacket;
import net.minestom.server.network.packet.server.play.EntityMetaDataPacket;
import net.minestom.server.network.packet.server.play.EntityPositionAndRotationPacket;
import net.minestom.server.network.packet.server.play.EntityRotationPacket;
import net.minestom.server.network.packet.server.play.EntityStatusPacket;
import net.minestom.server.network.packet.server.play.EntityTeleportPacket;
import net.minestom.server.network.packet.server.play.EntityVelocityPacket;
import net.minestom.server.network.packet.server.play.SetPassengersPacket;
import net.minestom.server.permission.Permission;
import net.minestom.server.permission.PermissionHandler;
import net.minestom.server.potion.Potion;
import net.minestom.server.potion.PotionEffect;
import net.minestom.server.potion.TimedPotion;
import net.minestom.server.snapshot.EntitySnapshot;
import net.minestom.server.snapshot.SnapshotImpl;
import net.minestom.server.snapshot.SnapshotUpdater;
import net.minestom.server.snapshot.Snapshotable;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.Taggable;
import net.minestom.server.thread.Acquirable;
import net.minestom.server.thread.AcquirableSource;
import net.minestom.server.timer.Schedulable;
import net.minestom.server.timer.Scheduler;
import net.minestom.server.timer.TaskSchedule;
import net.minestom.server.utils.ArrayUtils;
import net.minestom.server.utils.PacketUtils;
import net.minestom.server.utils.async.AsyncUtils;
import net.minestom.server.utils.block.BlockIterator;
import net.minestom.server.utils.chunk.ChunkCache;
import net.minestom.server.utils.chunk.ChunkUtils;
import net.minestom.server.utils.entity.EntityUtils;
import net.minestom.server.utils.position.PositionUtils;
import net.minestom.server.utils.time.TimeUnit;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class Entity
implements Viewable,
Tickable,
Schedulable,
Snapshotable,
EventHandler<EntityEvent>,
Taggable,
PermissionHandler,
HoverEventSource<HoverEvent.ShowEntity>,
Sound.Emitter,
Shape,
AcquirableSource<Entity> {
    private static final AtomicInteger LAST_ENTITY_ID = new AtomicInteger();
    private static final Set<EntityType> SYNCHRONIZE_ONLY_ENTITIES = Set.of(EntityType.ITEM, EntityType.FALLING_BLOCK, EntityType.ARROW, EntityType.SPECTRAL_ARROW, EntityType.TRIDENT, EntityType.LLAMA_SPIT, EntityType.WIND_CHARGE, EntityType.FISHING_BOBBER, EntityType.SNOWBALL, EntityType.EGG, EntityType.ENDER_PEARL, EntityType.POTION, EntityType.EYE_OF_ENDER, EntityType.DRAGON_FIREBALL, EntityType.FIREBALL, EntityType.SMALL_FIREBALL, EntityType.TNT);
    private final CachedPacket destroyPacketCache = new CachedPacket(() -> new DestroyEntitiesPacket(this.getEntityId()));
    protected Instance instance;
    protected Chunk currentChunk;
    protected Pos position;
    protected Pos previousPosition;
    protected Pos lastSyncedPosition;
    protected boolean onGround;
    protected BoundingBox boundingBox;
    private PhysicsResult previousPhysicsResult = null;
    protected Entity vehicle;
    protected Vec velocity = Vec.ZERO;
    protected boolean lastVelocityWasZero = true;
    protected boolean hasPhysics = true;
    protected boolean hasCollision = true;
    private Aerodynamics aerodynamics;
    protected int gravityTickCount;
    private final int id;
    private final EntityTracker.Target<Entity> trackingTarget = this instanceof Player ? EntityTracker.Target.ENTITIES : (EntityTracker.Target)EntityTracker.Target.class.cast(EntityTracker.Target.PLAYERS);
    protected final EntityTracker.Update<Entity> trackingUpdate = new EntityTracker.Update<Entity>(){

        @Override
        public void add(@NotNull Entity entity) {
            Entity.this.viewEngine.handleAutoViewAddition(entity);
        }

        @Override
        public void remove(@NotNull Entity entity) {
            Entity.this.viewEngine.handleAutoViewRemoval(entity);
        }

        @Override
        public void referenceUpdate(@NotNull Point point, @Nullable EntityTracker tracker) {
            Instance currentInstance;
            Instance instance = currentInstance = tracker != null ? Entity.this.instance : null;
            assert (currentInstance == null || currentInstance.getEntityTracker() == tracker) : "EntityTracker does not match current instance";
            Entity.this.viewEngine.updateTracker(currentInstance, point);
        }
    };
    protected final EntityView viewEngine = new EntityView(this);
    protected final Set<Player> viewers;
    private final TagHandler tagHandler;
    private final Scheduler scheduler;
    private final EventNode<EntityEvent> eventNode;
    private final Set<Permission> permissions;
    private final UUID uuid;
    private boolean isActive;
    protected boolean removed;
    private final Set<Entity> passengers;
    private final Set<Entity> leashedEntities;
    private Entity leashHolder;
    protected EntityType entityType;
    private long synchronizationTicks;
    private long nextSynchronizationTick;
    protected Metadata metadata;
    protected EntityMeta entityMeta;
    private final List<TimedPotion> effects;
    private long ticks;
    private final Acquirable<Entity> acquirable;

    public Entity(@NotNull EntityType entityType, @NotNull UUID uuid) {
        this.viewers = this.viewEngine.set;
        this.tagHandler = TagHandler.newHandler();
        this.scheduler = Scheduler.newScheduler();
        this.permissions = new CopyOnWriteArraySet<Permission>();
        this.passengers = new CopyOnWriteArraySet<Entity>();
        this.leashedEntities = new CopyOnWriteArraySet<Entity>();
        this.nextSynchronizationTick = this.synchronizationTicks = (long)ServerFlag.ENTITY_SYNCHRONIZATION_TICKS;
        this.metadata = new Metadata(this);
        this.effects = new CopyOnWriteArrayList<TimedPotion>();
        this.acquirable = Acquirable.of(this);
        this.id = Entity.generateId();
        this.entityType = entityType;
        this.uuid = uuid;
        this.position = Pos.ZERO;
        this.previousPosition = Pos.ZERO;
        this.lastSyncedPosition = Pos.ZERO;
        this.entityMeta = EntityTypeImpl.createMeta(entityType, this, this.metadata);
        this.setBoundingBox(entityType.registry().boundingBox());
        EntitySpawnType type = entityType.registry().spawnType();
        this.aerodynamics = new Aerodynamics(entityType.registry().acceleration(), type == EntitySpawnType.LIVING || type == EntitySpawnType.PLAYER ? 0.91 : 0.98, 1.0 - entityType.registry().drag());
        ServerProcess process = MinecraftServer.process();
        this.eventNode = process != null ? process.eventHandler().map(this, (EventFilter)EventFilter.ENTITY) : null;
    }

    public Entity(@NotNull EntityType entityType) {
        this(entityType, UUID.randomUUID());
    }

    public void scheduleNextTick(@NotNull Consumer<Entity> callback) {
        this.scheduler.scheduleNextTick(() -> callback.accept(this));
    }

    public static int generateId() {
        return LAST_ENTITY_ID.incrementAndGet();
    }

    public void update(long time) {
    }

    public void spawn() {
    }

    protected void despawn() {
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    @NotNull
    public EntityMeta getEntityMeta() {
        return this.entityMeta;
    }

    public <TMeta extends EntityMeta> void editEntityMeta(Class<TMeta> metaClass, Consumer<TMeta> editor) {
        this.entityMeta.setNotifyAboutChanges(false);
        try {
            EntityMeta casted = (EntityMeta)metaClass.cast(this.entityMeta);
            editor.accept(casted);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error editing entity " + this.id + " " + this.entityType.name() + " meta", t);
        }
        finally {
            this.entityMeta.setNotifyAboutChanges(true);
        }
    }

    @NotNull
    public CompletableFuture<Void> teleport(@NotNull Pos position, long @Nullable [] chunks, int flags, boolean shouldConfirm) {
        Check.stateCondition(this.instance == null, "You need to use Entity#setInstance before teleporting an entity!");
        Pos globalPosition = PositionUtils.getPositionWithRelativeFlags(this.position, position, flags);
        Runnable endCallback = () -> {
            this.previousPosition = this.position;
            this.position = globalPosition;
            this.refreshCoordinate(globalPosition);
            Entity patt0$temp = this;
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                player.synchronizePositionAfterTeleport(position, flags, shouldConfirm);
            } else {
                this.synchronizePosition();
            }
        };
        if (chunks != null && chunks.length > 0) {
            return ChunkUtils.optionalLoadAll(this.instance, chunks, null).thenRun(endCallback);
        }
        Pos currentPosition = this.position;
        if (!currentPosition.sameChunk(globalPosition)) {
            return this.instance.loadOptionalChunk(globalPosition).thenRun(endCallback);
        }
        endCallback.run();
        return AsyncUtils.empty();
    }

    @NotNull
    public CompletableFuture<Void> teleport(@NotNull Pos position, long @Nullable [] chunks, int flags) {
        return this.teleport(position, chunks, flags, true);
    }

    @NotNull
    public CompletableFuture<Void> teleport(@NotNull Pos position) {
        return this.teleport(position, null, 0);
    }

    public void setView(float yaw, float pitch) {
        Pos currentPosition = this.position;
        if (currentPosition.sameView(yaw, pitch)) {
            return;
        }
        this.position = currentPosition.withView(yaw, pitch);
        this.synchronizeView();
    }

    public void lookAt(@NotNull Point point) {
        Pos newPosition = this.position.add(0.0, this.getEyeHeight(), 0.0).withLookAt(point);
        this.setView(newPosition.yaw(), newPosition.pitch());
    }

    public void lookAt(@NotNull Entity entity) {
        Check.argCondition(entity.instance != this.instance, "Entity cannot look at an entity in another instance");
        this.lookAt(entity.position.withY(entity.position.y() + entity.getEyeHeight()));
    }

    public boolean isAutoViewable() {
        return this.viewEngine.viewableOption.isAuto();
    }

    public void setAutoViewable(boolean autoViewable) {
        this.viewEngine.viewableOption.updateAuto(autoViewable);
    }

    @ApiStatus.Experimental
    public void updateViewableRule(@Nullable Predicate<Player> predicate) {
        this.viewEngine.viewableOption.updateRule(predicate);
    }

    @ApiStatus.Experimental
    public void updateViewableRule() {
        this.viewEngine.viewableOption.updateRule();
    }

    @ApiStatus.Experimental
    public boolean autoViewEntities() {
        return this.viewEngine.viewerOption.isAuto();
    }

    @ApiStatus.Experimental
    public void setAutoViewEntities(boolean autoViewer) {
        this.viewEngine.viewerOption.updateAuto(autoViewer);
    }

    @ApiStatus.Experimental
    public void updateViewerRule(@Nullable Predicate<Entity> predicate) {
        this.viewEngine.viewerOption.updateRule(predicate);
    }

    @ApiStatus.Experimental
    public void updateViewerRule() {
        this.viewEngine.viewerOption.updateRule();
    }

    @Override
    public final boolean addViewer(@NotNull Player player) {
        Check.stateCondition(!this.isActive(), "Entities must be in an instance before adding viewers");
        if (!this.viewEngine.manualAdd(player)) {
            return false;
        }
        this.updateNewViewer(player);
        return true;
    }

    @Override
    public final boolean removeViewer(@NotNull Player player) {
        if (!this.viewEngine.manualRemove(player)) {
            return false;
        }
        this.updateOldViewer(player);
        return true;
    }

    @ApiStatus.Internal
    public void updateNewViewer(@NotNull Player player) {
        player.sendPacket(this.getEntityType().registry().spawnType().getSpawnPacket(this));
        if (this.hasVelocity()) {
            player.sendPacket(this.getVelocityPacket());
        }
        player.sendPacket(this.getMetadataPacket());
        Set<Entity> passengers = this.passengers;
        if (!passengers.isEmpty()) {
            for (Entity passenger : passengers) {
                if (passenger == player) continue;
                passenger.updateNewViewer(player);
            }
            player.sendPacket(this.getPassengersPacket());
        }
        if (this.leashHolder != null && (player.equals(this.leashHolder) || this.leashHolder.isViewer(player))) {
            player.sendPacket(this.getAttachEntityPacket());
        }
        for (Entity entity : this.leashedEntities) {
            if (!entity.isViewer(player)) continue;
            player.sendPacket(entity.getAttachEntityPacket());
        }
        player.sendPacket(new EntityHeadLookPacket(this.getEntityId(), this.position.yaw()));
    }

    @ApiStatus.Internal
    public void updateOldViewer(@NotNull Player player) {
        Set<Entity> passengers = this.passengers;
        if (!passengers.isEmpty()) {
            for (Entity passenger : passengers) {
                if (passenger == player) continue;
                passenger.updateOldViewer(player);
            }
        }
        this.leashedEntities.forEach(entity -> player.sendPacket(new AttachEntityPacket((Entity)entity, null)));
        player.sendPacket(this.destroyPacketCache);
    }

    @Override
    @NotNull
    public Set<Player> getViewers() {
        return this.viewers;
    }

    public boolean hasPredictableViewers() {
        return this.viewEngine.hasPredictableViewers();
    }

    public synchronized void switchEntityType(@NotNull EntityType entityType) {
        this.entityType = entityType;
        this.metadata = new Metadata(this);
        this.entityMeta = EntityTypeImpl.createMeta(entityType, this, this.metadata);
        EntitySpawnType type = entityType.registry().spawnType();
        this.aerodynamics = this.aerodynamics.withAirResistance(type == EntitySpawnType.LIVING || type == EntitySpawnType.PLAYER ? 0.91 : 0.98, 1.0 - entityType.registry().drag());
        HashSet<Player> viewers = new HashSet<Player>(this.getViewers());
        this.getViewers().forEach(this::updateOldViewer);
        viewers.forEach(this::updateNewViewer);
    }

    @Override
    @NotNull
    public Set<Permission> getAllPermissions() {
        return this.permissions;
    }

    @Override
    public void tick(long time) {
        if (this.instance == null || this.isRemoved() || !ChunkUtils.isLoaded(this.currentChunk)) {
            return;
        }
        this.scheduler.processTick();
        if (this.isRemoved()) {
            return;
        }
        this.movementTick();
        this.touchTick();
        this.update(time);
        ++this.ticks;
        EventDispatcher.call(new EntityTickEvent(this));
        this.effectTick();
        if (this.vehicle == null && this.ticks >= this.nextSynchronizationTick) {
            this.synchronizePosition();
            this.sendPacketToViewers(this.getVelocityPacket());
        }
        this.scheduler.processTickEnd();
    }

    @ApiStatus.Internal
    protected void movementTick() {
        PhysicsResult physicsResult;
        int n = this.gravityTickCount = this.onGround ? 0 : this.gravityTickCount + 1;
        if (this.vehicle != null) {
            return;
        }
        boolean entityIsPlayer = this instanceof Player;
        boolean entityFlying = entityIsPlayer && ((Player)this).isFlying();
        ChunkCache chunkCache = new ChunkCache(this.instance, this.currentChunk, Block.STONE);
        this.previousPhysicsResult = physicsResult = PhysicsUtils.simulateMovement(this.position, this.velocity.div(ServerFlag.SERVER_TICKS_PER_SECOND), this.boundingBox, this.instance.getWorldBorder(), chunkCache, this.aerodynamics, this.hasNoGravity(), this.hasPhysics, this.onGround, entityFlying, this.previousPhysicsResult);
        Chunk finalChunk = ChunkUtils.retrieve(this.instance, this.currentChunk, physicsResult.newPosition());
        if (!ChunkUtils.isLoaded(finalChunk)) {
            return;
        }
        this.velocity = physicsResult.newVelocity().mul(ServerFlag.SERVER_TICKS_PER_SECOND);
        if (!(this instanceof Player)) {
            this.onGround = physicsResult.isOnGround();
            this.refreshPosition(physicsResult.newPosition(), true, !SYNCHRONIZE_ONLY_ENTITIES.contains(this.entityType));
        }
    }

    private void touchTick() {
        if (!this.hasPhysics) {
            return;
        }
        Pos position = this.position;
        BoundingBox boundingBox = this.boundingBox;
        ChunkCache cache = new ChunkCache(this.instance, this.currentChunk);
        int minX = (int)Math.floor(boundingBox.minX() + position.x());
        int maxX = (int)Math.ceil(boundingBox.maxX() + position.x());
        int minY = (int)Math.floor(boundingBox.minY() + position.y());
        int maxY = (int)Math.ceil(boundingBox.maxY() + position.y());
        int minZ = (int)Math.floor(boundingBox.minZ() + position.z());
        int maxZ = (int)Math.ceil(boundingBox.maxZ() + position.z());
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockHandler handler;
                    Block block = cache.getBlock(x, y, z, Block.Getter.Condition.CACHED);
                    if (block == null || (handler = block.handler()) == null) continue;
                    Vec blockPos = new Vec(x, y, z);
                    Vec blockEntityVector = blockPos.sub(position).normalize().mul(0.01);
                    if (!block.registry().collisionShape().intersectBox(position.sub(blockPos).add(blockEntityVector), boundingBox)) continue;
                    handler.onTouch(new BlockHandler.Touch(block, this.instance, new Vec(x, y, z), this));
                }
            }
        }
    }

    private void effectTick() {
        List<TimedPotion> effects = this.effects;
        if (effects.isEmpty()) {
            return;
        }
        effects.removeIf(timedPotion -> {
            long duration = timedPotion.potion().duration();
            if (duration == -1L) {
                return false;
            }
            if (this.getAliveTicks() >= timedPotion.startingTicks() + duration) {
                timedPotion.potion().sendRemovePacket(this);
                EventDispatcher.call(new EntityPotionRemoveEvent(this, timedPotion.potion()));
                return true;
            }
            return false;
        });
    }

    public long getAliveTicks() {
        return this.ticks;
    }

    public int getEntityId() {
        return this.id;
    }

    @NotNull
    public EntityType getEntityType() {
        return this.entityType;
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    public boolean isActive() {
        return this.isActive;
    }

    @NotNull
    public BoundingBox getBoundingBox() {
        BoundingBox poseBoundingBox = BoundingBox.fromPose(this.getPose());
        return poseBoundingBox == null ? this.boundingBox : poseBoundingBox;
    }

    public void setBoundingBox(double width, double height, double depth) {
        this.setBoundingBox(new BoundingBox(width, height, depth));
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    @Nullable
    public Chunk getChunk() {
        return this.currentChunk;
    }

    @ApiStatus.Internal
    protected void refreshCurrentChunk(Chunk currentChunk) {
        this.currentChunk = currentChunk;
        MinecraftServer.process().dispatcher().updateElement(this, currentChunk);
    }

    public @UnknownNullability Instance getInstance() {
        return this.instance;
    }

    public CompletableFuture<Void> setInstance(@NotNull Instance instance, @NotNull Pos spawnPosition) {
        Check.stateCondition(!instance.isRegistered(), "Instances need to be registered, please use InstanceManager#registerInstance or InstanceManager#registerSharedInstance");
        Instance previousInstance = this.instance;
        if (Objects.equals(previousInstance, instance)) {
            return this.teleport(spawnPosition);
        }
        AddEntityToInstanceEvent event = new AddEntityToInstanceEvent(instance, this);
        EventDispatcher.call(event);
        if (event.isCancelled()) {
            return null;
        }
        if (previousInstance != null) {
            this.removeFromInstance(previousInstance);
        }
        this.isActive = true;
        this.position = spawnPosition;
        this.previousPosition = spawnPosition;
        this.previousPhysicsResult = null;
        this.instance = instance;
        return instance.loadOptionalChunk(spawnPosition).thenAccept(chunk -> {
            try {
                Check.notNull(chunk, "Entity has been placed in an unloaded chunk!");
                this.refreshCurrentChunk((Chunk)chunk);
                Entity patt0$temp = this;
                if (patt0$temp instanceof Player) {
                    Player player = (Player)patt0$temp;
                    player.sendPacket(instance.createInitializeWorldBorderPacket());
                    player.sendPacket(instance.createTimePacket());
                    player.sendPackets(instance.getWeather().createWeatherPackets());
                }
                instance.getEntityTracker().register(this, spawnPosition, this.trackingTarget, this.trackingUpdate);
                this.spawn();
                EventDispatcher.call(new EntitySpawnEvent(this, instance));
            }
            catch (Exception e) {
                MinecraftServer.getExceptionManager().handleException(e);
            }
        });
    }

    public CompletableFuture<Void> setInstance(@NotNull Instance instance, @NotNull Point spawnPosition) {
        return this.setInstance(instance, Pos.fromPoint(spawnPosition));
    }

    public CompletableFuture<Void> setInstance(@NotNull Instance instance) {
        return this.setInstance(instance, this.position);
    }

    private void removeFromInstance(Instance instance) {
        EventDispatcher.call(new RemoveEntityFromInstanceEvent(instance, this));
        instance.getEntityTracker().unregister(this, this.trackingTarget, this.trackingUpdate);
        this.viewEngine.forManuals(this::removeViewer);
    }

    @NotNull
    public Vec getVelocity() {
        return this.velocity;
    }

    public void setVelocity(@NotNull Vec velocity) {
        EntityVelocityEvent entityVelocityEvent = new EntityVelocityEvent(this, velocity);
        EventDispatcher.callCancellable(entityVelocityEvent, () -> {
            this.velocity = entityVelocityEvent.getVelocity();
            this.sendPacketToViewersAndSelf(this.getVelocityPacket());
        });
    }

    public boolean hasVelocity() {
        if (this.isOnGround()) {
            return Double.compare(this.velocity.x(), 0.0) != 0 || Double.compare(this.velocity.z(), 0.0) != 0 || this.velocity.y() > 0.0;
        }
        return !this.velocity.isZero();
    }

    @NotNull
    public Aerodynamics getAerodynamics() {
        return this.aerodynamics;
    }

    public void setAerodynamics(@NotNull Aerodynamics aerodynamics) {
        this.aerodynamics = aerodynamics;
    }

    public int getGravityTickCount() {
        return this.gravityTickCount;
    }

    public double getDistance(@NotNull Point point) {
        return this.getPosition().distance(point);
    }

    public double getDistance(@NotNull Entity entity) {
        return this.getDistance(entity.getPosition());
    }

    public double getDistanceSquared(@NotNull Point point) {
        return this.getPosition().distanceSquared(point);
    }

    public double getDistanceSquared(@NotNull Entity entity) {
        return this.getPosition().distanceSquared(entity.getPosition());
    }

    @Nullable
    public Entity getVehicle() {
        return this.vehicle;
    }

    public void addPassenger(@NotNull Entity entity) {
        Instance currentInstance = this.instance;
        Check.stateCondition(currentInstance == null, "You need to set an instance using Entity#setInstance");
        Check.stateCondition(entity == this.getVehicle(), "Cannot add the entity vehicle as a passenger");
        Entity vehicle = entity.getVehicle();
        if (vehicle != null) {
            vehicle.removePassenger(entity);
        }
        if (!currentInstance.equals(entity.getInstance())) {
            entity.setInstance(currentInstance, this.position).join();
        }
        this.passengers.add(entity);
        entity.vehicle = this;
        this.sendPacketToViewersAndSelf(this.getPassengersPacket());
        this.updatePassengerPosition(this.position, entity);
        entity.synchronizePosition();
    }

    public void removePassenger(@NotNull Entity entity) {
        Check.stateCondition(this.instance == null, "You need to set an instance using Entity#setInstance");
        if (!this.passengers.remove(entity)) {
            return;
        }
        entity.vehicle = null;
        this.sendPacketToViewersAndSelf(this.getPassengersPacket());
        entity.synchronizePosition();
    }

    public boolean hasPassenger() {
        return !this.passengers.isEmpty();
    }

    @NotNull
    public @NotNull Set<@NotNull Entity> getPassengers() {
        return Collections.unmodifiableSet(this.passengers);
    }

    @NotNull
    protected SetPassengersPacket getPassengersPacket() {
        return new SetPassengersPacket(this.getEntityId(), this.passengers.stream().map(Entity::getEntityId).toList());
    }

    @NotNull
    public Set<Entity> getLeashedEntities() {
        return Collections.unmodifiableSet(this.leashedEntities);
    }

    @Nullable
    public Entity getLeashHolder() {
        return this.leashHolder;
    }

    public void setLeashHolder(@Nullable Entity entity) {
        if (this.leashHolder != null) {
            this.leashHolder.leashedEntities.remove(this);
        }
        if (entity != null) {
            entity.leashedEntities.add(this);
        }
        this.leashHolder = entity;
        this.sendPacketToViewersAndSelf(this.getAttachEntityPacket());
    }

    @NotNull
    protected AttachEntityPacket getAttachEntityPacket() {
        return new AttachEntityPacket(this, this.leashHolder);
    }

    public void triggerStatus(byte status) {
        this.sendPacketToViewersAndSelf(new EntityStatusPacket(this.getEntityId(), status));
    }

    public boolean isOnFire() {
        return this.entityMeta.isOnFire();
    }

    public boolean isSneaking() {
        return this.entityMeta.isSneaking();
    }

    public void setSneaking(boolean sneaking) {
        this.entityMeta.setSneaking(sneaking);
        this.updatePose();
    }

    public boolean isSprinting() {
        return this.entityMeta.isSprinting();
    }

    public void setSprinting(boolean sprinting) {
        this.entityMeta.setSprinting(sprinting);
    }

    public boolean isInvisible() {
        return this.entityMeta.isInvisible();
    }

    public void setInvisible(boolean invisible) {
        this.entityMeta.setInvisible(invisible);
    }

    public boolean isGlowing() {
        return this.entityMeta.isHasGlowingEffect();
    }

    public void setGlowing(boolean glowing) {
        this.entityMeta.setHasGlowingEffect(glowing);
    }

    @NotNull
    public Pose getPose() {
        return this.entityMeta.getPose();
    }

    public void setPose(@NotNull Pose pose) {
        this.entityMeta.setPose(pose);
    }

    protected void updatePose() {
        if (this.entityMeta.isFlyingWithElytra()) {
            this.setPose(Pose.FALL_FLYING);
        } else if (this.entityMeta.isSwimming()) {
            this.setPose(Pose.SWIMMING);
        } else {
            LivingEntityMeta livingMeta;
            EntityMeta entityMeta = this.entityMeta;
            if (entityMeta instanceof LivingEntityMeta && (livingMeta = (LivingEntityMeta)entityMeta).isInRiptideSpinAttack()) {
                this.setPose(Pose.SPIN_ATTACK);
            } else if (this.entityMeta.isSneaking()) {
                this.setPose(Pose.SNEAKING);
            } else {
                this.setPose(Pose.STANDING);
            }
        }
    }

    @Nullable
    public Component getCustomName() {
        return this.entityMeta.getCustomName();
    }

    public void setCustomName(@Nullable Component customName) {
        this.entityMeta.setCustomName(customName);
    }

    public boolean isCustomNameVisible() {
        return this.entityMeta.isCustomNameVisible();
    }

    public void setCustomNameVisible(boolean customNameVisible) {
        this.entityMeta.setCustomNameVisible(customNameVisible);
    }

    public boolean isSilent() {
        return this.entityMeta.isSilent();
    }

    public void setSilent(boolean silent) {
        this.entityMeta.setSilent(silent);
    }

    public boolean hasNoGravity() {
        return this.entityMeta.isHasNoGravity();
    }

    public void setNoGravity(boolean noGravity) {
        this.entityMeta.setHasNoGravity(noGravity);
    }

    @ApiStatus.Internal
    public void refreshPosition(@NotNull Pos newPosition, boolean ignoreView, boolean sendPackets) {
        Pos position;
        Pos previousPosition = this.position;
        Pos pos = position = ignoreView ? previousPosition.withCoord(newPosition) : newPosition;
        if (position.equals(this.lastSyncedPosition)) {
            return;
        }
        this.position = position;
        this.previousPosition = previousPosition;
        if (!position.samePoint(previousPosition)) {
            this.refreshCoordinate(position);
        }
        if (this.nextSynchronizationTick <= this.ticks + 1L || !sendPackets) {
            return;
        }
        boolean viewChange = !position.sameView(this.lastSyncedPosition);
        double distanceX = Math.abs(position.x() - this.lastSyncedPosition.x());
        double distanceY = Math.abs(position.y() - this.lastSyncedPosition.y());
        double distanceZ = Math.abs(position.z() - this.lastSyncedPosition.z());
        boolean positionChange = distanceX + distanceY + distanceZ > 0.0;
        Chunk chunk = this.getChunk();
        assert (chunk != null);
        if (distanceX > 8.0 || distanceY > 8.0 || distanceZ > 8.0) {
            PacketUtils.prepareViewablePacket(chunk, new EntityTeleportPacket(this.getEntityId(), position, this.isOnGround()), this);
            this.nextSynchronizationTick = this.synchronizationTicks + 1L;
        } else if (positionChange && viewChange) {
            PacketUtils.prepareViewablePacket(chunk, EntityPositionAndRotationPacket.getPacket(this.getEntityId(), position, this.lastSyncedPosition, this.isOnGround()), this);
            PacketUtils.prepareViewablePacket(chunk, new EntityHeadLookPacket(this.getEntityId(), position.yaw()), this);
        } else if (positionChange) {
            PacketUtils.prepareViewablePacket(chunk, EntityPositionAndRotationPacket.getPacket(this.getEntityId(), position, this.lastSyncedPosition, this.onGround), this);
        } else if (viewChange) {
            PacketUtils.prepareViewablePacket(chunk, new EntityHeadLookPacket(this.getEntityId(), position.yaw()), this);
            PacketUtils.prepareViewablePacket(chunk, EntityPositionAndRotationPacket.getPacket(this.getEntityId(), position, this.lastSyncedPosition, this.isOnGround()), this);
        }
        this.lastSyncedPosition = position;
    }

    @ApiStatus.Internal
    public void refreshPosition(@NotNull Pos newPosition, boolean ignoreView) {
        this.refreshPosition(newPosition, ignoreView, true);
    }

    @ApiStatus.Internal
    public void refreshPosition(@NotNull Pos newPosition) {
        this.refreshPosition(newPosition, false);
    }

    private void updatePassengerPosition(Point newPosition, Entity passenger) {
        Pos newPassengerPos;
        Pos oldPassengerPos = passenger.position;
        passenger.position = newPassengerPos = oldPassengerPos.withCoord(newPosition.x(), newPosition.y() + EntityUtils.getPassengerHeightOffset(this, passenger), newPosition.z());
        passenger.previousPosition = oldPassengerPos;
        passenger.refreshCoordinate(newPassengerPos);
    }

    @ApiStatus.Internal
    protected void refreshCoordinate(Point newPosition) {
        Set<Entity> passengers = this.getPassengers();
        if (!passengers.isEmpty()) {
            for (Entity passenger : passengers) {
                this.updatePassengerPosition(newPosition, passenger);
            }
        }
        Instance instance = this.getInstance();
        assert (instance != null);
        instance.getEntityTracker().move(this, newPosition, this.trackingTarget, this.trackingUpdate);
        int lastChunkX = this.currentChunk.getChunkX();
        int lastChunkZ = this.currentChunk.getChunkZ();
        int newChunkX = newPosition.chunkX();
        int newChunkZ = newPosition.chunkZ();
        if (lastChunkX != newChunkX || lastChunkZ != newChunkZ) {
            Chunk newChunk = instance.getChunk(newChunkX, newChunkZ);
            Check.notNull(newChunk, "The entity {0} tried to move in an unloaded chunk at {1}", this.getEntityId(), newPosition);
            Entity entity = this;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.sendChunkUpdates(newChunk);
            }
            this.refreshCurrentChunk(newChunk);
        }
    }

    @NotNull
    public Pos getPosition() {
        return this.position;
    }

    @NotNull
    public Pos getPreviousPosition() {
        return this.previousPosition;
    }

    public double getEyeHeight() {
        return this.getPose() == Pose.SLEEPING ? 0.2 : this.entityType.registry().eyeHeight();
    }

    @NotNull
    public @NotNull List<@NotNull TimedPotion> getActiveEffects() {
        return Collections.unmodifiableList(this.effects);
    }

    public void addEffect(@NotNull Potion potion) {
        this.removeEffect(potion.effect());
        this.effects.add(new TimedPotion(potion, this.getAliveTicks()));
        potion.sendAddPacket(this);
        EventDispatcher.call(new EntityPotionAddEvent(this, potion));
    }

    public void removeEffect(@NotNull PotionEffect effect) {
        this.effects.removeIf(timedPotion -> {
            if (timedPotion.potion().effect() == effect) {
                timedPotion.potion().sendRemovePacket(this);
                EventDispatcher.call(new EntityPotionRemoveEvent(this, timedPotion.potion()));
                return true;
            }
            return false;
        });
    }

    public boolean hasEffect(@NotNull PotionEffect effect) {
        return this.effects.stream().anyMatch(timedPotion -> timedPotion.potion().effect() == effect);
    }

    @Nullable
    public TimedPotion getEffect(@NotNull PotionEffect effect) {
        return this.effects.stream().filter(timedPotion -> timedPotion.potion().effect() == effect).findFirst().orElse(null);
    }

    public int getEffectLevel(@NotNull PotionEffect effect) {
        TimedPotion timedPotion = this.getEffect(effect);
        return timedPotion == null ? -1 : (int)timedPotion.potion().amplifier();
    }

    public void clearEffects() {
        for (TimedPotion timedPotion : this.effects) {
            timedPotion.potion().sendRemovePacket(this);
            EventDispatcher.call(new EntityPotionRemoveEvent(this, timedPotion.potion()));
        }
        this.effects.clear();
    }

    public void remove() {
        this.remove(true);
    }

    protected void remove(boolean permanent) {
        Instance currentInstance;
        Entity vehicle;
        if (this.isRemoved()) {
            return;
        }
        EventDispatcher.call(new EntityDespawnEvent(this));
        try {
            this.despawn();
        }
        catch (Throwable t) {
            MinecraftServer.getExceptionManager().handleException(t);
        }
        Set<Entity> passengers = this.getPassengers();
        if (!passengers.isEmpty()) {
            passengers.forEach(this::removePassenger);
        }
        if ((vehicle = this.vehicle) != null) {
            vehicle.removePassenger(this);
        }
        Set<Entity> leashedEntities = this.getLeashedEntities();
        leashedEntities.forEach(entity -> entity.setLeashHolder(null));
        MinecraftServer.process().dispatcher().removeElement(this);
        this.removed = true;
        if (!permanent) {
            this.position = Pos.ZERO;
            this.previousPosition = Pos.ZERO;
            this.lastSyncedPosition = Pos.ZERO;
        }
        if ((currentInstance = this.instance) != null) {
            this.removeFromInstance(currentInstance);
            this.instance = null;
        }
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void scheduleRemove(long delay, @NotNull TemporalUnit temporalUnit) {
        if (temporalUnit == TimeUnit.SERVER_TICK) {
            this.scheduleRemove(TaskSchedule.tick((int)delay));
        } else {
            this.scheduleRemove(Duration.of(delay, temporalUnit));
        }
    }

    public void scheduleRemove(Duration delay) {
        this.scheduleRemove(TaskSchedule.duration(delay));
    }

    private void scheduleRemove(TaskSchedule schedule) {
        this.scheduler.buildTask(this::remove).delay(schedule).schedule();
    }

    @NotNull
    protected Vec getVelocityForPacket() {
        return this.velocity.mul(8000.0f / (float)ServerFlag.SERVER_TICKS_PER_SECOND);
    }

    @NotNull
    protected EntityVelocityPacket getVelocityPacket() {
        return new EntityVelocityPacket(this.getEntityId(), this.getVelocityForPacket());
    }

    @NotNull
    public EntityMetaDataPacket getMetadataPacket() {
        return new EntityMetaDataPacket(this.getEntityId(), this.metadata.getEntries());
    }

    @ApiStatus.Internal
    protected void synchronizePosition() {
        Pos posCache = this.position;
        PacketUtils.prepareViewablePacket(this.currentChunk, new EntityTeleportPacket(this.getEntityId(), posCache, this.isOnGround()), this);
        if (posCache.yaw() != this.lastSyncedPosition.yaw()) {
            PacketUtils.prepareViewablePacket(this.currentChunk, new EntityHeadLookPacket(this.getEntityId(), this.position.yaw()), this);
        }
        this.nextSynchronizationTick = this.ticks + this.synchronizationTicks;
        this.lastSyncedPosition = posCache;
    }

    private void synchronizeView() {
        this.sendPacketToViewers(new EntityHeadLookPacket(this.getEntityId(), this.position.yaw()));
        this.sendPacketToViewers(new EntityRotationPacket(this.getEntityId(), this.position.yaw(), this.position.pitch(), this.onGround));
    }

    public void synchronizeNextTick() {
        this.nextSynchronizationTick = 0L;
    }

    public long getSynchronizationTicks() {
        return this.synchronizationTicks;
    }

    public void setSynchronizationTicks(long ticks) {
        this.synchronizationTicks = ticks;
    }

    @NotNull
    public HoverEvent<HoverEvent.ShowEntity> asHoverEvent(@NotNull UnaryOperator<HoverEvent.ShowEntity> op) {
        return HoverEvent.showEntity((HoverEvent.ShowEntity)HoverEvent.ShowEntity.showEntity((Keyed)this.entityType, (UUID)this.uuid));
    }

    @Override
    @NotNull
    public TagHandler tagHandler() {
        return this.tagHandler;
    }

    @Override
    @NotNull
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    @NotNull
    public EntitySnapshot updateSnapshot(@NotNull SnapshotUpdater updater) {
        Chunk chunk = this.currentChunk;
        int[] viewersId = this.viewEngine.viewableOption.bitSet.toIntArray();
        int[] passengersId = ArrayUtils.mapToIntArray(this.passengers, Entity::getEntityId);
        Entity vehicle = this.vehicle;
        return new SnapshotImpl.Entity(this.entityType, this.uuid, this.id, this.position, this.velocity, updater.reference(this.instance), chunk.getChunkX(), chunk.getChunkZ(), viewersId, passengersId, vehicle == null ? -1 : vehicle.getEntityId(), this.tagHandler.readableCopy());
    }

    @Override
    @ApiStatus.Experimental
    @NotNull
    public EventNode<EntityEvent> eventNode() {
        return this.eventNode;
    }

    public void takeKnockback(float strength, double x, double z) {
        if (strength > 0.0f) {
            Vec velocityModifier = new Vec(x, z).normalize().mul(strength *= (float)ServerFlag.SERVER_TICKS_PER_SECOND);
            double verticalLimit = 0.4 * (double)ServerFlag.SERVER_TICKS_PER_SECOND;
            this.setVelocity(new Vec(this.velocity.x() / 2.0 - velocityModifier.x(), this.onGround ? Math.min(verticalLimit, this.velocity.y() / 2.0 + (double)strength) : this.velocity.y(), this.velocity.z() / 2.0 - velocityModifier.z()));
        }
    }

    public List<Point> getLineOfSight(int maxDistance) {
        Instance instance = this.getInstance();
        if (instance == null) {
            return List.of();
        }
        ArrayList<Point> blocks = new ArrayList<Point>();
        BlockIterator it = new BlockIterator(this, maxDistance);
        while (it.hasNext()) {
            Point position = it.next();
            if (instance.getBlock(position).isAir()) continue;
            blocks.add(position);
        }
        return blocks;
    }

    public boolean hasLineOfSight(Entity entity, boolean exactView) {
        Vec direction;
        Instance instance = this.getInstance();
        if (instance == null) {
            return false;
        }
        Pos start = this.position.withY(this.position.y() + this.getEyeHeight());
        Pos end = entity.position.withY(entity.position.y() + entity.getEyeHeight());
        Vec vec = direction = exactView ? this.position.direction() : end.sub(start).asVec().normalize();
        if (!entity.boundingBox.boundingBoxRayIntersectionCheck(start.asVec(), direction, entity.getPosition())) {
            return false;
        }
        return CollisionUtils.isLineOfSightReachingShape(instance, this.currentChunk, start, end, entity.boundingBox);
    }

    public boolean hasLineOfSight(Entity entity) {
        return this.hasLineOfSight(entity, false);
    }

    @Nullable
    public Entity getLineOfSightEntity(double range, Predicate<Entity> predicate) {
        Instance instance = this.getInstance();
        if (instance == null) {
            return null;
        }
        Pos start = this.position.withY(this.position.y() + this.getEyeHeight());
        Vec startAsVec = start.asVec();
        Predicate<Entity> finalPredicate = e -> e != this && e.boundingBox.boundingBoxRayIntersectionCheck(startAsVec, this.position.direction(), e.getPosition()) && predicate.test((Entity)e) && CollisionUtils.isLineOfSightReachingShape(instance, this.currentChunk, start, e.position.withY(e.position.y() + e.getEyeHeight()), e.boundingBox);
        Optional<Entity> nearby = instance.getNearbyEntities(this.position, range).stream().filter(finalPredicate).min(Comparator.comparingDouble(e -> e.getDistanceSquared(this)));
        return nearby.orElse(null);
    }

    @Override
    public boolean isOccluded(@NotNull Shape shape, @NotNull BlockFace face) {
        return false;
    }

    @Override
    public boolean intersectBox(@NotNull Point positionRelative, @NotNull BoundingBox boundingBox) {
        return boundingBox.intersectBox(positionRelative, boundingBox);
    }

    @Override
    public boolean intersectBoxSwept(@NotNull Point rayStart, @NotNull Point rayDirection, @NotNull Point shapePos, @NotNull BoundingBox moving, @NotNull SweepResult finalResult) {
        return this.boundingBox.intersectBoxSwept(rayStart, rayDirection, shapePos, moving, finalResult);
    }

    @Override
    @NotNull
    public Point relativeStart() {
        return this.boundingBox.relativeStart();
    }

    @Override
    @NotNull
    public Point relativeEnd() {
        return this.boundingBox.relativeEnd();
    }

    public boolean hasCollision() {
        return this.hasCollision;
    }

    @Deprecated
    @ApiStatus.Experimental
    @NotNull
    public <T extends Entity> Acquirable<T> getAcquirable() {
        return this.acquirable;
    }

    @Override
    @ApiStatus.Experimental
    @NotNull
    public Acquirable<? extends Entity> acquirable() {
        return this.acquirable;
    }

    public static enum Pose {
        STANDING,
        FALL_FLYING,
        SLEEPING,
        SWIMMING,
        SPIN_ATTACK,
        SNEAKING,
        LONG_JUMPING,
        DYING,
        CROAKING,
        USING_TONGUE,
        SITTING,
        ROARING,
        SNIFFING,
        EMERGING,
        DIGGING,
        SLIDING,
        SHOOTING,
        INHALING;

    }
}

