/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum RecipeProperty implements Keyed
{
    SMITHING_BASE("smithing_base"),
    SMITHING_TEMPLATE("smithing_template"),
    SMITHING_ADDITION("smithing_addition"),
    FURNACE_INPUT("furnace_input"),
    BLAST_FURNACE_INPUT("blast_furnace_input"),
    SMOKER_INPUT("smoker_input"),
    CAMPFIRE_INPUT("campfire_input");

    private static final Map<NamespaceID, RecipeProperty> BY_NAMESPACE;
    public static final NetworkBuffer.Type<RecipeProperty> NETWORK_TYPE;
    private final NamespaceID namespace;

    @Nullable
    public static RecipeProperty fromNamespaceId(@NotNull String namespaceId) {
        return RecipeProperty.fromNamespaceId(NamespaceID.from(namespaceId));
    }

    @Nullable
    public static RecipeProperty fromNamespaceId(@NotNull NamespaceID namespaceId) {
        return BY_NAMESPACE.get(namespaceId);
    }

    private RecipeProperty(String id) {
        this.namespace = NamespaceID.from("minecraft", id);
    }

    @NotNull
    public NamespaceID namespace() {
        return this.namespace;
    }

    @NotNull
    public Key key() {
        return this.namespace;
    }

    static {
        BY_NAMESPACE = Arrays.stream(RecipeProperty.values()).collect(Collectors.toMap(RecipeProperty::namespace, Function.identity()));
        NETWORK_TYPE = NetworkBuffer.STRING.transform(namespaceId -> Objects.requireNonNull(RecipeProperty.fromNamespaceId(namespaceId)), recipeProperty -> recipeProperty.namespace().asMinimalString());
    }
}

