/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.particle;

import java.util.Collection;
import java.util.Objects;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.util.RGBLike;
import net.minestom.server.color.AlphaColor;
import net.minestom.server.color.Color;
import net.minestom.server.coordinate.Point;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.particle.ParticleImpl;
import net.minestom.server.particle.Particles;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.block.BlockUtils;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Particle
extends StaticProtocolObject,
Particles {
    @NotNull
    public static final NetworkBuffer.Type<Particle> NETWORK_TYPE = new NetworkBuffer.Type<Particle>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, Particle value) {
            buffer.write(NetworkBuffer.VAR_INT, value.id());
            value.writeData(buffer);
        }

        @Override
        public Particle read(@NotNull NetworkBuffer buffer) {
            int id = buffer.read(NetworkBuffer.VAR_INT);
            Particle particle = Objects.requireNonNull(Particle.fromId(id), () -> "unknown particle id: " + id);
            return particle.readData(buffer);
        }
    };

    @NotNull
    public static @NotNull Collection<@NotNull Particle> values() {
        return ParticleImpl.values();
    }

    @Nullable
    public static Particle fromNamespaceId(@NotNull String namespaceID) {
        return ParticleImpl.getSafe(namespaceID);
    }

    @Nullable
    public static Particle fromNamespaceId(@NotNull NamespaceID namespaceID) {
        return Particle.fromNamespaceId(namespaceID.asString());
    }

    @Nullable
    public static Particle fromId(int id) {
        return ParticleImpl.getId(id);
    }

    @NotNull
    public Particle readData(@NotNull NetworkBuffer var1);

    public void writeData(@NotNull NetworkBuffer var1);

    @NotNull
    public CompoundBinaryTag toNbt();

    public record BlockCrumble(@NotNull NamespaceID namespace, int id, @NotNull net.minestom.server.instance.block.Block block) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public Block withBlock(@NotNull net.minestom.server.instance.block.Block block) {
            return new Block(this.namespace(), this.id(), block);
        }

        @Override
        @NotNull
        public Block readData(@NotNull NetworkBuffer reader) {
            short blockState = reader.read(NetworkBuffer.VAR_INT).shortValue();
            net.minestom.server.instance.block.Block block = net.minestom.server.instance.block.Block.fromStateId(blockState);
            Check.stateCondition(block == null, "Block state " + blockState + " is invalid");
            return this.withBlock(block);
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.block.stateId());
        }

        @Override
        @NotNull
        public CompoundBinaryTag toNbt() {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("type", this.namespace.asString())).putString("block_state", BlockUtils.toString(this.block))).build();
        }
    }

    public record Trail(@NotNull NamespaceID namespace, int id, @NotNull Point target, @NotNull RGBLike color) implements Particle
    {
        @NotNull
        public Trail withProperties(@NotNull Point target, @NotNull RGBLike color) {
            return new Trail(this.namespace(), this.id(), target, color);
        }

        @NotNull
        public Trail withTarget(@NotNull Point target) {
            return new Trail(this.namespace(), this.id(), target, this.color);
        }

        @NotNull
        public Trail withColor(@NotNull RGBLike color) {
            return new Trail(this.namespace(), this.id(), this.target, color);
        }

        @Override
        @NotNull
        public Trail readData(@NotNull NetworkBuffer reader) {
            return this.withProperties(reader.read(NetworkBuffer.VECTOR3D), reader.read(Color.NETWORK_TYPE));
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VECTOR3D, this.target);
            writer.write(Color.NETWORK_TYPE, this.color);
        }

        @Override
        @NotNull
        public CompoundBinaryTag toNbt() {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("type", this.namespace.asString())).put("target", BinaryTagSerializer.VECTOR3D.write(this.target))).put("color", Color.NBT_TYPE.write(this.color))).build();
        }
    }

    public record Vibration(@NotNull NamespaceID namespace, int id, @NotNull SourceType sourceType, @Nullable Point sourceBlockPosition, int sourceEntityId, float sourceEntityEyeHeight, int travelTicks) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public Vibration withProperties(@NotNull SourceType sourceType, @Nullable Point sourceBlockPosition, int sourceEntityId, float sourceEntityEyeHeight, int travelTicks) {
            return new Vibration(this.namespace(), this.id(), sourceType, sourceBlockPosition, sourceEntityId, sourceEntityEyeHeight, travelTicks);
        }

        @Contract(pure=true)
        @NotNull
        public Vibration withSourceBlockPosition(@Nullable Point sourceBlockPosition, int travelTicks) {
            return new Vibration(this.namespace(), this.id(), SourceType.BLOCK, sourceBlockPosition, this.sourceEntityId, this.sourceEntityEyeHeight, travelTicks);
        }

        @Contract(pure=true)
        @NotNull
        public Vibration withSourceEntity(int sourceEntityId, float sourceEntityEyeHeight, int travelTicks) {
            return new Vibration(this.namespace(), this.id(), SourceType.ENTITY, this.sourceBlockPosition, sourceEntityId, sourceEntityEyeHeight, travelTicks);
        }

        @Override
        @NotNull
        public Vibration readData(@NotNull NetworkBuffer reader) {
            SourceType type = reader.read(NetworkBuffer.Enum(SourceType.class));
            if (type == SourceType.BLOCK) {
                return this.withSourceBlockPosition(reader.read(NetworkBuffer.BLOCK_POSITION), reader.read(NetworkBuffer.VAR_INT));
            }
            return this.withSourceEntity(reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.Enum(SourceType.class), this.sourceType);
            if (this.sourceType == SourceType.BLOCK) {
                Objects.requireNonNull(this.sourceBlockPosition);
                writer.write(NetworkBuffer.BLOCK_POSITION, this.sourceBlockPosition);
                writer.write(NetworkBuffer.VAR_INT, this.travelTicks);
            } else {
                writer.write(NetworkBuffer.VAR_INT, this.sourceEntityId);
                writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.sourceEntityEyeHeight));
                writer.write(NetworkBuffer.VAR_INT, this.travelTicks);
            }
        }

        @Override
        @NotNull
        public CompoundBinaryTag toNbt() {
            throw new UnsupportedOperationException("Vibration particle cannot be serialized to NBT");
        }

        public static enum SourceType {
            BLOCK,
            ENTITY;

        }
    }

    public record Shriek(@NotNull NamespaceID namespace, int id, int delay) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public Shriek withDelay(int delay) {
            return new Shriek(this.namespace(), this.id(), delay);
        }

        @Override
        @NotNull
        public Shriek readData(@NotNull NetworkBuffer reader) {
            return this.withDelay(reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.delay);
        }

        @Override
        @NotNull
        public CompoundBinaryTag toNbt() {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("type", this.namespace.asString())).putInt("delay", this.delay)).build();
        }
    }

    public record SculkCharge(@NotNull NamespaceID namespace, int id, float roll) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public SculkCharge withRoll(float roll) {
            return new SculkCharge(this.namespace(), this.id(), roll);
        }

        @Override
        @NotNull
        public SculkCharge readData(@NotNull NetworkBuffer reader) {
            return this.withRoll(reader.read(NetworkBuffer.FLOAT).floatValue());
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.roll));
        }

        @Override
        @NotNull
        public CompoundBinaryTag toNbt() {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("type", this.namespace.asString())).putFloat("roll", this.roll)).build();
        }
    }

    public record EntityEffect(@NotNull NamespaceID namespace, int id, @NotNull AlphaColor color) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public EntityEffect withColor(@NotNull AlphaColor color) {
            return new EntityEffect(this.namespace(), this.id(), color);
        }

        @Contract(pure=true)
        @NotNull
        public EntityEffect withColor(@NotNull RGBLike color) {
            return new EntityEffect(this.namespace(), this.id(), new AlphaColor(1, color));
        }

        @Contract(pure=true)
        @NotNull
        public EntityEffect withColor(int alpha, @NotNull RGBLike color) {
            return new EntityEffect(this.namespace(), this.id(), new AlphaColor(alpha, color));
        }

        @Override
        @NotNull
        public EntityEffect readData(@NotNull NetworkBuffer reader) {
            return this.withColor(reader.read(AlphaColor.NETWORK_TYPE));
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(AlphaColor.NETWORK_TYPE, this.color);
        }

        @Override
        @NotNull
        public CompoundBinaryTag toNbt() {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("type", this.namespace.asString())).put("color", AlphaColor.NBT_TYPE.write(this.color))).build();
        }
    }

    public record Item(@NotNull NamespaceID namespace, int id, @NotNull ItemStack item) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public Item withItem(@NotNull ItemStack item) {
            return new Item(this.namespace(), this.id(), item);
        }

        @Override
        @NotNull
        public Item readData(@NotNull NetworkBuffer reader) {
            return this.withItem(reader.read(ItemStack.NETWORK_TYPE));
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(ItemStack.NETWORK_TYPE, this.item);
        }

        @Override
        @NotNull
        public CompoundBinaryTag toNbt() {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("type", this.namespace.asString())).put("item", (BinaryTag)this.item.toItemNBT())).build();
        }
    }

    public record FallingDust(@NotNull NamespaceID namespace, int id, @NotNull net.minestom.server.instance.block.Block block) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public FallingDust withBlock(@NotNull net.minestom.server.instance.block.Block block) {
            return new FallingDust(this.namespace(), this.id(), block);
        }

        @Override
        @NotNull
        public FallingDust readData(@NotNull NetworkBuffer reader) {
            short blockState = reader.read(NetworkBuffer.VAR_INT).shortValue();
            net.minestom.server.instance.block.Block block = net.minestom.server.instance.block.Block.fromStateId(blockState);
            Check.stateCondition(block == null, "Block state " + blockState + " is invalid");
            return this.withBlock(block);
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.block.stateId());
        }

        @Override
        @NotNull
        public CompoundBinaryTag toNbt() {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("type", this.namespace.asString())).putString("block_state", BlockUtils.toString(this.block))).build();
        }
    }

    public record DustPillar(@NotNull NamespaceID namespace, int id, @NotNull net.minestom.server.instance.block.Block block) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public DustPillar withBlock(@NotNull net.minestom.server.instance.block.Block block) {
            return new DustPillar(this.namespace(), this.id(), block);
        }

        @Override
        @NotNull
        public DustPillar readData(@NotNull NetworkBuffer reader) {
            short blockState = reader.read(NetworkBuffer.VAR_INT).shortValue();
            net.minestom.server.instance.block.Block block = net.minestom.server.instance.block.Block.fromStateId(blockState);
            Check.stateCondition(block == null, "Block state " + blockState + " is invalid");
            return this.withBlock(block);
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.block.stateId());
        }

        @Override
        @NotNull
        public CompoundBinaryTag toNbt() {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("type", this.namespace.asString())).putString("block_state", BlockUtils.toString(this.block))).build();
        }
    }

    public record DustColorTransition(@NotNull NamespaceID namespace, int id, @NotNull RGBLike color, @NotNull RGBLike transitionColor, float scale) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public DustColorTransition withProperties(@NotNull RGBLike color, @NotNull RGBLike transitionColor, float scale) {
            return new DustColorTransition(this.namespace, this.id, color, transitionColor, scale);
        }

        @Contract(pure=true)
        @NotNull
        public DustColorTransition withColor(@NotNull RGBLike color) {
            return this.withProperties(color, this.transitionColor, this.scale);
        }

        @Contract(pure=true)
        @NotNull
        public DustColorTransition withScale(float scale) {
            return this.withProperties(this.color, this.transitionColor, scale);
        }

        @Contract(pure=true)
        @NotNull
        public DustColorTransition withTransitionColor(@NotNull RGBLike transitionColor) {
            return this.withProperties(this.color, transitionColor, this.scale);
        }

        @Override
        @NotNull
        public DustColorTransition readData(@NotNull NetworkBuffer reader) {
            return this.withProperties(reader.read(Color.NETWORK_TYPE), reader.read(Color.NETWORK_TYPE), reader.read(NetworkBuffer.FLOAT).floatValue());
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(Color.NETWORK_TYPE, this.color);
            writer.write(Color.NETWORK_TYPE, this.transitionColor);
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.scale));
        }

        @Override
        @NotNull
        public CompoundBinaryTag toNbt() {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("type", this.namespace.asString())).putFloat("scale", this.scale)).put("from_color", Color.NBT_TYPE.write(this.color))).put("to_color", Color.NBT_TYPE.write(this.transitionColor))).build();
        }
    }

    public record Dust(@NotNull NamespaceID namespace, int id, @NotNull RGBLike color, float scale) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public Dust withProperties(@NotNull RGBLike color, float scale) {
            return new Dust(this.namespace(), this.id(), color, scale);
        }

        @Contract(pure=true)
        @NotNull
        public Dust withColor(@NotNull RGBLike color) {
            return this.withProperties(color, this.scale);
        }

        @Contract(pure=true)
        @NotNull
        public Dust withScale(float scale) {
            return this.withProperties(this.color, scale);
        }

        @Override
        @NotNull
        public Dust readData(@NotNull NetworkBuffer reader) {
            return this.withProperties(reader.read(Color.NETWORK_TYPE), reader.read(NetworkBuffer.FLOAT).floatValue());
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(Color.NETWORK_TYPE, this.color);
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.scale));
        }

        @Override
        @NotNull
        public CompoundBinaryTag toNbt() {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("type", this.namespace.asString())).put("color", Color.NBT_TYPE.write(this.color))).putFloat("scale", this.scale)).build();
        }
    }

    public record BlockMarker(@NotNull NamespaceID namespace, int id, @NotNull net.minestom.server.instance.block.Block block) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public BlockMarker withBlock(@NotNull net.minestom.server.instance.block.Block block) {
            return new BlockMarker(this.namespace(), this.id(), block);
        }

        @Override
        @NotNull
        public BlockMarker readData(@NotNull NetworkBuffer reader) {
            short blockState = reader.read(NetworkBuffer.VAR_INT).shortValue();
            net.minestom.server.instance.block.Block block = net.minestom.server.instance.block.Block.fromStateId(blockState);
            Check.stateCondition(block == null, "Block state " + blockState + " is invalid");
            return this.withBlock(block);
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.block.stateId());
        }

        @Override
        @NotNull
        public CompoundBinaryTag toNbt() {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("type", this.namespace.asString())).putString("block_state", BlockUtils.toString(this.block))).build();
        }
    }

    public record Block(@NotNull NamespaceID namespace, int id, @NotNull net.minestom.server.instance.block.Block block) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public Block withBlock(@NotNull net.minestom.server.instance.block.Block block) {
            return new Block(this.namespace(), this.id(), block);
        }

        @Override
        @NotNull
        public Block readData(@NotNull NetworkBuffer reader) {
            short blockState = reader.read(NetworkBuffer.VAR_INT).shortValue();
            net.minestom.server.instance.block.Block block = net.minestom.server.instance.block.Block.fromStateId(blockState);
            Check.stateCondition(block == null, "Block state " + blockState + " is invalid");
            return this.withBlock(block);
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.block.stateId());
        }

        @Override
        @NotNull
        public CompoundBinaryTag toNbt() {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("type", this.namespace.asString())).putString("block_state", BlockUtils.toString(this.block))).build();
        }
    }

    public record Simple(@NotNull NamespaceID namespace, int id) implements Particle
    {
        @Override
        @NotNull
        public Particle readData(@NotNull NetworkBuffer reader) {
            return this;
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
        }

        @Override
        @NotNull
        public CompoundBinaryTag toNbt() {
            return ((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("type", this.namespace.asString())).build();
        }
    }
}

