/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.item.ItemComponent;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;

public record WindowItemsPacket(int windowId, int stateId, @NotNull List<ItemStack> items, @NotNull ItemStack carriedItem) implements ServerPacket.Play,
ServerPacket.ComponentHolding
{
    public static final int MAX_ENTRIES = 128;
    public static final NetworkBuffer.Type<WindowItemsPacket> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.VAR_INT, WindowItemsPacket::windowId, NetworkBuffer.VAR_INT, WindowItemsPacket::stateId, ItemStack.NETWORK_TYPE.list(128), WindowItemsPacket::items, ItemStack.NETWORK_TYPE, WindowItemsPacket::carriedItem, WindowItemsPacket::new);

    public WindowItemsPacket(int windowId, int stateId, @NotNull List<ItemStack> items, @NotNull ItemStack carriedItem) {
        items = List.copyOf(items);
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(this.items);
        list.add(this.carriedItem);
        ArrayList<Component> components = new ArrayList<Component>();
        list.forEach(itemStack -> {
            Component itemName;
            components.addAll(itemStack.get(ItemComponent.LORE, List.of()));
            Component customName = itemStack.get(ItemComponent.CUSTOM_NAME);
            if (customName != null) {
                components.add(customName);
            }
            if ((itemName = itemStack.get(ItemComponent.ITEM_NAME)) != null) {
                components.add(itemName);
            }
        });
        return components;
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        UnaryOperator loreOperator = lines -> {
            ArrayList translatedComponents = new ArrayList();
            lines.forEach(component -> translatedComponents.add((Component)operator.apply((Component)component)));
            return translatedComponents;
        };
        return new WindowItemsPacket(this.windowId, this.stateId, this.items.stream().map(stack -> stack.with(ItemComponent.ITEM_NAME, operator).with(ItemComponent.CUSTOM_NAME, operator).with(ItemComponent.LORE, loreOperator)).toList(), this.carriedItem.with(ItemComponent.ITEM_NAME, operator).with(ItemComponent.CUSTOM_NAME, operator).with(ItemComponent.LORE, loreOperator));
    }
}

