/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Point;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.utils.MathUtils;

public record EntityVelocityPacket(int entityId, short velocityX, short velocityY, short velocityZ) implements ServerPacket.Play
{
    public static final NetworkBuffer.Type<EntityVelocityPacket> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.VAR_INT, EntityVelocityPacket::entityId, NetworkBuffer.SHORT, EntityVelocityPacket::velocityX, NetworkBuffer.SHORT, EntityVelocityPacket::velocityY, NetworkBuffer.SHORT, EntityVelocityPacket::velocityZ, EntityVelocityPacket::new);

    public EntityVelocityPacket(int entityId, Point velocity) {
        this(entityId, (short)MathUtils.clamp(velocity.x(), -32768.0, 32767.0), (short)MathUtils.clamp(velocity.y(), -32768.0, 32767.0), (short)MathUtils.clamp(velocity.z(), -32768.0, 32767.0));
    }
}

