/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minestom.server.adventure.serializer.nbt.NbtComponentSerializer;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTypeImpl;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

record ComponentNetworkBufferTypeImpl() implements NetworkBufferTypeImpl<Component>
{
    private static final byte TAG_END = 0;
    private static final byte TAG_BYTE = 1;
    private static final byte TAG_INT = 3;
    private static final byte TAG_STRING = 8;
    private static final byte TAG_LIST = 9;
    private static final byte TAG_COMPOUND = 10;

    @Override
    public void write(@NotNull NetworkBuffer buffer, @NotNull Component value) {
        Check.notNull(value, "Component cannot be null");
        buffer.write(NetworkBuffer.BYTE, (byte)10);
        this.writeInnerComponent(buffer, value);
    }

    @Override
    public Component read(@NotNull NetworkBuffer buffer) {
        BinaryTag nbt = buffer.read(NetworkBuffer.NBT);
        return NbtComponentSerializer.nbt().deserialize(nbt);
    }

    private void writeInnerComponent(@NotNull NetworkBuffer buffer, @NotNull Component component) {
        buffer.write(NetworkBuffer.BYTE, (byte)8);
        buffer.write(NetworkBuffer.STRING_IO_UTF8, "type");
        Component component2 = component;
        Objects.requireNonNull(component2);
        Component component3 = component2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextComponent.class, TranslatableComponent.class, ScoreComponent.class, SelectorComponent.class, KeybindComponent.class, NBTComponent.class}, (Object)component3, n)) {
            case 0: {
                TextComponent text = (TextComponent)component3;
                buffer.write(NetworkBuffer.STRING_IO_UTF8, "text");
                buffer.write(NetworkBuffer.BYTE, (byte)8);
                buffer.write(NetworkBuffer.STRING_IO_UTF8, "text");
                buffer.write(NetworkBuffer.STRING_IO_UTF8, text.content());
                break;
            }
            case 1: {
                List args;
                TranslatableComponent translatable = (TranslatableComponent)component3;
                buffer.write(NetworkBuffer.STRING_IO_UTF8, "translatable");
                buffer.write(NetworkBuffer.BYTE, (byte)8);
                buffer.write(NetworkBuffer.STRING_IO_UTF8, "translate");
                buffer.write(NetworkBuffer.STRING_IO_UTF8, translatable.key());
                String fallback = translatable.fallback();
                if (fallback != null) {
                    buffer.write(NetworkBuffer.BYTE, (byte)8);
                    buffer.write(NetworkBuffer.STRING_IO_UTF8, "fallback");
                    buffer.write(NetworkBuffer.STRING_IO_UTF8, fallback);
                }
                if ((args = translatable.arguments()).isEmpty()) break;
                buffer.write(NetworkBuffer.BYTE, (byte)9);
                buffer.write(NetworkBuffer.STRING_IO_UTF8, "with");
                buffer.write(NetworkBuffer.BYTE, (byte)10);
                buffer.write(NetworkBuffer.INT, args.size());
                for (TranslationArgument arg : args) {
                    this.writeInnerComponent(buffer, arg.asComponent());
                }
                break;
            }
            case 2: {
                ScoreComponent score = (ScoreComponent)component3;
                buffer.write(NetworkBuffer.STRING_IO_UTF8, "score");
                buffer.write(NetworkBuffer.BYTE, (byte)10);
                buffer.write(NetworkBuffer.STRING_IO_UTF8, "score");
                buffer.write(NetworkBuffer.BYTE, (byte)8);
                buffer.write(NetworkBuffer.STRING_IO_UTF8, "name");
                buffer.write(NetworkBuffer.STRING_IO_UTF8, score.name());
                buffer.write(NetworkBuffer.BYTE, (byte)8);
                buffer.write(NetworkBuffer.STRING_IO_UTF8, "objective");
                buffer.write(NetworkBuffer.STRING_IO_UTF8, score.objective());
                buffer.write(NetworkBuffer.BYTE, (byte)0);
                break;
            }
            case 3: {
                SelectorComponent selector = (SelectorComponent)component3;
                buffer.write(NetworkBuffer.STRING_IO_UTF8, "selector");
                buffer.write(NetworkBuffer.BYTE, (byte)8);
                buffer.write(NetworkBuffer.STRING_IO_UTF8, "selector");
                buffer.write(NetworkBuffer.STRING_IO_UTF8, selector.pattern());
                Component separator = selector.separator();
                if (separator == null) break;
                buffer.write(NetworkBuffer.BYTE, (byte)10);
                buffer.write(NetworkBuffer.STRING_IO_UTF8, "separator");
                this.writeInnerComponent(buffer, separator);
                break;
            }
            case 4: {
                KeybindComponent keybind = (KeybindComponent)component3;
                buffer.write(NetworkBuffer.STRING_IO_UTF8, "keybind");
                buffer.write(NetworkBuffer.BYTE, (byte)8);
                buffer.write(NetworkBuffer.STRING_IO_UTF8, "keybind");
                buffer.write(NetworkBuffer.STRING_IO_UTF8, keybind.keybind());
                break;
            }
            case 5: {
                NBTComponent nbt = (NBTComponent)component3;
                throw new UnsupportedOperationException("NBTComponent is not implemented yet");
            }
            default: {
                throw new UnsupportedOperationException("Unsupported component type: " + String.valueOf(component.getClass()));
            }
        }
        if (!component.children().isEmpty()) {
            buffer.write(NetworkBuffer.BYTE, (byte)9);
            buffer.write(NetworkBuffer.STRING_IO_UTF8, "extra");
            buffer.write(NetworkBuffer.BYTE, (byte)10);
            buffer.write(NetworkBuffer.INT, component.children().size());
            for (Component child : component.children()) {
                this.writeInnerComponent(buffer, child);
            }
        }
        this.writeComponentStyle(buffer, component.style());
        buffer.write(NetworkBuffer.BYTE, (byte)0);
    }

    private void writeComponentStyle(@NotNull NetworkBuffer buffer, @NotNull Style style) {
        HoverEvent hoverEvent;
        ClickEvent clickEvent;
        String insertion;
        TextDecoration.State obfuscated;
        TextDecoration.State strikethrough;
        TextDecoration.State underlined;
        TextDecoration.State italic;
        TextDecoration.State bold;
        Key font;
        TextColor color = style.color();
        if (color != null) {
            buffer.write(NetworkBuffer.BYTE, (byte)8);
            buffer.write(NetworkBuffer.STRING_IO_UTF8, "color");
            if (color instanceof NamedTextColor) {
                NamedTextColor namedColor = (NamedTextColor)color;
                buffer.write(NetworkBuffer.STRING_IO_UTF8, namedColor.toString());
            } else {
                buffer.write(NetworkBuffer.STRING_IO_UTF8, color.asHexString());
            }
        }
        if ((font = style.font()) != null) {
            buffer.write(NetworkBuffer.BYTE, (byte)8);
            buffer.write(NetworkBuffer.STRING_IO_UTF8, "font");
            buffer.write(NetworkBuffer.STRING_IO_UTF8, font.asString());
        }
        if ((bold = style.decoration(TextDecoration.BOLD)) != TextDecoration.State.NOT_SET) {
            buffer.write(NetworkBuffer.BYTE, (byte)1);
            buffer.write(NetworkBuffer.STRING_IO_UTF8, "bold");
            buffer.write(NetworkBuffer.BYTE, bold == TextDecoration.State.TRUE ? (byte)1 : 0);
        }
        if ((italic = style.decoration(TextDecoration.ITALIC)) != TextDecoration.State.NOT_SET) {
            buffer.write(NetworkBuffer.BYTE, (byte)1);
            buffer.write(NetworkBuffer.STRING_IO_UTF8, "italic");
            buffer.write(NetworkBuffer.BYTE, italic == TextDecoration.State.TRUE ? (byte)1 : 0);
        }
        if ((underlined = style.decoration(TextDecoration.UNDERLINED)) != TextDecoration.State.NOT_SET) {
            buffer.write(NetworkBuffer.BYTE, (byte)1);
            buffer.write(NetworkBuffer.STRING_IO_UTF8, "underlined");
            buffer.write(NetworkBuffer.BYTE, underlined == TextDecoration.State.TRUE ? (byte)1 : 0);
        }
        if ((strikethrough = style.decoration(TextDecoration.STRIKETHROUGH)) != TextDecoration.State.NOT_SET) {
            buffer.write(NetworkBuffer.BYTE, (byte)1);
            buffer.write(NetworkBuffer.STRING_IO_UTF8, "strikethrough");
            buffer.write(NetworkBuffer.BYTE, strikethrough == TextDecoration.State.TRUE ? (byte)1 : 0);
        }
        if ((obfuscated = style.decoration(TextDecoration.OBFUSCATED)) != TextDecoration.State.NOT_SET) {
            buffer.write(NetworkBuffer.BYTE, (byte)1);
            buffer.write(NetworkBuffer.STRING_IO_UTF8, "obfuscated");
            buffer.write(NetworkBuffer.BYTE, obfuscated == TextDecoration.State.TRUE ? (byte)1 : 0);
        }
        if ((insertion = style.insertion()) != null) {
            buffer.write(NetworkBuffer.BYTE, (byte)8);
            buffer.write(NetworkBuffer.STRING_IO_UTF8, "insertion");
            buffer.write(NetworkBuffer.STRING_IO_UTF8, insertion);
        }
        if ((clickEvent = style.clickEvent()) != null) {
            this.writeClickEvent(buffer, clickEvent);
        }
        if ((hoverEvent = style.hoverEvent()) != null) {
            this.writeHoverEvent(buffer, hoverEvent);
        }
    }

    private void writeClickEvent(@NotNull NetworkBuffer buffer, @NotNull ClickEvent clickEvent) {
        buffer.write(NetworkBuffer.BYTE, (byte)10);
        buffer.write(NetworkBuffer.STRING_IO_UTF8, "clickEvent");
        buffer.write(NetworkBuffer.BYTE, (byte)8);
        buffer.write(NetworkBuffer.STRING_IO_UTF8, "action");
        buffer.write(NetworkBuffer.STRING_IO_UTF8, clickEvent.action().name().toLowerCase(Locale.ROOT));
        buffer.write(NetworkBuffer.BYTE, (byte)8);
        buffer.write(NetworkBuffer.STRING_IO_UTF8, "value");
        buffer.write(NetworkBuffer.STRING_IO_UTF8, clickEvent.value());
        buffer.write(NetworkBuffer.BYTE, (byte)0);
    }

    private void writeHoverEvent(@NotNull NetworkBuffer buffer, @NotNull HoverEvent<?> hoverEvent) {
        buffer.write(NetworkBuffer.BYTE, (byte)10);
        buffer.write(NetworkBuffer.STRING_IO_UTF8, "hoverEvent");
        buffer.write(NetworkBuffer.BYTE, (byte)8);
        buffer.write(NetworkBuffer.STRING_IO_UTF8, "action");
        buffer.write(NetworkBuffer.STRING_IO_UTF8, hoverEvent.action().toString().toLowerCase(Locale.ROOT));
        buffer.write(NetworkBuffer.BYTE, (byte)10);
        buffer.write(NetworkBuffer.STRING_IO_UTF8, "contents");
        if (hoverEvent.action() == HoverEvent.Action.SHOW_TEXT) {
            this.writeInnerComponent(buffer, (Component)hoverEvent.value());
        } else if (hoverEvent.action() == HoverEvent.Action.SHOW_ITEM) {
            HoverEvent.ShowItem value = (HoverEvent.ShowItem)hoverEvent.value();
            buffer.write(NetworkBuffer.BYTE, (byte)8);
            buffer.write(NetworkBuffer.STRING_IO_UTF8, "id");
            buffer.write(NetworkBuffer.STRING_IO_UTF8, value.item().asString());
            buffer.write(NetworkBuffer.BYTE, (byte)3);
            buffer.write(NetworkBuffer.STRING_IO_UTF8, "count");
            buffer.write(NetworkBuffer.INT, value.count());
            buffer.write(NetworkBuffer.BYTE, (byte)10);
            buffer.write(NetworkBuffer.STRING_IO_UTF8, "components");
            buffer.write(NetworkBuffer.BYTE, (byte)0);
            buffer.write(NetworkBuffer.BYTE, (byte)0);
        } else if (hoverEvent.action() == HoverEvent.Action.SHOW_ENTITY) {
            HoverEvent.ShowEntity value = (HoverEvent.ShowEntity)hoverEvent.value();
            Component name = value.name();
            if (name != null) {
                buffer.write(NetworkBuffer.BYTE, (byte)10);
                buffer.write(NetworkBuffer.STRING_IO_UTF8, "name");
                this.writeInnerComponent(buffer, name);
            }
            buffer.write(NetworkBuffer.BYTE, (byte)8);
            buffer.write(NetworkBuffer.STRING_IO_UTF8, "type");
            buffer.write(NetworkBuffer.STRING_IO_UTF8, value.type().asString());
            buffer.write(NetworkBuffer.BYTE, (byte)8);
            buffer.write(NetworkBuffer.STRING_IO_UTF8, "id");
            buffer.write(NetworkBuffer.STRING_IO_UTF8, value.id().toString());
            buffer.write(NetworkBuffer.BYTE, (byte)0);
        } else {
            throw new UnsupportedOperationException("Unknown hover event action: " + String.valueOf(hoverEvent.action()));
        }
        buffer.write(NetworkBuffer.BYTE, (byte)0);
    }
}

