/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.enchant;

import java.util.List;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.NumberBinaryTag;
import net.minestom.server.gamedata.DataPack;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface LevelBasedValue {
    @NotNull
    public static final BinaryTagSerializer<LevelBasedValue> TAGGED_NBT_TYPE = BinaryTagSerializer.registryTaggedUnion(Registries::enchantmentLevelBasedValues, LevelBasedValue::nbtType, "type");
    @NotNull
    public static final BinaryTagSerializer<LevelBasedValue> NBT_TYPE = new BinaryTagSerializer<LevelBasedValue>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull BinaryTagSerializer.Context context, @NotNull LevelBasedValue value) {
            if (value instanceof Constant) {
                Constant constant = (Constant)value;
                return FloatBinaryTag.floatBinaryTag((float)constant.value);
            }
            return TAGGED_NBT_TYPE.write(context, value);
        }

        @Override
        @NotNull
        public LevelBasedValue read(@NotNull BinaryTagSerializer.Context context, @NotNull BinaryTag tag) {
            if (tag instanceof NumberBinaryTag) {
                NumberBinaryTag number = (NumberBinaryTag)tag;
                return new Constant(number.floatValue());
            }
            return TAGGED_NBT_TYPE.read(context, tag);
        }
    };

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<BinaryTagSerializer<? extends LevelBasedValue>> createDefaultRegistry() {
        DynamicRegistry<BinaryTagSerializer<? extends LevelBasedValue>> registry = DynamicRegistry.create("minestom:enchantment_value_effect");
        registry.register("linear", Linear.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("clamped", Clamped.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("fraction", Fraction.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("levels_squared", LevelsSquared.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("lookup", Lookup.NBT_TYPE, DataPack.MINECRAFT_CORE);
        return registry;
    }

    public float calc(int var1);

    @NotNull
    public BinaryTagSerializer<? extends LevelBasedValue> nbtType();

    public record Linear(float base, float perLevelAboveFirst) implements LevelBasedValue
    {
        public static final BinaryTagSerializer<Linear> NBT_TYPE = BinaryTagSerializer.object("base", BinaryTagSerializer.FLOAT, Linear::base, "per_level_above_first", BinaryTagSerializer.FLOAT, Linear::perLevelAboveFirst, Linear::new);

        @Override
        public float calc(int level) {
            return this.base + this.perLevelAboveFirst * (float)(level - 1);
        }

        @NotNull
        public BinaryTagSerializer<Linear> nbtType() {
            return NBT_TYPE;
        }
    }

    public record Clamped(@NotNull LevelBasedValue value, float min, float max) implements LevelBasedValue
    {
        public static final BinaryTagSerializer<Clamped> NBT_TYPE = BinaryTagSerializer.object("value", NBT_TYPE, Clamped::value, "min", BinaryTagSerializer.FLOAT, Clamped::min, "max", BinaryTagSerializer.FLOAT, Clamped::max, Clamped::new);

        @Override
        public float calc(int level) {
            return MathUtils.clamp(this.value.calc(level), this.min, this.max);
        }

        @NotNull
        public BinaryTagSerializer<Clamped> nbtType() {
            return NBT_TYPE;
        }
    }

    public record Fraction(@NotNull LevelBasedValue numerator, @NotNull LevelBasedValue denominator) implements LevelBasedValue
    {
        public static final BinaryTagSerializer<Fraction> NBT_TYPE = BinaryTagSerializer.object("numerator", NBT_TYPE, Fraction::numerator, "denominator", NBT_TYPE, Fraction::denominator, Fraction::new);

        @Override
        public float calc(int level) {
            float denominator = this.denominator.calc(level);
            return denominator == 0.0f ? 0.0f : this.numerator.calc(level) / denominator;
        }

        @NotNull
        public BinaryTagSerializer<Fraction> nbtType() {
            return NBT_TYPE;
        }
    }

    public record LevelsSquared(float added) implements LevelBasedValue
    {
        public static final BinaryTagSerializer<LevelsSquared> NBT_TYPE = BinaryTagSerializer.object("added", BinaryTagSerializer.FLOAT, LevelsSquared::added, LevelsSquared::new);

        @Override
        public float calc(int level) {
            return (float)(level * level) + this.added;
        }

        @NotNull
        public BinaryTagSerializer<LevelsSquared> nbtType() {
            return NBT_TYPE;
        }
    }

    public record Lookup(@NotNull List<Float> values, @NotNull LevelBasedValue fallback) implements LevelBasedValue
    {
        public static final BinaryTagSerializer<Lookup> NBT_TYPE = BinaryTagSerializer.object("values", BinaryTagSerializer.FLOAT.list(), Lookup::values, "fallback", NBT_TYPE, Lookup::fallback, Lookup::new);

        @Override
        public float calc(int level) {
            if (level < 0 || level > this.values.size()) {
                return this.fallback.calc(level);
            }
            return this.values.get(level - 1).floatValue();
        }

        @NotNull
        public BinaryTagSerializer<Lookup> nbtType() {
            return NBT_TYPE;
        }
    }

    public record Constant(float value) implements LevelBasedValue
    {
        @Override
        public float calc(int level) {
            return this.value;
        }

        @NotNull
        public BinaryTagSerializer<Constant> nbtType() {
            throw new UnsupportedOperationException("Constant values are serialized as a special case, see LevelBasedValue.NBT_TYPE");
        }
    }
}

