/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.List;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.text.Component;
import net.minestom.server.item.book.FilteredText;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public record WrittenBookContent(@NotNull FilteredText<String> title, @NotNull String author, int generation, @NotNull List<FilteredText<Component>> pages, boolean resolved) {
    public static final WrittenBookContent EMPTY = new WrittenBookContent(new FilteredText<Object>("", null), "", 0, List.of(), true);
    public static final NetworkBuffer.Type<WrittenBookContent> NETWORK_TYPE = NetworkBufferTemplate.template(FilteredText.STRING_NETWORK_TYPE, WrittenBookContent::title, NetworkBuffer.STRING, WrittenBookContent::author, NetworkBuffer.VAR_INT, WrittenBookContent::generation, FilteredText.COMPONENT_NETWORK_TYPE.list(100), WrittenBookContent::pages, NetworkBuffer.BOOLEAN, WrittenBookContent::resolved, WrittenBookContent::new);
    @NotNull
    public static final BinaryTagSerializer<WrittenBookContent> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(compound -> {
        ListBinaryTag pagesTag = compound.getList("pages");
        List<FilteredText<Component>> pages = pagesTag.stream().map(FilteredText.COMPONENT_NBT_TYPE::read).toList();
        FilteredText<String> title = FilteredText.STRING_NBT_TYPE.read(compound.get("title"));
        String author = compound.getString("author");
        int generation = compound.getInt("generation");
        boolean resolved = compound.getBoolean("resolved");
        return new WrittenBookContent(title, author, generation, pages, resolved);
    }, value -> {
        ListBinaryTag.Builder pagesTag = ListBinaryTag.builder();
        for (FilteredText<Component> page : value.pages) {
            pagesTag.add(FilteredText.COMPONENT_NBT_TYPE.write(page));
        }
        return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("pages", (BinaryTag)pagesTag.build())).put("title", FilteredText.STRING_NBT_TYPE.write(value.title))).putString("author", value.author)).putInt("generation", value.generation)).putBoolean("resolved", value.resolved)).build();
    });

    public WrittenBookContent(@NotNull FilteredText<String> title, @NotNull String author, int generation, @NotNull List<FilteredText<Component>> pages, boolean resolved) {
        pages = List.copyOf(pages);
    }

    public WrittenBookContent(@NotNull String title, @NotNull String author, @NotNull List<Component> pages) {
        this(title, author, 0, pages, true);
    }

    public WrittenBookContent(@NotNull String title, @NotNull String author, int generation, @NotNull List<Component> pages, boolean resolved) {
        this(new FilteredText<Object>(title, null), author, generation, pages.stream().map(page -> new FilteredText<Object>(page, null)).toList(), resolved);
    }
}

