/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.coordinate.Point;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.instance.block.BlockImpl;
import net.minestom.server.instance.block.Blocks;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;

public sealed interface Block
extends StaticProtocolObject,
TagReadable,
Blocks
permits BlockImpl {
    @NotNull
    public static final NetworkBuffer.Type<Block> NETWORK_TYPE = NetworkBuffer.VAR_INT.transform(Block::fromStateId, Block::stateId);

    @Contract(pure=true)
    @NotNull
    public Block withProperty(@NotNull String var1, @NotNull String var2);

    @Contract(pure=true)
    @NotNull
    public Block withProperties(@NotNull @NotNull Map<@NotNull String, @NotNull String> var1);

    @Contract(pure=true)
    @NotNull
    public <T> Block withTag(@NotNull Tag<T> var1, @Nullable T var2);

    @Contract(pure=true)
    @NotNull
    public Block withNbt(@Nullable CompoundBinaryTag var1);

    @Contract(pure=true)
    @NotNull
    public Block withHandler(@Nullable BlockHandler var1);

    @Contract(pure=true)
    @Nullable
    public CompoundBinaryTag nbt();

    @NotNull
    default public CompoundBinaryTag nbtOrEmpty() {
        return Objects.requireNonNullElse(this.nbt(), CompoundBinaryTag.empty());
    }

    @Contract(pure=true)
    default public boolean hasNbt() {
        return this.nbt() != null;
    }

    @Contract(pure=true)
    @Nullable
    public BlockHandler handler();

    @Contract(pure=true)
    public @Unmodifiable @NotNull Map<String, String> properties();

    @Contract(pure=true)
    @NotNull
    public Block defaultState();

    @Contract(pure=true)
    default public String getProperty(@NotNull String property) {
        return this.properties().get(property);
    }

    @Contract(pure=true)
    @NotNull
    public @NotNull Collection<@NotNull Block> possibleStates();

    @Override
    @Contract(pure=true)
    @NotNull
    public Registry.BlockEntry registry();

    @Override
    @NotNull
    default public NamespaceID namespace() {
        return this.registry().namespace();
    }

    @Override
    default public int id() {
        return this.registry().id();
    }

    default public int stateId() {
        return this.registry().stateId();
    }

    default public boolean isAir() {
        return this.registry().isAir();
    }

    default public boolean isSolid() {
        return this.registry().isSolid();
    }

    default public boolean isLiquid() {
        return this.registry().isLiquid();
    }

    default public boolean compare(@NotNull Block block, @NotNull Comparator comparator) {
        return comparator.test(this, block);
    }

    default public boolean compare(@NotNull Block block) {
        return this.compare(block, Comparator.ID);
    }

    @NotNull
    public static @NotNull Collection<@NotNull Block> values() {
        return BlockImpl.values();
    }

    @Nullable
    public static Block fromNamespaceId(@NotNull String namespaceID) {
        return BlockImpl.getSafe(namespaceID);
    }

    @Nullable
    public static Block fromNamespaceId(@NotNull NamespaceID namespaceID) {
        return Block.fromNamespaceId(namespaceID.asString());
    }

    @Nullable
    public static Block fromStateId(int stateId) {
        return BlockImpl.getState(stateId);
    }

    @Nullable
    public static Block fromBlockId(int blockId) {
        return BlockImpl.getId(blockId);
    }

    @FunctionalInterface
    public static interface Comparator
    extends BiPredicate<Block, Block> {
        public static final Comparator IDENTITY = (b1, b2) -> b1 == b2;
        public static final Comparator ID = (b1, b2) -> b1.id() == b2.id();
        public static final Comparator STATE = (b1, b2) -> b1.stateId() == b2.stateId();
    }

    public static interface Getter {
        public @UnknownNullability Block getBlock(int var1, int var2, int var3, @NotNull Condition var4);

        default public @UnknownNullability Block getBlock(@NotNull Point point, @NotNull Condition condition) {
            return this.getBlock(point.blockX(), point.blockY(), point.blockZ(), condition);
        }

        @NotNull
        default public Block getBlock(int x, int y, int z) {
            return Objects.requireNonNull(this.getBlock(x, y, z, Condition.NONE));
        }

        @NotNull
        default public Block getBlock(@NotNull Point point) {
            return Objects.requireNonNull(this.getBlock(point, Condition.NONE));
        }

        public static enum Condition {
            NONE,
            CACHED,
            TYPE;

        }
    }

    public static interface Setter {
        public void setBlock(int var1, int var2, int var3, @NotNull Block var4);

        default public void setBlock(@NotNull Point blockPosition, @NotNull Block block) {
            this.setBlock(blockPosition.blockX(), blockPosition.blockY(), blockPosition.blockZ(), block);
        }
    }
}

