/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extras.query.event;

import java.net.SocketAddress;
import java.util.Objects;
import net.minestom.server.event.trait.CancellableEvent;
import org.jetbrains.annotations.NotNull;

public abstract class QueryEvent<T>
implements CancellableEvent {
    private final SocketAddress sender;
    private final int sessionID;
    private T response;
    private boolean cancelled;

    public QueryEvent(@NotNull SocketAddress sender, int sessionID, @NotNull T response) {
        this.sender = sender;
        this.sessionID = sessionID;
        this.response = response;
        this.cancelled = false;
    }

    public T getQueryResponse() {
        return this.response;
    }

    public void setQueryResponse(@NotNull T response) {
        this.response = Objects.requireNonNull(response, "response");
    }

    @NotNull
    public SocketAddress getSender() {
        return this.sender;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }
}

