/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event.player;

import java.util.ArrayList;
import java.util.Collection;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.minestom.server.entity.Player;
import net.minestom.server.event.trait.CancellableEvent;
import net.minestom.server.event.trait.PlayerInstanceEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerChatEvent
implements PlayerInstanceEvent,
CancellableEvent {
    private final Player player;
    private final Collection<Player> recipients;
    private final String rawMessage;
    private Component formattedMessage;
    private boolean cancelled;

    public PlayerChatEvent(@NotNull Player player, @NotNull Collection<Player> recipients, @NotNull String rawMessage) {
        this.player = player;
        this.recipients = new ArrayList<Player>(recipients);
        this.rawMessage = rawMessage;
        this.formattedMessage = this.buildDefaultChatMessage();
    }

    @NotNull
    public Collection<Player> getRecipients() {
        return this.recipients;
    }

    @NotNull
    public String getRawMessage() {
        return this.rawMessage;
    }

    public Component getFormattedMessage() {
        return this.formattedMessage;
    }

    public void setFormattedMessage(@NotNull Component message) {
        this.formattedMessage = message;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    private Component buildDefaultChatMessage() {
        return Component.translatable((String)"chat.type.text").arguments(new ComponentLike[]{((TextComponent)Component.text((String)this.player.getUsername()).insertion(this.player.getUsername())).hoverEvent((HoverEventSource)this.player), Component.text((String)this.rawMessage)});
    }
}

