/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event.entity;

import net.minestom.server.coordinate.Pos;
import net.minestom.server.entity.Entity;
import net.minestom.server.event.trait.EntityEvent;
import net.minestom.server.utils.position.PositionUtils;
import org.jetbrains.annotations.NotNull;

public class EntityTeleportEvent
implements EntityEvent {
    private final Entity entity;
    private final Pos teleportPosition;
    private final int relativeFlags;

    public EntityTeleportEvent(@NotNull Entity entity, @NotNull Pos teleportPosition, int relativeFlags) {
        this.entity = entity;
        this.teleportPosition = teleportPosition;
        this.relativeFlags = relativeFlags;
    }

    @Override
    @NotNull
    public Entity getEntity() {
        return this.entity;
    }

    @NotNull
    public Pos getNewPosition() {
        return PositionUtils.getPositionWithRelativeFlags(this.getEntity().getPosition(), this.getTeleportPosition(), this.relativeFlags);
    }

    @NotNull
    public Pos getTeleportPosition() {
        return this.teleportPosition;
    }

    public int getRelativeFlags() {
        return this.relativeFlags;
    }
}

