package net.minestom.server.entity;

import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

/**
 * AUTOGENERATED by GenericEnumGenerator
 */
public enum VillagerType implements StaticProtocolObject {
    DESERT(NamespaceID.from("minecraft:desert")),

    JUNGLE(NamespaceID.from("minecraft:jungle")),

    PLAINS(NamespaceID.from("minecraft:plains")),

    SAVANNA(NamespaceID.from("minecraft:savanna")),

    SNOW(NamespaceID.from("minecraft:snow")),

    SWAMP(NamespaceID.from("minecraft:swamp")),

    TAIGA(NamespaceID.from("minecraft:taiga"));

    public static final NetworkBuffer.Type<VillagerType> NETWORK_TYPE = NetworkBuffer.Enum(VillagerType.class);

    public static final BinaryTagSerializer<VillagerType> NBT_TYPE = BinaryTagSerializer.fromEnumKeyed(VillagerType.class);

    private final NamespaceID namespace;

    VillagerType(@NotNull NamespaceID namespace) {
        this.namespace = namespace;
    }

    @NotNull
    @Override
    public NamespaceID namespace() {
        return this.namespace;
    }

    @Override
    public int id() {
        return this.ordinal();
    }
}
