/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.registry.Holder;
import net.minestom.server.registry.HolderSet;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.registry.RegistryTag;
import net.minestom.server.registry.RegistryTagImpl;
import net.minestom.server.registry.RegistryTranscoder;
import net.minestom.server.registry.TagKey;
import net.minestom.server.utils.Either;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RegistryCodecs {
    RegistryCodecs() {
    }

    record HolderSetImpl<T extends Holder<T>>(@NotNull Codec<RegistryTag<T>> tagCodec, @NotNull Codec<T> directCodec) implements Codec<HolderSet<T>>
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<HolderSet<T>> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            List entries;
            Result tagResult = this.tagCodec.decode(coder, value);
            if (tagResult instanceof Result.Ok) {
                RegistryTag registryTag;
                Result.Ok ok = (Result.Ok)tagResult;
                RegistryTag tag = registryTag = (RegistryTag)ok.value();
                return new Result.Ok<HolderSet<T>>(tag);
            }
            Result<List<D>> entriesResult = coder.getList(value);
            if (!(entriesResult instanceof Result.Ok)) return entriesResult.mapError(e -> "Invalid holder set value: " + e).cast();
            Result.Ok ok = (Result.Ok)entriesResult;
            try {
                List list = (List)ok.value();
                entries = list;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            ArrayList<Holder> directEntries = new ArrayList<Holder>(entries.size());
            for (Object entry : entries) {
                Holder holder;
                Result directResult = this.directCodec.decode(coder, entry);
                if (!(directResult instanceof Result.Ok)) return directResult.mapError(e -> "Invalid holder set entry: " + e).cast();
                ok = (Result.Ok)directResult;
                Holder direct = holder = (Holder)ok.value();
                directEntries.add(direct);
            }
            return new Result.Ok<HolderSet<T>>(new HolderSet.Direct(directEntries));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable HolderSet<T> value) {
            Result<Object> result;
            if (value == null) {
                return new Result.Error("null");
            }
            HolderSet<T> holderSet = value;
            Objects.requireNonNull(holderSet);
            HolderSet<T> holderSet2 = holderSet;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RegistryTag.class, HolderSet.Direct.class}, holderSet2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    RegistryTag tag = (RegistryTag)holderSet2;
                    result = this.tagCodec.encode(coder, tag);
                    return result;
                }
                case 1: 
            }
            HolderSet.Direct d = (HolderSet.Direct)holderSet2;
            Transcoder.ListBuilder result2 = coder.createList(d.values().size());
            Iterator iterator = d.values().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    result = new Result.Ok<D>(result2.build());
                    return result;
                }
                Object rawValue = iterator.next();
                Result<D> directResult = this.directCodec.encode(coder, (Holder)rawValue);
                if (!(directResult instanceof Result.Ok)) {
                    result = directResult.mapError(e -> "Invalid holder set entry: " + e).cast();
                    return result;
                }
                Result.Ok ok = (Result.Ok)directResult;
                try {
                    Object t;
                    Object direct = t = ok.value();
                    result2.add(direct);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
    }

    record RegistryTagImpl<T>(@NotNull Registries.Selector<T> selector) implements Codec<RegistryTag<T>>
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<RegistryTag<T>> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            HashSet keys;
            List entries;
            RegistryTranscoder transcoder;
            RegistryTranscoder context = coder instanceof RegistryTranscoder ? (transcoder = (RegistryTranscoder)coder) : null;
            Registry<T> registry = context != null ? this.selector.select(context.registries()) : null;
            Result<String> tagKeyResult = coder.getString(value);
            if (tagKeyResult instanceof Result.Ok) {
                String string;
                Result.Ok ok = (Result.Ok)tagKeyResult;
                String tagKeyStr = string = (String)ok.value();
                if (registry == null || !tagKeyStr.startsWith("#")) return new Result.Ok(RegistryTag.direct(RegistryKey.unsafeOf(tagKeyStr)));
                TagKey tagKey = TagKey.ofHash(tagKeyStr);
                RegistryTag<T> tag = context.init() ? registry.getOrCreateTag(tagKey) : registry.getTag(tagKey);
                return tag != null ? new Result.Ok<RegistryTag<T>>(tag) : new Result.Error("Unknown tag " + String.valueOf(tagKey) + " for registry " + String.valueOf(registry.key()));
            }
            Result entriesResult = coder.getList(value);
            if (!(entriesResult instanceof Result.Ok)) return new Result.Error<RegistryTag<T>>("Invalid tag value: " + String.valueOf(value));
            Result.Ok ok = (Result.Ok)entriesResult;
            try {
                List tag;
                entries = tag = (List)ok.value();
                keys = new HashSet(entries.size());
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            for (Object entry : entries) {
                RegistryKey registryKey;
                String string;
                Result<String> keyResult = coder.getString(entry);
                if (!(keyResult instanceof Result.Ok)) return keyResult.mapError(e -> "Invalid tag entry: " + e).cast();
                Result.Ok ok2 = (Result.Ok)keyResult;
                String key = string = (String)ok2.value();
                RegistryKey registryKey2 = registryKey = registry != null ? registry.getKey(Key.key((String)key)) : RegistryKey.unsafeOf(key);
                if (registryKey == null) {
                    return new Result.Error<RegistryTag<T>>("Unknown key " + key + " for registry " + String.valueOf(registry.key()));
                }
                keys.add(registryKey);
            }
            return new Result.Ok(RegistryTag.direct(keys));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable RegistryTag<T> value) {
            Iterator iterator;
            Transcoder.ListBuilder<D> result;
            Result.Ok<D> ok;
            if (value == null) {
                return new Result.Error("null");
            }
            RegistryTag<T> registryTag = value;
            Objects.requireNonNull(registryTag);
            RegistryTag<T> registryTag2 = registryTag;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RegistryTagImpl.Backed.class, RegistryTagImpl.Empty.class, RegistryTagImpl.Direct.class}, registryTag2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    RegistryTagImpl.Backed backed = (RegistryTagImpl.Backed)registryTag2;
                    ok = new Result.Ok<D>(coder.createString(backed.key().hashedKey()));
                    return ok;
                }
                case 1: {
                    RegistryTagImpl.Empty empty = (RegistryTagImpl.Empty)registryTag2;
                    ok = new Result.Ok<D>(coder.emptyList());
                    return ok;
                }
                case 2: 
            }
            RegistryTagImpl.Direct direct = (RegistryTagImpl.Direct)registryTag2;
            try {
                List list;
                List entries = list = direct.keys();
                if (entries.isEmpty()) {
                    ok = new Result.Ok<D>(coder.emptyList());
                    return ok;
                }
                if (entries.size() == 1) {
                    ok = new Result.Ok<D>(coder.createString(entries.getFirst().key().asString()));
                    return ok;
                }
                result = coder.createList(entries.size());
                iterator = entries.iterator();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            while (true) {
                if (!iterator.hasNext()) {
                    ok = new Result.Ok<D>(result.build());
                    return ok;
                }
                RegistryKey key = iterator.next();
                result.add(coder.createString(key.key().asString()));
            }
        }
    }

    record TagKeyImpl<T>(@NotNull Registries.Selector<T> selector, boolean hash) implements Codec<TagKey<T>>
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<TagKey<T>> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            net.minestom.server.registry.TagKeyImpl tagKey;
            String reference;
            if (!(coder instanceof RegistryTranscoder)) {
                return new Result.Error<TagKey<T>>("Missing registries in transcoder");
            }
            RegistryTranscoder context = (RegistryTranscoder)coder;
            Registry<T> registry = this.selector.select(context.registries());
            Result<String> result = coder.getString(value);
            if (!(result instanceof Result.Ok)) return result.cast();
            Result.Ok ok = (Result.Ok)result;
            try {
                String string;
                reference = string = (String)ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (this.hash) {
                if (reference.length() < 2 || reference.charAt(0) != '#') {
                    return new Result.Error<TagKey<T>>("Invalid tag hash: " + reference);
                }
                reference = reference.substring(1);
            }
            if (registry.getTag(tagKey = new net.minestom.server.registry.TagKeyImpl(Key.key((String)reference))) != null) return new Result.Ok<TagKey<T>>(tagKey);
            return new Result.Error<TagKey<T>>("Unknown tag " + reference + " for registry " + String.valueOf(registry.key()));
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable TagKey<T> value) {
            if (value == null) {
                return new Result.Error("null");
            }
            if (!(coder instanceof RegistryTranscoder)) {
                return new Result.Error("Missing registries in transcoder");
            }
            return new Result.Ok<D>(coder.createString(this.hash ? value.hashedKey() : value.key().asString()));
        }
    }

    record HolderCodec<T>(@NotNull Registries.Selector<T> selector, @NotNull Codec<T> registryCodec) implements Codec<Holder<T>>
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<Holder<T>> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            String reference;
            if (!(coder instanceof RegistryTranscoder)) {
                return new Result.Error<Holder<T>>("Missing registries in transcoder");
            }
            RegistryTranscoder context = (RegistryTranscoder)coder;
            Registry<T> registry = this.selector.select(context.registries());
            Result directResult = this.registryCodec.decode(coder, value);
            if (directResult instanceof Result.Ok) {
                Object t;
                Result.Ok ok = (Result.Ok)directResult;
                Object direct = t = ok.value();
                return new Result.Ok<Holder<T>>((Holder)direct);
            }
            Result<String> referenceResult = coder.getString(value);
            if (!(referenceResult instanceof Result.Ok)) return referenceResult.cast();
            Result.Ok ok = (Result.Ok)referenceResult;
            try {
                String string;
                reference = string = (String)ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            RegistryKey<T> key = registry.getKey(Key.key((String)reference));
            if (key != null) return new Result.Ok<Holder<T>>(key);
            return new Result.Error<Holder<T>>("Unknown key " + reference + " for registry " + String.valueOf(registry.key()));
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable Holder<T> value) {
            Object direct;
            Result<D> result;
            if (value == null) {
                return new Result.Error("null");
            }
            if (!(coder instanceof RegistryTranscoder)) {
                return new Result.Error("Missing registries in transcoder");
            }
            Either<RegistryKey<T>, T> either = value.unwrap();
            Objects.requireNonNull(either);
            Either<RegistryKey<T>, T> either2 = either;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Either.Left.class, Either.Right.class}, either2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Either.Left left = (Either.Left)either2;
                    try {
                        RegistryKey registryKey;
                        RegistryKey key = registryKey = (RegistryKey)left.value();
                        result = new Result.Ok<D>(coder.createString(key.key().asString()));
                        return result;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                case 1: 
            }
            Either.Right right = (Either.Right)either2;
            {
                Object r;
                direct = r = right.value();
            }
            result = this.registryCodec.encode(coder, direct);
            return result;
        }
    }

    record RegistryKeyImpl<T>(@NotNull Registries.Selector<T> selector) implements Codec<RegistryKey<T>>
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<RegistryKey<T>> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            String reference;
            if (!(coder instanceof RegistryTranscoder)) {
                return new Result.Error<RegistryKey<T>>("Missing registries in transcoder");
            }
            RegistryTranscoder context = (RegistryTranscoder)coder;
            Registry<T> registry = this.selector.select(context.registries());
            Result<String> referenceResult = coder.getString(value);
            if (!(referenceResult instanceof Result.Ok)) return referenceResult.cast();
            Result.Ok ok = (Result.Ok)referenceResult;
            try {
                String string;
                reference = string = (String)ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            RegistryKey<T> key = registry.getKey(Key.key((String)reference));
            if (key != null) return new Result.Ok<RegistryKey<T>>(key);
            return new Result.Error<RegistryKey<T>>("Unknown key " + reference + " for registry " + String.valueOf(registry.key()));
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable RegistryKey<T> value) {
            if (value == null) {
                return new Result.Error("null");
            }
            if (!(coder instanceof RegistryTranscoder)) {
                return new Result.Error("Missing registries in transcoder");
            }
            return new Result.Ok<D>(coder.createString(value.key().asString()));
        }
    }
}

