/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerFlag;
import net.minestom.server.Viewable;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Player;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.PacketWriting;
import net.minestom.server.network.packet.server.BufferedPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.player.PlayerSocketConnection;
import net.minestom.server.utils.ObjectPool;
import net.minestom.server.utils.PacketSendingUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PacketViewableUtils {
    private static volatile Map<Viewable, ViewableStorage> storageMap = new WeakHashMap<Viewable, ViewableStorage>();

    public static void prepareViewablePacket(@NotNull Viewable viewable, @NotNull ServerPacket serverPacket, @Nullable Entity entity) {
        if (entity != null && !entity.hasPredictableViewers()) {
            entity.sendPacketToViewers(serverPacket);
            return;
        }
        if (!ServerFlag.VIEWABLE_PACKET) {
            PacketSendingUtils.sendGroupedPacket(viewable.getViewers(), serverPacket, value -> !Objects.equals(value, entity));
            return;
        }
        Player exception = entity instanceof Player ? (Player)entity : null;
        ViewableStorage storage = PacketViewableUtils.retrieveStorage(viewable);
        storage.append(serverPacket, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ViewableStorage retrieveStorage(Viewable viewable) {
        Map<Viewable, ViewableStorage> map = storageMap;
        ViewableStorage storage = map.get(viewable);
        if (storage != null) return storage;
        Class<PacketViewableUtils> clazz = PacketViewableUtils.class;
        synchronized (PacketViewableUtils.class) {
            map = storageMap;
            storage = map.get(viewable);
            if (storage != null) return storage;
            storage = new ViewableStorage();
            map = new WeakHashMap<Viewable, ViewableStorage>(map);
            map.put(viewable, storage);
            storageMap = map;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return storage;
        }
    }

    public static void flush() {
        if (!ServerFlag.VIEWABLE_PACKET) {
            return;
        }
        Map<Viewable, ViewableStorage> map = storageMap;
        map.entrySet().parallelStream().forEach(entry -> ((ViewableStorage)entry.getValue()).process((Viewable)entry.getKey()));
    }

    public static void prepareViewablePacket(@NotNull Viewable viewable, @NotNull ServerPacket serverPacket) {
        PacketViewableUtils.prepareViewablePacket(viewable, serverPacket, null);
    }

    private static final class ViewableStorage {
        private static final ObjectPool<NetworkBuffer> POOL = ObjectPool.pool(() -> NetworkBuffer.resizableBuffer(ServerFlag.POOLED_BUFFER_SIZE, MinecraftServer.process()), NetworkBuffer::clear);
        private final Int2ObjectMap<LongArrayList> entityIdMap = new Int2ObjectOpenHashMap();
        private final NetworkBuffer buffer = POOL.getAndRegister(this);

        private ViewableStorage() {
        }

        private synchronized void append(ServerPacket serverPacket, @Nullable Player exception) {
            long start = this.buffer.writeIndex();
            PacketWriting.writeFramedPacket(this.buffer, ConnectionState.PLAY, serverPacket, MinecraftServer.getCompressionThreshold());
            long end = this.buffer.writeIndex();
            if (exception != null) {
                long offsets = start << 32 | end & 0xFFFFFFFFL;
                LongList list = (LongList)this.entityIdMap.computeIfAbsent(exception.getEntityId(), id -> new LongArrayList());
                list.add(offsets);
            }
        }

        private synchronized void process(Viewable viewable) {
            if (this.buffer.writeIndex() == 0L) {
                return;
            }
            NetworkBuffer copy = this.buffer.copy(0L, this.buffer.writeIndex());
            copy.readOnly();
            viewable.getViewers().forEach(player -> this.processPlayer((Player)player, copy));
            this.buffer.clear();
            this.entityIdMap.clear();
        }

        private void processPlayer(Player player, NetworkBuffer buffer) {
            long capacity = buffer.capacity();
            PlayerConnection connection = player.getPlayerConnection();
            LongArrayList pairs = (LongArrayList)this.entityIdMap.get(player.getEntityId());
            if (pairs == null) {
                ViewableStorage.writeTo(connection, buffer, 0L, capacity);
                return;
            }
            int lastWrite = 0;
            long[] elements = pairs.elements();
            for (int i = 0; i < pairs.size(); ++i) {
                long offsets = elements[i];
                int start = (int)(offsets >> 32);
                if (start != lastWrite) {
                    ViewableStorage.writeTo(connection, buffer, lastWrite, start - lastWrite);
                }
                lastWrite = (int)offsets;
            }
            if (capacity != (long)lastWrite) {
                ViewableStorage.writeTo(connection, buffer, lastWrite, capacity - (long)lastWrite);
            }
        }

        private static void writeTo(PlayerConnection connection, NetworkBuffer buffer, long offset, long length) {
            if (connection instanceof PlayerSocketConnection) {
                PlayerSocketConnection socketConnection = (PlayerSocketConnection)connection;
                socketConnection.sendPacket(new BufferedPacket(buffer, offset, length));
                return;
            }
        }
    }
}

