/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.dialog.Dialog;
import net.minestom.server.gamedata.DataPack;
import net.minestom.server.item.enchant.Enchantment;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.registry.DynamicRegistryImpl;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.RegistryKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface DynamicRegistry<T>
extends Registry<T>
permits DynamicRegistryImpl {
    @SafeVarargs
    @NotNull
    public static <T> DynamicRegistry<T> fromMap(@NotNull Key key, Map.Entry<Key, T> ... entries) {
        DynamicRegistryImpl<T> registry = new DynamicRegistryImpl<T>(key, null);
        for (Map.Entry<Key, T> entry : entries) {
            registry.register(entry.getKey(), entry.getValue(), null);
        }
        return registry.compact();
    }

    @ApiStatus.Internal
    @NotNull
    public static <T> DynamicRegistry<T> create(@NotNull Key key) {
        return new DynamicRegistryImpl(key, null);
    }

    @ApiStatus.Internal
    @NotNull
    public static <T> DynamicRegistry<T> create(@NotNull Key key, @NotNull Codec<T> codec) {
        return new DynamicRegistryImpl<T>(key, codec);
    }

    @ApiStatus.Internal
    @NotNull
    public static <T> DynamicRegistry<T> create(@NotNull Key key, @NotNull Codec<T> codec, @NotNull RegistryData.Resource resource) {
        return DynamicRegistry.create(key, codec, null, resource, null, null);
    }

    @ApiStatus.Internal
    @NotNull
    public static <T> DynamicRegistry<T> create(@NotNull Key key, @NotNull Codec<T> codec, @Nullable Registries registries, @NotNull RegistryData.Resource resource) {
        return DynamicRegistry.create(key, codec, registries, resource, null, null);
    }

    @ApiStatus.Internal
    @NotNull
    public static <T> DynamicRegistry<T> create(@NotNull Key key, @NotNull Codec<T> codec, @Nullable Registries registries, @NotNull RegistryData.Resource resource, @Nullable Comparator<String> idComparator, @Nullable Codec<T> readCodec) {
        DynamicRegistryImpl<T> registry = new DynamicRegistryImpl<T>(key, codec);
        DynamicRegistryImpl.loadStaticJsonRegistry(registries, registry, resource, idComparator, Objects.requireNonNullElse(readCodec, codec));
        return registry.compact();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<Enchantment> createForEnchantmentsWithSelfReferentialLoadingNightmare(@NotNull Key key, @NotNull Codec<Enchantment> codec, @NotNull RegistryData.Resource resource, @NotNull Registries registries) {
        final DynamicRegistryImpl<Enchantment> registry = new DynamicRegistryImpl<Enchantment>(key, codec);
        DynamicRegistryImpl.loadStaticJsonRegistry(new Registries.Delegating(registries){

            @Override
            @NotNull
            public DynamicRegistry<Enchantment> enchantment() {
                return registry;
            }
        }, registry, resource, null, codec);
        return registry.compact();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<Dialog> createForDialogWithSelfReferentialLoadingNightmare(@NotNull Key key, @NotNull Codec<Dialog> codec, @NotNull RegistryData.Resource resource, @NotNull Registries registries) {
        final DynamicRegistryImpl<Dialog> registry = new DynamicRegistryImpl<Dialog>(key, codec);
        DynamicRegistryImpl.loadStaticJsonRegistry(new Registries.Delegating(registries){

            @Override
            @NotNull
            public DynamicRegistry<Dialog> dialog() {
                return registry;
            }
        }, registry, resource, null, codec);
        return registry;
    }

    @NotNull
    default public RegistryKey<T> register(@NotNull String id, @NotNull T object) {
        return this.register(Key.key((String)id), object, null);
    }

    @NotNull
    default public RegistryKey<T> register(@NotNull Key id, @NotNull T object) {
        return this.register(id, object, null);
    }

    @ApiStatus.Internal
    @NotNull
    default public RegistryKey<T> register(@NotNull String id, @NotNull T object, @Nullable DataPack pack) {
        return this.register(Key.key((String)id), object, pack);
    }

    @ApiStatus.Internal
    @NotNull
    public RegistryKey<T> register(@NotNull Key var1, @NotNull T var2, @Nullable DataPack var3);

    public boolean remove(@NotNull Key var1) throws UnsupportedOperationException;

    @ApiStatus.Internal
    @NotNull
    public SendablePacket registryDataPacket(@NotNull Registries var1, boolean var2);
}

