/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.play;

import net.minestom.server.coordinate.Point;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.utils.Rotation;

public record ClientUpdateStructureBlockPacket(Point location, Action action, Mode mode, String name, Point offset, Point size, Mirror mirror, Rotation rotation, String metadata, float integrity, long seed, byte flags) implements ClientPacket
{
    public static final NetworkBuffer.Type<ClientUpdateStructureBlockPacket> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.BLOCK_POSITION, ClientUpdateStructureBlockPacket::location, NetworkBuffer.Enum(Action.class), ClientUpdateStructureBlockPacket::action, NetworkBuffer.Enum(Mode.class), ClientUpdateStructureBlockPacket::mode, NetworkBuffer.STRING, ClientUpdateStructureBlockPacket::name, NetworkBuffer.VECTOR3B, ClientUpdateStructureBlockPacket::offset, NetworkBuffer.VECTOR3B, ClientUpdateStructureBlockPacket::size, NetworkBuffer.Enum(Mirror.class), ClientUpdateStructureBlockPacket::mirror, NetworkBuffer.VAR_INT.transform(ClientUpdateStructureBlockPacket::fromRestrictedRotation, ClientUpdateStructureBlockPacket::toRestrictedRotation), ClientUpdateStructureBlockPacket::rotation, NetworkBuffer.STRING, ClientUpdateStructureBlockPacket::metadata, NetworkBuffer.FLOAT, ClientUpdateStructureBlockPacket::integrity, NetworkBuffer.LONG, ClientUpdateStructureBlockPacket::seed, NetworkBuffer.BYTE, ClientUpdateStructureBlockPacket::flags, ClientUpdateStructureBlockPacket::new);
    public static final byte IGNORE_ENTITIES = 1;
    public static final byte SHOW_AIR = 2;
    public static final byte SHOW_BOUNDING_BOX = 4;
    public static final byte STRICT = 8;

    private static int toRestrictedRotation(Rotation rotation) {
        return switch (rotation) {
            case Rotation.NONE -> 0;
            case Rotation.CLOCKWISE -> 1;
            case Rotation.FLIPPED -> 2;
            case Rotation.COUNTER_CLOCKWISE -> 3;
            default -> throw new IllegalArgumentException("ClientUpdateStructurePacket#rotation must be a valid 90-degree rotation.");
        };
    }

    private static Rotation fromRestrictedRotation(int rotation) {
        return switch (rotation) {
            case 0 -> Rotation.NONE;
            case 1 -> Rotation.CLOCKWISE;
            case 2 -> Rotation.FLIPPED;
            case 3 -> Rotation.COUNTER_CLOCKWISE;
            default -> throw new IllegalArgumentException("ClientUpdateStructurePacket#rotation must be a valid 90-degree rotation.");
        };
    }

    public static enum Action {
        UPDATE_DATA,
        SAVE,
        LOAD,
        DETECT_SIZE;

    }

    public static enum Mode {
        SAVE,
        LOAD,
        CORNER,
        DATA;

    }

    public static enum Mirror {
        NONE,
        LEFT_RIGHT,
        FRONT_BACK;

    }
}

